/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.spies.UniSpyBase;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;

public class UniOnSubscribeSpy<T>
extends UniSpyBase<T> {
    private volatile UniSubscription lastSubscription;

    public UniSubscription lastSubscription() {
        return this.lastSubscription;
    }

    UniOnSubscribeSpy(Uni<T> upstream) {
        super(upstream);
    }

    @Override
    public void reset() {
        super.reset();
        this.lastSubscription = null;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> downstream) {
        this.upstream().onSubscribe().invoke((? super UniSubscription uniSubscription) -> {
            this.incrementInvocationCount();
            this.lastSubscription = uniSubscription;
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "UniOnSubscribeSpy{lastSubscription=" + this.lastSubscription + "} " + super.toString();
    }
}

