/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniOnItemOrFailureConsume;
import io.smallrye.mutiny.operators.uni.UniOnItemOrFailureFlatMap;
import io.smallrye.mutiny.operators.uni.UniOnItemOrFailureMap;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.tuples.Functions;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class UniOnItemOrFailure<T> {
    private final Uni<T> upstream;

    public UniOnItemOrFailure(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(BiConsumer<? super T, Throwable> callback) {
        BiConsumer<? super T, Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onUniCreation(new UniOnItemOrFailureConsume<T>(this.upstream, actual));
    }

    public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super T ignoredItem, Throwable ignoredFailure) -> actual.run());
    }

    public Uni<T> call(BiFunction<? super T, Throwable, Uni<?>> callback) {
        BiFunction actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return this.transformToUni((? super T res, Throwable fail) -> {
            Uni uni = (Uni)actual.apply((Object)res, (Throwable)fail);
            if (uni == null) {
                throw new NullPointerException("The callback produced a `null` uni");
            }
            return uni.onItemOrFailure().transformToUni((? super T ignored, Throwable subFailure) -> {
                if (fail != null && subFailure != null) {
                    return Uni.createFrom().failure(new CompositeException((Throwable)fail, (Throwable)subFailure));
                }
                if (fail != null) {
                    return Uni.createFrom().failure((Throwable)fail);
                }
                if (subFailure != null) {
                    return Uni.createFrom().failure((Throwable)subFailure);
                }
                return Uni.createFrom().item(res);
            });
        });
    }

    public Uni<T> call(Supplier<Uni<?>> callback) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return this.call((? super T ignoredItem, Throwable ignoredFailure) -> (Uni)actual.get());
    }

    @Deprecated
    public Uni<T> invokeUni(BiFunction<? super T, Throwable, Uni<?>> callback) {
        return this.call(callback);
    }

    @Deprecated
    public <R> Uni<R> apply(BiFunction<? super T, Throwable, ? extends R> mapper) {
        return this.transform(mapper);
    }

    public <R> Uni<R> transform(BiFunction<? super T, Throwable, ? extends R> mapper) {
        BiFunction<? super T, Throwable, ? extends R> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniOnItemOrFailureMap<T, R>(this.upstream, actual));
    }

    public <R> Uni<R> transformToUni(BiFunction<? super T, Throwable, Uni<? extends R>> mapper) {
        BiFunction<? super T, Throwable, Uni<? extends R>> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniOnItemOrFailureFlatMap<T, R>(this.upstream, actual));
    }

    @Deprecated
    public <R> Uni<R> produceUni(BiFunction<? super T, Throwable, Uni<? extends R>> mapper) {
        return this.transformToUni(mapper);
    }

    public <R> Uni<R> transformToUni(Functions.TriConsumer<? super T, Throwable, UniEmitter<? super R>> consumer) {
        Functions.TriConsumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.transformToUni((? super T item, Throwable failure) -> Uni.createFrom().emitter(emitter -> {
            try {
                actual.accept((Object)item, (Throwable)failure, (UniEmitter)emitter);
            }
            catch (Throwable e) {
                if (failure != null) {
                    emitter.fail(new CompositeException((Throwable)failure, e));
                }
                emitter.fail(e);
            }
        }));
    }

    @Deprecated
    public <R> Uni<R> produceUni(Functions.TriConsumer<? super T, Throwable, UniEmitter<? super R>> consumer) {
        return this.transformToUni(consumer);
    }
}

