/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.keepalive;

import io.netty.buffer.ByteBuf;
import io.rsocket.keepalive.KeepAliveFramesAcceptor;
import io.rsocket.keepalive.KeepAliveSupport;
import io.rsocket.resume.RSocketSession;
import io.rsocket.resume.ResumableDuplexConnection;
import io.rsocket.resume.ResumeStateHolder;
import java.util.function.Consumer;

public interface KeepAliveHandler {
    public KeepAliveFramesAcceptor start(KeepAliveSupport var1, Consumer<ByteBuf> var2, Consumer<KeepAliveSupport.KeepAlive> var3);

    public static class ResumableKeepAliveHandler
    implements KeepAliveHandler {
        private final ResumableDuplexConnection resumableDuplexConnection;
        private final RSocketSession rSocketSession;
        private final ResumeStateHolder resumeStateHolder;

        public ResumableKeepAliveHandler(ResumableDuplexConnection resumableDuplexConnection, RSocketSession rSocketSession, ResumeStateHolder resumeStateHolder) {
            this.resumableDuplexConnection = resumableDuplexConnection;
            this.rSocketSession = rSocketSession;
            this.resumeStateHolder = resumeStateHolder;
        }

        @Override
        public KeepAliveFramesAcceptor start(KeepAliveSupport keepAliveSupport, Consumer<ByteBuf> onSendKeepAliveFrame, Consumer<KeepAliveSupport.KeepAlive> onTimeout) {
            this.rSocketSession.setKeepAliveSupport(keepAliveSupport);
            return keepAliveSupport.resumeState(this.resumeStateHolder).onSendKeepAliveFrame(onSendKeepAliveFrame).onTimeout(keepAlive -> this.resumableDuplexConnection.disconnect()).start();
        }
    }

    public static class DefaultKeepAliveHandler
    implements KeepAliveHandler {
        @Override
        public KeepAliveFramesAcceptor start(KeepAliveSupport keepAliveSupport, Consumer<ByteBuf> onSendKeepAliveFrame, Consumer<KeepAliveSupport.KeepAlive> onTimeout) {
            return keepAliveSupport.onSendKeepAliveFrame(onSendKeepAliveFrame).onTimeout(onTimeout).start();
        }
    }
}

