/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.matcher;

import io.restassured.internal.matcher.xml.XmlDtdMatcher;
import io.restassured.internal.matcher.xml.XmlXsdMatcher;
import io.restassured.matcher.ResponseAwareMatcher;
import io.restassured.matcher.RestAssuredMatchers;
import io.restassured.module.mockmvc.response.MockMvcResponse;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RestAssuredMockMvcMatchers {
    public static Matcher<String> matchesXsd(String xsd) {
        return RestAssuredMatchers.matchesXsd((String)xsd);
    }

    public static Matcher<String> matchesXsd(InputStream xsd) {
        return RestAssuredMatchers.matchesXsd((InputStream)xsd);
    }

    public static Matcher<String> matchesXsd(Reader xsd) {
        return RestAssuredMatchers.matchesXsd((Reader)xsd);
    }

    public static Matcher<String> matchesXsd(File xsd) {
        return RestAssuredMatchers.matchesXsd((File)xsd);
    }

    public static Matcher<String> matchesXsdInClasspath(String path) {
        return XmlXsdMatcher.matchesXsdInClasspath((String)path);
    }

    public static Matcher<String> matchesDtd(String dtd) {
        return RestAssuredMatchers.matchesDtd((String)dtd);
    }

    public static Matcher<String> matchesDtd(InputStream dtd) {
        return RestAssuredMatchers.matchesDtd((InputStream)dtd);
    }

    public static Matcher<String> matchesDtd(File dtd) {
        return RestAssuredMatchers.matchesDtd((File)dtd);
    }

    public static Matcher<String> matchesDtd(URL url) {
        return RestAssuredMatchers.matchesDtd((URL)url);
    }

    public static Matcher<String> matchesDtdInClasspath(String path) {
        return XmlDtdMatcher.matchesDtdInClasspath((String)path);
    }

    public static ResponseAwareMatcher<MockMvcResponse> equalToPath(final String path) {
        return new ResponseAwareMatcher<MockMvcResponse>(){

            public Matcher<?> matcher(MockMvcResponse response) {
                return Matchers.equalTo((Object)response.path(path, new String[0]));
            }
        };
    }

    public static ResponseAwareMatcher<MockMvcResponse> endsWithPath(final String path) {
        return new ResponseAwareMatcher<MockMvcResponse>(){

            public Matcher<?> matcher(MockMvcResponse response) {
                return Matchers.endsWith((String)((String)response.path(path, new String[0])));
            }
        };
    }

    public static ResponseAwareMatcher<MockMvcResponse> startsWithPath(final String path) {
        return new ResponseAwareMatcher<MockMvcResponse>(){

            public Matcher<?> matcher(MockMvcResponse response) {
                return Matchers.startsWith((String)((String)response.path(path, new String[0])));
            }
        };
    }

    public static ResponseAwareMatcher<MockMvcResponse> containsPath(final String path) {
        return new ResponseAwareMatcher<MockMvcResponse>(){

            public Matcher<?> matcher(MockMvcResponse response) {
                return Matchers.containsString((String)((String)response.path(path, new String[0])));
            }
        };
    }
}

