/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common.http;

import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.registry.ValueRegistry;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.common.http.TestHTTPResourceProvider;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;

public class TestHTTPResourceManager {
    @Deprecated(forRemoval=true, since="3.31")
    public static String getUri() {
        try {
            return (String)ConfigProvider.getConfig().getValue("test.url", String.class);
        }
        catch (IllegalStateException e) {
            return "http://localhost:8080";
        }
    }

    @Deprecated(forRemoval=true, since="3.31")
    public static String getManagementUri() {
        try {
            return (String)ConfigProvider.getConfig().getValue("test.management.url", String.class);
        }
        catch (IllegalStateException e) {
            return "http://localhost:9000";
        }
    }

    @Deprecated(forRemoval=true, since="3.31")
    public static String getSslUri() {
        return (String)ConfigProvider.getConfig().getValue("test.url.ssl", String.class);
    }

    @Deprecated(forRemoval=true, since="3.31")
    public static String getManagementSslUri() {
        return (String)ConfigProvider.getConfig().getValue("test.management.url.ssl", String.class);
    }

    @Deprecated(forRemoval=true, since="3.31")
    public static String getUri(RunningQuarkusApplication application) {
        return (String)application.getConfigValue("test.url", String.class).get();
    }

    @Deprecated(forRemoval=true, since="3.31")
    public static String getSslUri(RunningQuarkusApplication application) {
        return (String)application.getConfigValue("test.url.ssl", String.class).get();
    }

    public static void inject(Object testCase, ValueRegistry valueRegistry) {
        TestHTTPResourceManager.inject(testCase, valueRegistry, TestHttpEndpointProvider.load());
    }

    public static void inject(Object testCase, ValueRegistry valueRegistry, List<Function<Class<?>, String>> endpointProviders) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        Map<Class<?>, TestHTTPResourceProvider<?>> providers = TestHTTPResourceManager.getProviders();
        for (Class<?> c = testCase.getClass(); c != Object.class; c = c.getSuperclass()) {
            TestHTTPEndpoint classEndpointAnnotation = c.getAnnotation(TestHTTPEndpoint.class);
            for (Field f : c.getDeclaredFields()) {
                TestHTTPResource resource = f.getAnnotation(TestHTTPResource.class);
                if (resource == null) continue;
                TestHTTPResourceProvider<?> provider = providers.get(f.getType());
                if (provider == null) {
                    throw new RuntimeException("Unable to inject TestHTTPResource field " + String.valueOf(f) + " as no provider exists for the type");
                }
                Object path = resource.value();
                if (((String)path).startsWith("/")) {
                    path = ((String)path).substring(1);
                }
                String endpointPath = null;
                boolean management = resource.management();
                TestHTTPEndpoint fieldEndpointAnnotation = f.getAnnotation(TestHTTPEndpoint.class);
                if (fieldEndpointAnnotation != null) {
                    endpointPath = TestHTTPResourceManager.getEndpointPath(endpointProviders, f, fieldEndpointAnnotation);
                } else if (classEndpointAnnotation != null) {
                    endpointPath = TestHTTPResourceManager.getEndpointPath(endpointProviders, f, classEndpointAnnotation);
                }
                if (!((String)path).isEmpty() && endpointPath != null) {
                    path = endpointPath.endsWith("/") ? endpointPath + (String)path : endpointPath + "/" + (String)path;
                } else if (endpointPath != null) {
                    path = endpointPath;
                }
                String val = resource.tls() || config.getOptionalValue("quarkus.http.test-ssl-enabled", Boolean.class).orElse(false).booleanValue() ? (management ? TestHTTPResourceManager.testManagementUrlSsl(valueRegistry, config, new String[]{path}) : TestHTTPResourceManager.testUrlSsl(valueRegistry, config, new String[]{path})) : (management ? TestHTTPResourceManager.testManagementUrl(valueRegistry, config, new String[]{path}) : TestHTTPResourceManager.testUrl(valueRegistry, config, new String[]{path}));
                f.setAccessible(true);
                try {
                    f.set(testCase, provider.provide(val, f));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static Map<Class<?>, TestHTTPResourceProvider<?>> getProviders() {
        HashMap map = new HashMap();
        for (TestHTTPResourceProvider i : ServiceLoader.load(TestHTTPResourceProvider.class, TestHTTPResourceProvider.class.getClassLoader())) {
            map.put(i.getProvidedType(), i);
        }
        return Collections.unmodifiableMap(map);
    }

    private static String getEndpointPath(List<Function<Class<?>, String>> endpointProviders, Field field, TestHTTPEndpoint endpointAnnotation) {
        for (Function<Class<?>, String> func : endpointProviders) {
            String endpointPath = func.apply(endpointAnnotation.value());
            if (endpointPath == null) continue;
            return endpointPath;
        }
        throw new RuntimeException("Could not determine the endpoint path for " + String.valueOf(endpointAnnotation.value()) + " to inject " + String.valueOf(field));
    }

    public static String testUrl(ValueRegistry valueRegistry, SmallRyeConfig config, String ... paths) {
        String host = TestHTTPResourceManager.host(config, "quarkus.http.host");
        int port = (Integer)valueRegistry.getOrDefault(ListeningAddress.HTTP_TEST_PORT, (Object)8081);
        String rootPath = TestHTTPResourceManager.rootPath(config, paths);
        return "http://" + host + ":" + port + rootPath;
    }

    public static String testManagementUrl(ValueRegistry valueRegistry, SmallRyeConfig config, String ... paths) {
        String host = TestHTTPResourceManager.host(config, "quarkus.management.host");
        int port = (Integer)valueRegistry.getOrDefault(ValueRegistry.RuntimeKey.intKey((String)"quarkus.management.test-port"), (Object)9001);
        String managementRootPath = TestHTTPResourceManager.managementRootPath(config, paths);
        return "http://" + host + ":" + port + managementRootPath;
    }

    public static String testUrlSsl(ValueRegistry valueRegistry, SmallRyeConfig config, String ... paths) {
        String host = TestHTTPResourceManager.host(config, "quarkus.http.host");
        int port = (Integer)valueRegistry.getOrDefault(ListeningAddress.HTTPS_TEST_PORT, (Object)8444);
        String rootPath = TestHTTPResourceManager.rootPath(config, paths);
        return "https://" + host + ":" + port + rootPath;
    }

    public static String testManagementUrlSsl(ValueRegistry valueRegistry, SmallRyeConfig config, String ... paths) {
        String host = TestHTTPResourceManager.host(config, "quarkus.management.host");
        int port = (Integer)valueRegistry.getOrDefault(ValueRegistry.RuntimeKey.intKey((String)"quarkus.management.test-port"), (Object)9001);
        String managementRootPath = TestHTTPResourceManager.managementRootPath(config, paths);
        return "https://" + host + ":" + port + managementRootPath;
    }

    public static String host(SmallRyeConfig config, String name) {
        String host = config.getOptionalValue(name, String.class).orElse("localhost");
        if (host.equals("0.0.0.0")) {
            host = "localhost";
        }
        return host;
    }

    public static String rootPath(SmallRyeConfig config, String ... paths) {
        String rootPath = config.getOptionalValue("quarkus.http.root-path", String.class).orElse("/");
        Optional contextPath = config.getOptionalValue("quarkus.servlet.context-path", String.class);
        StringBuilder path = new StringBuilder(rootPath);
        if (!rootPath.startsWith("/")) {
            path.insert(0, "/");
        }
        if (!rootPath.endsWith("/")) {
            path.append("/");
        }
        if (contextPath.isPresent()) {
            String relativePath = ((String)contextPath.get()).startsWith("/") ? ((String)contextPath.get()).substring(1) : (String)contextPath.get();
            path.append(relativePath);
            if (!relativePath.endsWith("/")) {
                path.append("/");
            }
        }
        for (String p : paths) {
            String relativePath = p.startsWith("/") ? p.substring(1) : p;
            path.append(relativePath);
        }
        return path.toString();
    }

    public static String managementRootPath(SmallRyeConfig config, String ... paths) {
        String rootPath = config.getOptionalValue("quarkus.management.root-path", String.class).orElse("/q");
        StringBuilder path = new StringBuilder(rootPath);
        if (!rootPath.startsWith("/")) {
            path.insert(0, "/");
        }
        if (!rootPath.endsWith("/")) {
            path.append("/");
        }
        for (String p : paths) {
            String relativePath = p.startsWith("/") ? p.substring(1) : p;
            path.append(relativePath);
        }
        return path.toString();
    }
}

