/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusAsyncExecutorProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusExistingCircuitBreakerNames;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFallbackHandlerProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.quarkus.smallrye.faulttolerance.runtime.SmallRyeFaultToleranceRecorder;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceInterceptor;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.core.util.RunnableWrapper;
import io.smallrye.faulttolerance.internal.RequestContextControllerProvider;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.MetricsProvider;
import io.smallrye.faulttolerance.propagation.ContextPropagationRequestContextControllerProvider;
import io.smallrye.faulttolerance.propagation.ContextPropagationRunnableWrapper;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.DefinitionException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class SmallRyeFaultToleranceProcessor {
    private static final Set<DotName> FT_ANNOTATIONS = new HashSet<DotName>();

    @BuildStep
    public void build(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<BeanDefiningAnnotationBuildItem> additionalBda, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<SystemPropertyBuildItem> systemProperty, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_FAULT_TOLERANCE));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(RequestContextControllerProvider.class.getName(), new String[]{ContextPropagationRequestContextControllerProvider.class.getName()}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(RunnableWrapper.class.getName(), new String[]{ContextPropagationRunnableWrapper.class.getName()}));
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<String> fallbackHandlers = new HashSet<String>();
        for (ClassInfo classInfo : index.getAllKnownImplementors(DotName.createSimple((String)FallbackHandler.class.getName()))) {
            fallbackHandlers.add(classInfo.name().toString());
        }
        if (!fallbackHandlers.isEmpty()) {
            AdditionalBeanBuildItem.Builder fallbackHandlersBeans = AdditionalBeanBuildItem.builder().setDefaultScope(BuiltinScope.DEPENDENT.getName());
            for (String fallbackHandler : fallbackHandlers) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{fallbackHandler}));
                fallbackHandlersBeans.addBeanClass(fallbackHandler);
            }
            additionalBean.produce((BuildItem)fallbackHandlersBeans.build());
        }
        for (AnnotationInstance annotationInstance : index.getAnnotations(DotName.createSimple((String)Fallback.class.getName()))) {
            AnnotationValue fallbackMethodValue = annotationInstance.value("fallbackMethod");
            if (fallbackMethodValue == null) continue;
            String fallbackMethod = fallbackMethodValue.asString();
            ArrayDeque<DotName> classesToScan = new ArrayDeque<DotName>();
            AnnotationTarget target = annotationInstance.target();
            if (target.kind() == AnnotationTarget.Kind.METHOD) {
                classesToScan.add(target.asMethod().declaringClass().name());
            }
            while (!classesToScan.isEmpty()) {
                DotName name = (DotName)classesToScan.poll();
                ClassInfo clazz = index.getClassByName(name);
                if (clazz == null) continue;
                clazz.methods().stream().filter(it -> fallbackMethod.equals(it.name())).forEach(it -> reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem(it)));
                DotName superClass = clazz.superName();
                if (superClass != null && !DotNames.OBJECT.equals((Object)superClass)) {
                    classesToScan.add(superClass);
                }
                classesToScan.addAll(clazz.interfaceNames());
            }
        }
        for (DotName dotName : FT_ANNOTATIONS) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{dotName.toString()}));
            additionalBda.produce((BuildItem)new BeanDefiningAnnotationBuildItem(dotName));
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (FT_ANNOTATIONS.contains(context.getTarget().asClass().name())) {
                    ((Transformation)context.transform().add(FaultToleranceBinding.class, new AnnotationValue[0])).done();
                }
            }
        }));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (DotName ftAnnotation : FT_ANNOTATIONS) {
            builder.addBeanClass(ftAnnotation.toString());
        }
        builder.addBeanClasses(new Class[]{FaultToleranceInterceptor.class, ExecutorHolder.class, StrategyCache.class, QuarkusFaultToleranceOperationProvider.class, QuarkusFallbackHandlerProvider.class, QuarkusExistingCircuitBreakerNames.class, QuarkusAsyncExecutorProvider.class, MetricsProvider.class, CircuitBreakerMaintenanceImpl.class, RequestContextIntegration.class});
        additionalBean.produce((BuildItem)builder.build());
        if (!metricsCapability.isPresent()) {
            systemProperty.produce((BuildItem)new SystemPropertyBuildItem("MP_Fault_Tolerance_Metrics_Enabled", "false"));
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformInterceptorPriority(BeanArchiveIndexBuildItem index) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    if (!ctx.getTarget().asClass().name().toString().equals("io.smallrye.faulttolerance.FaultToleranceInterceptor")) {
                        return;
                    }
                    Config config = ConfigProvider.getConfig();
                    OptionalInt priority = (OptionalInt)config.getValue("mp.fault.tolerance.interceptor.priority", OptionalInt.class);
                    if (priority.isPresent()) {
                        ((Transformation)((Transformation)ctx.transform().remove(ann -> ann.name().toString().equals(Priority.class.getName()))).add(Priority.class, new AnnotationValue[]{AnnotationValue.createIntegerValue((String)"value", (int)priority.getAsInt())})).done();
                    }
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateFaultToleranceAnnotations(SmallRyeFaultToleranceRecorder recorder, ValidationPhaseBuildItem validationPhase, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        HashSet<String> beanNames = new HashSet<String>();
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        for (BeanInfo info : validationPhase.getContext().beans()) {
            if (!this.hasFTAnnotations(index, annotationStore, info.getImplClazz())) continue;
            beanNames.add(info.getBeanClass().toString());
        }
        recorder.createFaultToleranceOperation(beanNames);
        DotName circuitBreakerName = DotName.createSimple((String)CircuitBreakerName.class.getName());
        HashMap<String, Set> existingCircuitBreakerNames = new HashMap<String, Set>();
        for (AnnotationInstance it : index.getAnnotations(circuitBreakerName)) {
            if (it.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo method = it.target().asMethod();
            existingCircuitBreakerNames.computeIfAbsent(it.value().asString(), ignored -> new HashSet()).add(method + " @ " + method.declaringClass());
        }
        ArrayList<DefinitionException> exceptions = new ArrayList<DefinitionException>();
        for (Map.Entry entry : existingCircuitBreakerNames.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            exceptions.add(new DefinitionException("Multiple circuit breakers have the same name '" + (String)entry.getKey() + "': " + entry.getValue()));
        }
        if (!exceptions.isEmpty()) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(exceptions));
        }
        recorder.initExistingCircuitBreakerNames(existingCircuitBreakerNames.keySet());
    }

    private boolean hasFTAnnotations(IndexView index, AnnotationStore annotationStore, ClassInfo info) {
        if (info == null) {
            return false;
        }
        if (annotationStore.hasAnyAnnotation((AnnotationTarget)info, FT_ANNOTATIONS)) {
            return true;
        }
        for (MethodInfo method : info.methods()) {
            if (!annotationStore.hasAnyAnnotation((AnnotationTarget)method, FT_ANNOTATIONS)) continue;
            return true;
        }
        DotName parentClassName = info.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return false;
        }
        ClassInfo parentClassInfo = index.getClassByName(parentClassName);
        if (parentClassInfo == null) {
            return false;
        }
        return this.hasFTAnnotations(index, annotationStore, parentClassInfo);
    }

    @BuildStep
    public ConfigurationTypeBuildItem registerTypes() {
        return new ConfigurationTypeBuildItem(ChronoUnit.class);
    }

    static {
        FT_ANNOTATIONS.add(DotName.createSimple((String)Asynchronous.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Bulkhead.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)CircuitBreaker.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Fallback.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Retry.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Timeout.class.getName()));
    }
}

