/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfigBuilder;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.builders.AuthenticationConfigBuilder;
import io.quarkus.oidc.runtime.builders.LogoutConfigBuilder;
import io.quarkus.oidc.runtime.builders.TokenConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class OidcTenantConfigBuilder
extends OidcClientCommonConfigBuilder<OidcTenantConfigBuilder> {
    private static volatile OidcTenantConfig configWithDefaults = null;
    private Optional<String> tenantId;
    private boolean tenantEnabled;
    private Optional<OidcTenantConfig.ApplicationType> applicationType;
    private Optional<String> authorizationPath;
    private Optional<String> userInfoPath;
    private Optional<String> introspectionPath;
    private Optional<String> jwksPath;
    private Optional<String> endSessionPath;
    private final List<String> tenantPaths = new ArrayList<String>();
    private Optional<String> publicKey;
    private OidcTenantConfig.IntrospectionCredentials introspectionCredentials;
    private OidcTenantConfig.Roles roles;
    private OidcTenantConfig.ResourceMetadata resourceMetadata;
    private Optional<Set<OidcTenantConfig.Authentication.CacheControl>> cacheControl;
    private OidcTenantConfig.CertificateChain certificateChain;
    private OidcTenantConfig.CodeGrant codeGrant;
    private OidcTenantConfig.TokenStateManager tokenStateManager;
    private boolean allowTokenIntrospectionCache;
    private boolean allowUserInfoCache;
    private Optional<Boolean> cacheUserInfoInIdtoken;
    private OidcTenantConfig.Jwks jwks;
    private Optional<OidcTenantConfig.Provider> provider;
    private OidcTenantConfig.Logout logout;
    private OidcTenantConfig.Token token;
    private OidcTenantConfig.Authentication authentication;

    public OidcTenantConfigBuilder() {
        this(OidcTenantConfigBuilder.getConfigWithDefaults());
    }

    public OidcTenantConfigBuilder(OidcTenantConfig mapping) {
        super((OidcClientCommonConfig)Objects.requireNonNull(mapping));
        this.tenantId = mapping.tenantId();
        this.tenantEnabled = mapping.tenantEnabled();
        this.applicationType = mapping.applicationType();
        this.authorizationPath = mapping.authorizationPath();
        this.userInfoPath = mapping.userInfoPath();
        this.introspectionPath = mapping.introspectionPath();
        this.jwksPath = mapping.jwksPath();
        this.endSessionPath = mapping.endSessionPath();
        this.publicKey = mapping.publicKey();
        this.introspectionCredentials = mapping.introspectionCredentials();
        this.roles = mapping.roles();
        this.token = mapping.token();
        this.logout = mapping.logout();
        this.certificateChain = mapping.certificateChain();
        this.resourceMetadata = mapping.resourceMetadata();
        this.authentication = mapping.authentication();
        this.codeGrant = mapping.codeGrant();
        this.tokenStateManager = mapping.tokenStateManager();
        this.allowTokenIntrospectionCache = mapping.allowTokenIntrospectionCache();
        this.allowUserInfoCache = mapping.allowUserInfoCache();
        this.cacheUserInfoInIdtoken = mapping.cacheUserInfoInIdtoken();
        this.jwks = mapping.jwks();
        this.provider = mapping.provider();
        if (mapping.tenantPaths().isPresent()) {
            this.tenantPaths.addAll((Collection<String>)mapping.tenantPaths().get());
        }
    }

    protected OidcTenantConfigBuilder getBuilder() {
        return this;
    }

    public OidcTenantConfigBuilder tenantId(String tenantId) {
        this.tenantId = Optional.ofNullable(tenantId);
        return this;
    }

    public OidcTenantConfigBuilder disableTenant() {
        return this.tenantEnabled(false);
    }

    public OidcTenantConfigBuilder enableTenant() {
        return this.tenantEnabled(true);
    }

    public OidcTenantConfigBuilder tenantEnabled(boolean tenantEnabled) {
        this.tenantEnabled = tenantEnabled;
        return this;
    }

    public OidcTenantConfigBuilder applicationType(OidcTenantConfig.ApplicationType applicationType) {
        this.applicationType = Optional.ofNullable(applicationType);
        return this;
    }

    public OidcTenantConfigBuilder authorizationPath(String authorizationPath) {
        this.authorizationPath = Optional.ofNullable(authorizationPath);
        return this;
    }

    public OidcTenantConfigBuilder userInfoPath(String userInfoPath) {
        this.userInfoPath = Optional.ofNullable(userInfoPath);
        return this;
    }

    public OidcTenantConfigBuilder introspectionPath(String introspectionPath) {
        this.introspectionPath = Optional.ofNullable(introspectionPath);
        return this;
    }

    public OidcTenantConfigBuilder jwksPath(String jwksPath) {
        this.jwksPath = Optional.ofNullable(jwksPath);
        return this;
    }

    public OidcTenantConfigBuilder endSessionPath(String endSessionPath) {
        this.endSessionPath = Optional.ofNullable(endSessionPath);
        return this;
    }

    public OidcTenantConfigBuilder tenantPath(String tenantPath) {
        if (tenantPath != null) {
            this.tenantPaths.add(tenantPath);
        }
        return this;
    }

    public OidcTenantConfigBuilder tenantPaths(String ... tenantPaths) {
        if (tenantPaths != null) {
            this.tenantPaths.addAll(Arrays.asList(tenantPaths));
        }
        return this;
    }

    public OidcTenantConfigBuilder tenantPaths(List<String> tenantPaths) {
        if (tenantPaths != null) {
            this.tenantPaths.addAll(tenantPaths);
        }
        return this;
    }

    public OidcTenantConfigBuilder publicKey(String publicKey) {
        this.publicKey = Optional.ofNullable(publicKey);
        return this;
    }

    public OidcTenantConfigBuilder introspectionCredentials(OidcTenantConfig.IntrospectionCredentials introspectionCredentials) {
        this.introspectionCredentials = Objects.requireNonNull(introspectionCredentials);
        return this;
    }

    public OidcTenantConfigBuilder introspectionCredentials(String name, String secret) {
        return new IntrospectionCredentialsBuilder(this).name(name).secret(secret).end();
    }

    public IntrospectionCredentialsBuilder introspectionCredentials() {
        return new IntrospectionCredentialsBuilder(this);
    }

    public OidcTenantConfigBuilder roles(OidcTenantConfig.Roles roles) {
        this.roles = Objects.requireNonNull(roles);
        return this;
    }

    public RolesBuilder roles() {
        return new RolesBuilder(this);
    }

    public OidcTenantConfigBuilder roles(OidcTenantConfig.Roles.Source source, String ... roleClaimPaths) {
        return this.roles().source(source).roleClaimPath(roleClaimPaths).end();
    }

    public OidcTenantConfigBuilder token(OidcTenantConfig.Token token) {
        this.token = Objects.requireNonNull(token);
        return this;
    }

    public OidcTenantConfigBuilder token(String principalClaim) {
        return this.token().principalClaim(principalClaim).end();
    }

    public TokenConfigBuilder token() {
        return new TokenConfigBuilder(this);
    }

    public OidcTenantConfigBuilder logout(OidcTenantConfig.Logout logout) {
        this.logout = Objects.requireNonNull(logout);
        return this;
    }

    public LogoutConfigBuilder logout() {
        return new LogoutConfigBuilder(this);
    }

    public OidcTenantConfigBuilder resourceMetadata(OidcTenantConfig.ResourceMetadata resourceMetadata) {
        this.resourceMetadata = Objects.requireNonNull(resourceMetadata);
        return this;
    }

    public ResourceMetadataBuilder resourceMetadata() {
        return new ResourceMetadataBuilder(this);
    }

    public OidcTenantConfigBuilder certificateChain(OidcTenantConfig.CertificateChain certificateChain) {
        this.certificateChain = Objects.requireNonNull(certificateChain);
        return this;
    }

    public CertificateChainBuilder certificateChain() {
        return new CertificateChainBuilder(this);
    }

    public OidcTenantConfigBuilder authentication(OidcTenantConfig.Authentication authentication) {
        this.authentication = Objects.requireNonNull(authentication);
        return this;
    }

    public AuthenticationConfigBuilder authentication() {
        return new AuthenticationConfigBuilder(this);
    }

    public OidcTenantConfigBuilder codeGrant(Map<String, String> headers, Map<String, String> extraParams) {
        return this.codeGrant().headers(headers).extraParams(extraParams).end();
    }

    public OidcTenantConfigBuilder codeGrant(Map<String, String> headers) {
        return this.codeGrant().headers(headers).end();
    }

    public CodeGrantBuilder codeGrant() {
        return new CodeGrantBuilder(this);
    }

    public OidcTenantConfigBuilder codeGrant(OidcTenantConfig.CodeGrant codeGrant) {
        this.codeGrant = Objects.requireNonNull(codeGrant);
        return this;
    }

    public OidcTenantConfigBuilder tokenStateManager(OidcTenantConfig.TokenStateManager tokenStateManager) {
        this.tokenStateManager = Objects.requireNonNull(tokenStateManager);
        return this;
    }

    public TokenStateManagerBuilder tokenStateManager() {
        return new TokenStateManagerBuilder(this);
    }

    public OidcTenantConfigBuilder allowTokenIntrospectionCache() {
        return this.allowTokenIntrospectionCache(true);
    }

    public OidcTenantConfigBuilder allowTokenIntrospectionCache(boolean allowTokenIntrospectionCache) {
        this.allowTokenIntrospectionCache = allowTokenIntrospectionCache;
        return this;
    }

    public OidcTenantConfigBuilder allowUserInfoCache(boolean allowUserInfoCache) {
        this.allowUserInfoCache = allowUserInfoCache;
        return this;
    }

    public OidcTenantConfigBuilder allowUserInfoCache() {
        return this.allowUserInfoCache(true);
    }

    public OidcTenantConfigBuilder cacheUserInfoInIdtoken(boolean cacheUserInfoInIdtoken) {
        this.cacheUserInfoInIdtoken = Optional.of(cacheUserInfoInIdtoken);
        return this;
    }

    public OidcTenantConfigBuilder cacheUserInfoInIdtoken() {
        return this.cacheUserInfoInIdtoken(true);
    }

    public OidcTenantConfigBuilder jwks(OidcTenantConfig.Jwks jwks) {
        this.jwks = Objects.requireNonNull(jwks);
        return this;
    }

    public JwksBuilder jwks() {
        return new JwksBuilder(this);
    }

    public OidcTenantConfigBuilder provider(OidcTenantConfig.Provider provider) {
        this.provider = Optional.ofNullable(provider);
        return this;
    }

    public io.quarkus.oidc.OidcTenantConfig build() {
        if (this.tenantId.isEmpty()) {
            this.tenantId("Default");
        }
        OidcTenantConfigImpl mapping = new OidcTenantConfigImpl(this);
        return io.quarkus.oidc.OidcTenantConfig.of(mapping);
    }

    private static OidcTenantConfig getConfigWithDefaults() {
        if (configWithDefaults == null) {
            OidcConfig oidcConfig = (OidcConfig)new SmallRyeConfigBuilder().addDiscoveredConverters().withMapping(OidcConfig.class).build().getConfigMapping(OidcConfig.class);
            configWithDefaults = OidcConfig.getDefaultTenant(oidcConfig);
        }
        return configWithDefaults;
    }

    public OidcTenantConfig.Authentication getAuthentication() {
        return this.authentication;
    }

    public OidcTenantConfig.Token getToken() {
        return this.token;
    }

    public OidcTenantConfig.Logout getLogout() {
        return this.logout;
    }

    public static final class IntrospectionCredentialsBuilder {
        private final OidcTenantConfigBuilder builder;
        private Optional<String> name;
        private Optional<String> secret;
        private boolean includeClientId;

        public IntrospectionCredentialsBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public IntrospectionCredentialsBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            this.name = builder.introspectionCredentials.name();
            this.secret = builder.introspectionCredentials.secret();
            this.includeClientId = builder.introspectionCredentials.includeClientId();
        }

        public IntrospectionCredentialsBuilder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public IntrospectionCredentialsBuilder secret(String secret) {
            this.secret = Optional.ofNullable(secret);
            return this;
        }

        public IntrospectionCredentialsBuilder includeClientId(boolean includeClientId) {
            this.includeClientId = includeClientId;
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.introspectionCredentials(this.build());
        }

        public OidcTenantConfig.IntrospectionCredentials build() {
            return new IntrospectionCredentialsImpl(this.name, this.secret, this.includeClientId);
        }

        private record IntrospectionCredentialsImpl(Optional<String> name, Optional<String> secret, boolean includeClientId) implements OidcTenantConfig.IntrospectionCredentials
        {
        }
    }

    public static final class RolesBuilder {
        private final OidcTenantConfigBuilder builder;
        private final List<String> roleClaimPath = new ArrayList<String>();
        private Optional<String> roleClaimSeparator;
        private Optional<OidcTenantConfig.Roles.Source> source;

        public RolesBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public RolesBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            this.roleClaimSeparator = builder.roles.roleClaimSeparator();
            this.source = builder.roles.source();
            if (builder.roles.roleClaimPath().isPresent()) {
                this.roleClaimPath.addAll((Collection<String>)builder.roles.roleClaimPath().get());
            }
        }

        public RolesBuilder roleClaimSeparator(String separator) {
            this.roleClaimSeparator = Optional.ofNullable(separator);
            return this;
        }

        public RolesBuilder source(OidcTenantConfig.Roles.Source source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        public RolesBuilder roleClaimPath(String ... roleClaimPaths) {
            if (roleClaimPaths != null) {
                this.roleClaimPath.addAll(Arrays.asList(roleClaimPaths));
            }
            return this;
        }

        public RolesBuilder roleClaimPath(List<String> roleClaimPaths) {
            if (roleClaimPaths != null) {
                this.roleClaimPath.addAll(roleClaimPaths);
            }
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.roles(this.build());
        }

        public OidcTenantConfig.Roles build() {
            Optional<List<String>> roleClaimPathOptional = this.roleClaimPath.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.roleClaimPath));
            return new RolesImpl(roleClaimPathOptional, this.roleClaimSeparator, this.source);
        }

        private record RolesImpl(Optional<List<String>> roleClaimPath, Optional<String> roleClaimSeparator, Optional<OidcTenantConfig.Roles.Source> source) implements OidcTenantConfig.Roles
        {
        }
    }

    public static final class ResourceMetadataBuilder {
        private final OidcTenantConfigBuilder builder;
        private boolean enabled;
        private Optional<String> resource;
        private Optional<Set<String>> scopes;
        private Optional<String> authorizationServer;
        private boolean forceHttpsScheme;

        public ResourceMetadataBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public ResourceMetadataBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            this.enabled = builder.resourceMetadata.enabled();
            this.resource = builder.resourceMetadata.resource();
            this.scopes = builder.resourceMetadata.scopes().isEmpty() ? Optional.empty() : Optional.of(Set.copyOf((Collection)builder.resourceMetadata.scopes().get()));
            this.authorizationServer = builder.resourceMetadata.authorizationServer();
            this.forceHttpsScheme = builder.resourceMetadata.forceHttpsScheme();
        }

        public ResourceMetadataBuilder enabled() {
            return this.enabled(true);
        }

        public ResourceMetadataBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ResourceMetadataBuilder resource(String resource) {
            this.resource = Optional.ofNullable(resource);
            return this;
        }

        public ResourceMetadataBuilder scopes(String scope) {
            return this.scopes(Set.of(scope));
        }

        public ResourceMetadataBuilder scopes(Set<String> scopes) {
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        public ResourceMetadataBuilder authorizationServer(String authorizationServer) {
            this.authorizationServer = Optional.ofNullable(authorizationServer);
            return this;
        }

        public ResourceMetadataBuilder forceHttpsScheme() {
            return this.forceHttpsScheme(true);
        }

        public ResourceMetadataBuilder forceHttpsScheme(boolean forceHttpsScheme) {
            this.forceHttpsScheme = forceHttpsScheme;
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.resourceMetadata(this.build());
        }

        public OidcTenantConfig.ResourceMetadata build() {
            return new ResourceMetadataImpl(this.enabled, this.resource, this.scopes, this.authorizationServer, this.forceHttpsScheme);
        }

        private record ResourceMetadataImpl(boolean enabled, Optional<String> resource, Optional<Set<String>> scopes, Optional<String> authorizationServer, boolean forceHttpsScheme) implements OidcTenantConfig.ResourceMetadata
        {
        }
    }

    public static final class CertificateChainBuilder {
        private final OidcTenantConfigBuilder builder;
        private Optional<String> leafCertificateName;
        private Optional<Path> trustStoreFile;
        private Optional<String> trustStorePassword;
        private Optional<String> trustStoreCertAlias;
        private Optional<String> trustStoreFileType;

        public CertificateChainBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public CertificateChainBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            OidcTenantConfig.CertificateChain certificateChain = builder.certificateChain;
            this.leafCertificateName = certificateChain.leafCertificateName();
            this.trustStoreFile = certificateChain.trustStoreFile();
            this.trustStorePassword = certificateChain.trustStorePassword();
            this.trustStoreCertAlias = certificateChain.trustStoreCertAlias();
            this.trustStoreFileType = certificateChain.trustStoreFileType();
        }

        public CertificateChainBuilder leafCertificateName(String leafCertificateName) {
            this.leafCertificateName = Optional.ofNullable(leafCertificateName);
            return this;
        }

        public CertificateChainBuilder trustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.ofNullable(trustStoreFile);
            return this;
        }

        public CertificateChainBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Optional.ofNullable(trustStorePassword);
            return this;
        }

        public CertificateChainBuilder trustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.ofNullable(trustStoreCertAlias);
            return this;
        }

        public CertificateChainBuilder trustStoreFileType(String trustStoreFileType) {
            this.trustStoreFileType = Optional.ofNullable(trustStoreFileType);
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.certificateChain(this.build());
        }

        public OidcTenantConfig.CertificateChain build() {
            return new CertificateChainImpl(this.leafCertificateName, this.trustStoreFile, this.trustStorePassword, this.trustStoreCertAlias, this.trustStoreFileType);
        }

        private record CertificateChainImpl(Optional<String> leafCertificateName, Optional<Path> trustStoreFile, Optional<String> trustStorePassword, Optional<String> trustStoreCertAlias, Optional<String> trustStoreFileType) implements OidcTenantConfig.CertificateChain
        {
        }
    }

    public static final class CodeGrantBuilder {
        private final OidcTenantConfigBuilder builder;
        private final Map<String, String> extraParams = new HashMap<String, String>();
        private final Map<String, String> headers = new HashMap<String, String>();

        public CodeGrantBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public CodeGrantBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            OidcTenantConfig.CodeGrant codeGrant = builder.codeGrant;
            this.extraParams.putAll(codeGrant.extraParams());
            this.headers.putAll(codeGrant.headers());
        }

        public CodeGrantBuilder header(String headerName, String headerValue) {
            Objects.requireNonNull(headerName);
            Objects.requireNonNull(headerValue);
            this.headers.put(headerName, headerValue);
            return this;
        }

        public CodeGrantBuilder headers(Map<String, String> headers) {
            if (headers != null) {
                this.headers.putAll(headers);
            }
            return this;
        }

        public CodeGrantBuilder extraParam(String extraParamKey, String extraParamValue) {
            Objects.requireNonNull(extraParamKey);
            Objects.requireNonNull(extraParamValue);
            this.extraParams.put(extraParamKey, extraParamValue);
            return this;
        }

        public CodeGrantBuilder extraParams(Map<String, String> extraParams) {
            if (extraParams != null) {
                this.extraParams.putAll(extraParams);
            }
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.codeGrant(this.build());
        }

        public OidcTenantConfig.CodeGrant build() {
            return new CodeGrantImpl(Map.copyOf(this.extraParams), Map.copyOf(this.headers));
        }

        private record CodeGrantImpl(Map<String, String> extraParams, Map<String, String> headers) implements OidcTenantConfig.CodeGrant
        {
        }
    }

    public static final class TokenStateManagerBuilder {
        private final OidcTenantConfigBuilder builder;
        private OidcTenantConfig.TokenStateManager.Strategy strategy;
        private boolean splitTokens;
        private boolean encryptionRequired;
        private Optional<String> encryptionSecret;
        private OidcTenantConfig.TokenStateManager.EncryptionAlgorithm encryptionAlgorithm;

        public TokenStateManagerBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public TokenStateManagerBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            OidcTenantConfig.TokenStateManager tokenStateManager = builder.tokenStateManager;
            this.strategy = tokenStateManager.strategy();
            this.splitTokens = tokenStateManager.splitTokens();
            this.encryptionRequired = tokenStateManager.encryptionRequired();
            this.encryptionSecret = tokenStateManager.encryptionSecret();
            this.encryptionAlgorithm = tokenStateManager.encryptionAlgorithm();
        }

        public TokenStateManagerBuilder encryptionAlgorithm(OidcTenantConfig.TokenStateManager.EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm);
            return this;
        }

        public TokenStateManagerBuilder encryptionSecret(String encryptionSecret) {
            this.encryptionSecret = Optional.ofNullable(encryptionSecret);
            return this;
        }

        public TokenStateManagerBuilder strategy(OidcTenantConfig.TokenStateManager.Strategy strategy) {
            this.strategy = Objects.requireNonNull(strategy);
            return this;
        }

        public TokenStateManagerBuilder encryptionRequired() {
            return this.encryptionRequired(true);
        }

        public TokenStateManagerBuilder encryptionRequired(boolean encryptionRequired) {
            this.encryptionRequired = encryptionRequired;
            return this;
        }

        public TokenStateManagerBuilder splitTokens() {
            return this.splitTokens(true);
        }

        public TokenStateManagerBuilder splitTokens(boolean splitTokens) {
            this.splitTokens = splitTokens;
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.tokenStateManager(this.build());
        }

        public OidcTenantConfig.TokenStateManager build() {
            return new TokenStateManagerImpl(this.strategy, this.splitTokens, this.encryptionRequired, this.encryptionSecret, this.encryptionAlgorithm);
        }

        private record TokenStateManagerImpl(OidcTenantConfig.TokenStateManager.Strategy strategy, boolean splitTokens, boolean encryptionRequired, Optional<String> encryptionSecret, OidcTenantConfig.TokenStateManager.EncryptionAlgorithm encryptionAlgorithm) implements OidcTenantConfig.TokenStateManager
        {
        }
    }

    public static final class JwksBuilder {
        private final OidcTenantConfigBuilder builder;
        private boolean resolveEarly;
        private int cacheSize;
        private Duration cacheTimeToLive;
        private Optional<Duration> cleanUpTimerInterval;
        private boolean tryAll;

        public JwksBuilder() {
            this(new OidcTenantConfigBuilder());
        }

        public JwksBuilder(OidcTenantConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            OidcTenantConfig.Jwks jwks = builder.jwks;
            this.resolveEarly = jwks.resolveEarly();
            this.cacheSize = jwks.cacheSize();
            this.cacheTimeToLive = jwks.cacheTimeToLive();
            this.cleanUpTimerInterval = jwks.cleanUpTimerInterval();
            this.tryAll = jwks.tryAll();
        }

        public JwksBuilder resolveEarly() {
            return this.resolveEarly(true);
        }

        public JwksBuilder resolveEarly(boolean resolveEarly) {
            this.resolveEarly = resolveEarly;
            return this;
        }

        public JwksBuilder cacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public JwksBuilder cacheTimeToLive(Duration cacheTimeToLive) {
            this.cacheTimeToLive = Objects.requireNonNull(cacheTimeToLive);
            return this;
        }

        public JwksBuilder cleanUpTimerInterval(Duration cleanUpTimerInterval) {
            this.cleanUpTimerInterval = Optional.ofNullable(cleanUpTimerInterval);
            return this;
        }

        public JwksBuilder tryAll() {
            return this.tryAll(true);
        }

        public JwksBuilder tryAll(boolean tryAll) {
            this.tryAll = tryAll;
            return this;
        }

        public OidcTenantConfigBuilder end() {
            return this.builder.jwks(this.build());
        }

        public OidcTenantConfig.Jwks build() {
            return new JwksImpl(this.resolveEarly, this.cacheSize, this.cacheTimeToLive, this.cleanUpTimerInterval, this.tryAll);
        }

        private record JwksImpl(boolean resolveEarly, int cacheSize, Duration cacheTimeToLive, Optional<Duration> cleanUpTimerInterval, boolean tryAll) implements OidcTenantConfig.Jwks
        {
        }
    }

    private static final class OidcTenantConfigImpl
    extends OidcClientCommonConfigBuilder.OidcClientCommonConfigImpl
    implements OidcTenantConfig {
        private final Optional<String> tenantId;
        private final boolean tenantEnabled;
        private final Optional<OidcTenantConfig.ApplicationType> applicationType;
        private final Optional<String> authorizationPath;
        private final Optional<String> userInfoPath;
        private final Optional<String> introspectionPath;
        private final Optional<String> jwksPath;
        private final Optional<String> endSessionPath;
        private final Optional<List<String>> tenantPaths;
        private final Optional<String> publicKey;
        private final OidcTenantConfig.IntrospectionCredentials introspectionCredentials;
        private final OidcTenantConfig.Roles roles;
        private final OidcTenantConfig.Token token;
        private final OidcTenantConfig.Logout logout;
        private final OidcTenantConfig.ResourceMetadata resourceMetadata;
        private final OidcTenantConfig.CertificateChain certificateChain;
        private final OidcTenantConfig.Authentication authentication;
        private final OidcTenantConfig.CodeGrant codeGrant;
        private final OidcTenantConfig.TokenStateManager tokenStateManager;
        private final boolean allowTokenIntrospectionCache;
        private final boolean allowUserInfoCache;
        private final Optional<Boolean> cacheUserInfoInIdtoken;
        private final OidcTenantConfig.Jwks jwks;
        private final Optional<OidcTenantConfig.Provider> provider;

        private OidcTenantConfigImpl(OidcTenantConfigBuilder builder) {
            super((OidcClientCommonConfigBuilder)builder);
            this.tenantId = builder.tenantId;
            this.tenantEnabled = builder.tenantEnabled;
            this.applicationType = builder.applicationType;
            this.authorizationPath = builder.authorizationPath;
            this.userInfoPath = builder.userInfoPath;
            this.introspectionPath = builder.introspectionPath;
            this.jwksPath = builder.jwksPath;
            this.endSessionPath = builder.endSessionPath;
            this.tenantPaths = builder.tenantPaths.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(builder.tenantPaths));
            this.publicKey = builder.publicKey;
            this.introspectionCredentials = builder.introspectionCredentials;
            this.roles = builder.roles;
            this.token = builder.token;
            this.logout = builder.logout;
            this.certificateChain = builder.certificateChain;
            this.resourceMetadata = builder.resourceMetadata;
            this.authentication = builder.authentication;
            this.codeGrant = builder.codeGrant;
            this.tokenStateManager = builder.tokenStateManager;
            this.allowTokenIntrospectionCache = builder.allowTokenIntrospectionCache;
            this.allowUserInfoCache = builder.allowUserInfoCache;
            this.cacheUserInfoInIdtoken = builder.cacheUserInfoInIdtoken;
            this.jwks = builder.jwks;
            this.provider = builder.provider;
        }

        @Override
        public Optional<String> tenantId() {
            return this.tenantId;
        }

        @Override
        public boolean tenantEnabled() {
            return this.tenantEnabled;
        }

        @Override
        public Optional<OidcTenantConfig.ApplicationType> applicationType() {
            return this.applicationType;
        }

        @Override
        public Optional<String> authorizationPath() {
            return this.authorizationPath;
        }

        @Override
        public Optional<String> userInfoPath() {
            return this.userInfoPath;
        }

        @Override
        public Optional<String> introspectionPath() {
            return this.introspectionPath;
        }

        @Override
        public Optional<String> jwksPath() {
            return this.jwksPath;
        }

        @Override
        public Optional<String> endSessionPath() {
            return this.endSessionPath;
        }

        @Override
        public Optional<List<String>> tenantPaths() {
            return this.tenantPaths;
        }

        @Override
        public Optional<String> publicKey() {
            return this.publicKey;
        }

        @Override
        public OidcTenantConfig.IntrospectionCredentials introspectionCredentials() {
            return this.introspectionCredentials;
        }

        @Override
        public OidcTenantConfig.Roles roles() {
            return this.roles;
        }

        @Override
        public OidcTenantConfig.Token token() {
            return this.token;
        }

        @Override
        public OidcTenantConfig.ResourceMetadata resourceMetadata() {
            return this.resourceMetadata;
        }

        @Override
        public OidcTenantConfig.Logout logout() {
            return this.logout;
        }

        @Override
        public OidcTenantConfig.CertificateChain certificateChain() {
            return this.certificateChain;
        }

        @Override
        public OidcTenantConfig.Authentication authentication() {
            return this.authentication;
        }

        @Override
        public OidcTenantConfig.CodeGrant codeGrant() {
            return this.codeGrant;
        }

        @Override
        public OidcTenantConfig.TokenStateManager tokenStateManager() {
            return this.tokenStateManager;
        }

        @Override
        public boolean allowTokenIntrospectionCache() {
            return this.allowTokenIntrospectionCache;
        }

        @Override
        public boolean allowUserInfoCache() {
            return this.allowUserInfoCache;
        }

        @Override
        public Optional<Boolean> cacheUserInfoInIdtoken() {
            return this.cacheUserInfoInIdtoken;
        }

        @Override
        public OidcTenantConfig.Jwks jwks() {
            return this.jwks;
        }

        @Override
        public Optional<OidcTenantConfig.Provider> provider() {
            return this.provider;
        }
    }
}

