/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime.config;

import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public interface OidcClientCommonConfig
extends OidcCommonConfig {
    public Optional<String> tokenPath();

    public Optional<String> revokePath();

    public Optional<String> clientId();

    public Optional<String> clientName();

    @ConfigDocSection
    public Credentials credentials();

    public static interface Credentials {
        public Optional<String> secret();

        public Secret clientSecret();

        public Jwt jwt();

        public static interface Provider {
            public Optional<String> name();

            public Optional<String> keyringName();

            public Optional<String> key();
        }

        public static interface Jwt {
            @WithDefault(value="client")
            public Source source();

            public Optional<Path> tokenPath();

            public Optional<String> secret();

            public Provider secretProvider();

            public Optional<String> key();

            public Optional<String> keyFile();

            public Optional<String> keyStoreFile();

            public Optional<String> keyStorePassword();

            public Optional<String> keyId();

            public Optional<String> keyPassword();

            public Optional<String> audience();

            @WithDefault(value="false")
            public boolean keepAudienceTrailingSlash();

            public Optional<String> tokenKeyId();

            public Optional<String> issuer();

            public Optional<String> subject();

            @ConfigDocMapKey(value="claim-name")
            public Map<String, String> claims();

            public Optional<String> signatureAlgorithm();

            @WithDefault(value="10")
            public int lifespan();

            @WithDefault(value="false")
            public boolean assertion();

            public static enum Source {
                CLIENT,
                BEARER;

            }
        }

        public static interface Secret {
            public Optional<String> value();

            public Provider provider();

            public Optional<Method> method();

            public static enum Method {
                BASIC,
                POST,
                POST_JWT,
                QUERY;

            }
        }
    }
}

