/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.runtime.MockedThroughWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class MockSupport {
    private static final Deque<List<Object>> contexts = new ArrayDeque<List<Object>>();

    MockSupport() {
    }

    static synchronized void pushContext() {
        contexts.push(new ArrayList());
    }

    static synchronized void popContext() {
        if (contexts.isEmpty()) {
            return;
        }
        List<Object> val = contexts.pop();
        for (Object i : val) {
            try {
                if (i instanceof MockedThroughWrapper) {
                    MockedThroughWrapper m = (MockedThroughWrapper)i;
                    m.clearMock();
                    continue;
                }
                i.getClass().getDeclaredMethod("arc$clearMock", new Class[0]).invoke(i, new Object[0]);
                MockSupport.mockObservers(i, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static synchronized <T> void installMock(T instance, T mock) {
        List<Object> inst = contexts.peek();
        if (inst == null) {
            throw new IllegalStateException("No test in progress");
        }
        try {
            if (instance instanceof MockedThroughWrapper) {
                MockedThroughWrapper m = (MockedThroughWrapper)instance;
                m.setMock(mock);
                inst.add(instance);
            } else {
                Method setMethod = instance.getClass().getDeclaredMethod("arc$setMock", Object.class);
                setMethod.invoke(instance, mock);
                inst.add(instance);
                MockSupport.mockObservers(instance, true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(instance) + " is not a normal scoped CDI bean, make sure the bean is a normal scope like @ApplicationScoped or @RequestScoped", e);
        }
    }

    private static <T> void mockObservers(T instance, boolean mock) throws NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getBeanMethod;
        try {
            getBeanMethod = instance.getClass().getDeclaredMethod("arc_bean", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        Object bean = getBeanMethod.invoke(instance, new Object[0]);
        Method getIdMethod = bean.getClass().getDeclaredMethod("getIdentifier", new Class[0]);
        String id = getIdMethod.invoke(bean, new Object[0]).toString();
        Method mockObserversMethod = instance.getClass().getClassLoader().loadClass("io.quarkus.arc.impl.ArcContainerImpl").getDeclaredMethod("mockObservers", String.class, Boolean.TYPE);
        mockObserversMethod.invoke(null, id, mock);
    }
}

