/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.registry.ValueRegistry;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.smallrye.config.SmallRyeConfig;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class IntegrationTestExtensionState
extends QuarkusTestExtensionState {
    private final Optional<ListeningAddress> listeningAddress;
    private final Map<String, String> sysPropRestore;

    public IntegrationTestExtensionState(ValueRegistry valueRegistry, TestResourceManager testResourceManager, Closeable resource, Runnable clearCallbacks, Optional<ListeningAddress> listeningAddress, Map<String, String> sysPropRestore) {
        super(valueRegistry, (Closeable)testResourceManager, resource, clearCallbacks);
        this.listeningAddress = listeningAddress;
        this.sysPropRestore = sysPropRestore;
    }

    public Optional<ListeningAddress> getListeningAddress() {
        return this.listeningAddress;
    }

    @Override
    protected void doClose() throws IOException {
        this.testResourceManager.close();
        this.resource.close();
        for (Map.Entry<String, String> entry : this.sysPropRestore.entrySet()) {
            String val = entry.getValue();
            if (val == null) {
                System.clearProperty(entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), val);
        }
        ((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getLatestPropertyNames();
    }
}

