/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc;

import io.quarkus.devui.runtime.comms.JsonRpcResponseWriter;
import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequest;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequestCreator;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcResponse;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.vertx.core.json.JsonObject;
import org.jboss.logging.Logger;

public final class JsonRpcCodec {
    private static final Logger LOG = Logger.getLogger(JsonRpcCodec.class);
    private final JsonMapper jsonMapper;
    private final JsonRpcRequestCreator jsonRpcRequestCreator;

    public JsonRpcCodec(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.jsonRpcRequestCreator = new JsonRpcRequestCreator(jsonMapper);
    }

    public JsonRpcRequest readRequest(String json) {
        return this.jsonRpcRequestCreator.create((JsonObject)this.jsonMapper.fromString(json, Object.class));
    }

    public JsonRpcRequest readMCPRequest(String json) {
        return this.jsonRpcRequestCreator.mcpCreate((JsonObject)this.jsonMapper.fromString(json, Object.class));
    }

    public void writeResponse(JsonRpcResponseWriter writer, int id, Object object, MessageType messageType) {
        Object decoratedObject = writer.decorateObject(object, messageType);
        this.writeResponse(writer, new JsonRpcResponse(id, decoratedObject));
    }

    public void writeMethodNotFoundResponse(JsonRpcResponseWriter writer, int id, String jsonRpcMethodName) {
        this.writeResponse(writer, new JsonRpcResponse(id, new JsonRpcResponse.Error(-32601, "Method [" + jsonRpcMethodName + "] not found")));
    }

    public void writeErrorResponse(JsonRpcResponseWriter writer, int id, String jsonRpcMethodName, Throwable exception) {
        LOG.error((Object)"Error in JsonRPC Call", exception);
        this.writeResponse(writer, new JsonRpcResponse(id, new JsonRpcResponse.Error(-32603, "Method [" + jsonRpcMethodName + "] failed: " + exception.getMessage())));
    }

    private void writeResponse(JsonRpcResponseWriter writer, JsonRpcResponse response) {
        writer.write(this.jsonMapper.toString(response, true));
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }
}

