/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateRecipe;
import io.quarkus.devtools.project.update.rewrite.RewriteOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class QuarkusUpdateRecipeIO {
    public static List<Object> readRecipesYaml(String recipeYaml) {
        Objects.requireNonNull(recipeYaml, "inputStream is required");
        Yaml yaml = new Yaml();
        ArrayList otherRecipes = new ArrayList();
        yaml.loadAll(recipeYaml).iterator().forEachRemaining(otherRecipes::add);
        return List.copyOf(otherRecipes);
    }

    public static void write(MessageWriter log, Path target, QuarkusUpdateRecipe recipe) throws IOException {
        Objects.requireNonNull(target, "target is required");
        Objects.requireNonNull(recipe, "recipe is required");
        Files.writeString(target, (CharSequence)QuarkusUpdateRecipeIO.toYaml(log, recipe), new OpenOption[0]);
    }

    static String toYaml(MessageWriter log, QuarkusUpdateRecipe recipe) {
        Objects.requireNonNull(recipe, "recipe is required");
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.putAll(QuarkusUpdateRecipe.QUARKUS_RECIPE);
        ArrayList<Object> recipeList = new ArrayList<Object>();
        for (RewriteOperation o : recipe.getOperations()) {
            recipeList.addAll(o.multi(recipe.getBuildTool()));
        }
        recipeList.addAll(recipe.getOtherRecipeNames());
        q.put("recipeList", recipeList);
        HashSet seen = new HashSet();
        Set duplicates = recipeList.stream().filter(r -> r instanceof String).map(r -> (String)r).filter(r -> !seen.add(r)).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            log.warn("Duplicated recipes found:");
            duplicates.stream().sorted().forEach(r -> log.warn("    - '%s'", new Object[]{r}));
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
        output.add(q);
        output.addAll(recipe.getRecipes());
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        return yaml.dumpAll(output.iterator());
    }
}

