/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.CapabilityErrors;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.BooleanSupplierFactoryBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class CapabilityAggregationStep {
    @BuildStep
    void provideCapabilities(BuildProducer<CapabilityBuildItem> producer, BuildProducer<CapabilitiesConfiguredInDescriptorsBuildItem> configuredCapsProducer, CurateOutcomeBuildItem curateOutcomeBuildItem, BooleanSupplierFactoryBuildItem supplierFactory) {
        ApplicationModel appModel = curateOutcomeBuildItem.getApplicationModel();
        HashSet<String> capabilityNames = new HashSet<String>();
        for (ExtensionCapabilities contract : appModel.getExtensionCapabilities()) {
            String provider = contract.getExtension();
            for (String capability : contract.getProvidesCapabilities()) {
                int conditionIndex = capability.indexOf(63);
                String name = conditionIndex < 0 ? capability : capability.substring(0, conditionIndex);
                boolean provide = true;
                while (conditionIndex > 0 && provide) {
                    Class<BooleanSupplier> testClass;
                    boolean inv = conditionIndex < capability.length() - 1 && capability.charAt(conditionIndex + 1) == '!';
                    int testClassStart = conditionIndex + (inv ? 2 : 1);
                    conditionIndex = capability.indexOf(63, testClassStart + 1);
                    String testClassName = capability.substring(testClassStart, conditionIndex > 0 ? conditionIndex : capability.length());
                    try {
                        testClass = Thread.currentThread().getContextClassLoader().loadClass(testClassName).asSubclass(BooleanSupplier.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load the condition class " + testClassName + " for capability " + name, e);
                    }
                    provide = supplierFactory.get(testClass).getAsBoolean();
                }
                if (!provide) continue;
                producer.produce(new CapabilityBuildItem(name, provider));
                capabilityNames.add(name);
            }
        }
        configuredCapsProducer.produce(new CapabilitiesConfiguredInDescriptorsBuildItem(capabilityNames));
    }

    @BuildStep
    Capabilities aggregateCapabilities(List<CapabilityBuildItem> capabilities, CapabilitiesConfiguredInDescriptorsBuildItem configuredCaps, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        HashMap<String, String> providedCapabilities = new HashMap<String, String>();
        CapabilityErrors capabilityErrors = null;
        Map<String, List> capsProvidedByBuildSteps = Collections.emptyMap();
        for (CapabilityBuildItem capabilityItem : capabilities) {
            String provider = capabilityItem.getProvider();
            String string = capabilityItem.getName();
            String previous = providedCapabilities.put(string, provider);
            if (previous != null) {
                if (previous instanceof String) {
                    capabilityErrors = CapabilityAggregationStep.createIfNull(capabilityErrors);
                    capabilityErrors.addConflict(string, previous.toString());
                    providedCapabilities.put(string, (String)capabilityErrors);
                } else {
                    capabilityErrors = (CapabilityErrors)previous;
                }
                capabilityErrors.addConflict(string, provider);
                providedCapabilities.put(string, (String)capabilityErrors);
            }
            if (configuredCaps.names.contains(string)) continue;
            if (capsProvidedByBuildSteps.isEmpty()) {
                capsProvidedByBuildSteps = new HashMap();
            }
            capsProvidedByBuildSteps.computeIfAbsent(provider, k -> new ArrayList(1)).add(string);
        }
        for (ExtensionCapabilities extCap : curateOutcomeBuildItem.getApplicationModel().getExtensionCapabilities()) {
            if (extCap.getRequiresCapabilities().isEmpty()) continue;
            for (String string : extCap.getRequiresCapabilities()) {
                if (providedCapabilities.containsKey(string)) continue;
                capabilityErrors = CapabilityAggregationStep.createIfNull(capabilityErrors);
                capabilityErrors.addMissing(string, extCap.getExtension());
            }
        }
        if (!capsProvidedByBuildSteps.isEmpty()) {
            StringWriter buf = new StringWriter();
            try (BufferedWriter writer = new BufferedWriter(buf);){
                writer.append("The following capabilities were found to be missing from the processed extension descriptors:");
                for (Map.Entry entry : capsProvidedByBuildSteps.entrySet()) {
                    for (String capability : (List)entry.getValue()) {
                        writer.newLine();
                        writer.append(" - " + capability + " provided by ").append((CharSequence)entry.getKey());
                    }
                }
                writer.newLine();
                writer.append("Please report this issue to the extension maintainers to get it fixed in the future releases.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Logger.getLogger(CapabilityAggregationStep.class).warn((Object)buf.toString());
        }
        if (capabilityErrors != null && !capabilityErrors.isEmpty()) {
            throw new IllegalStateException(capabilityErrors.report());
        }
        return new Capabilities(providedCapabilities.keySet());
    }

    private static CapabilityErrors createIfNull(CapabilityErrors capabilityErrors) {
        return capabilityErrors == null ? (capabilityErrors = new CapabilityErrors()) : capabilityErrors;
    }

    public static final class CapabilitiesConfiguredInDescriptorsBuildItem
    extends SimpleBuildItem {
        private final Set<String> names;

        private CapabilitiesConfiguredInDescriptorsBuildItem(Set<String> names) {
            this.names = names;
        }
    }
}

