/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.smallrye.beanbag.maven.MavenFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.maven.cli.transfer.BatchModeMavenTransferListener;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.ProfileActivationFilePathInterpolator;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ChainedLocalRepositoryManager;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.logging.Logger;

public class BootstrapMavenContext {
    private static final Logger log = Logger.getLogger(BootstrapMavenContext.class);
    private static final String BASEDIR = "basedir";
    private static final String DEFAULT_REMOTE_REPO_ID = "central";
    private static final String DEFAULT_REMOTE_REPO_URL = "https://repo.maven.apache.org/maven2";
    private static final String MAVEN_DOT_HOME = "maven.home";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String MAVEN_SETTINGS = "maven.settings";
    private static final String MAVEN_TOP_LEVEL_PROJECT_BASEDIR = "maven.top-level-basedir";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String SETTINGS_SECURITY = "settings.security";
    private static final String EFFECTIVE_MODEL_BUILDER_PROP = "quarkus.bootstrap.effective-model-builder";
    private static final String WARN_ON_FAILING_WS_MODULES_PROP = "quarkus.bootstrap.warn-on-failing-workspace-modules";
    private static final String MAVEN_RESOLVER_TRANSPORT_KEY = "maven.resolver.transport";
    private static final String MAVEN_RESOLVER_TRANSPORT_DEFAULT = "default";
    private static final String MAVEN_RESOLVER_TRANSPORT_WAGON = "wagon";
    private static final String MAVEN_RESOLVER_TRANSPORT_NATIVE = "native";
    private static final String MAVEN_RESOLVER_TRANSPORT_AUTO = "auto";
    private static final String WAGON_TRANSPORTER_PRIORITY_KEY = "aether.priority.WagonTransporterFactory";
    private static final String NATIVE_HTTP_TRANSPORTER_PRIORITY_KEY = "aether.priority.HttpTransporterFactory";
    private static final String NATIVE_FILE_TRANSPORTER_PRIORITY_KEY = "aether.priority.FileTransporterFactory";
    private static final String RESOLVER_MAX_PRIORITY = String.valueOf(Float.MAX_VALUE);
    private boolean artifactTransferLogging;
    private BootstrapMavenOptions cliOptions;
    private File userSettings;
    private File globalSettings;
    private Boolean offline;
    private Boolean warnOnFailingWorkspaceModules;
    private LocalWorkspace workspace;
    private LocalProject currentProject;
    private Settings settings;
    private List<org.apache.maven.model.Profile> activeSettingsProfiles;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    private List<RemoteRepository> remotePluginRepos;
    private RemoteRepositoryManager remoteRepoManager;
    private String localRepo;
    private String[] localRepoTail;
    private Boolean localRepoTailIgnoreAvailability;
    private Path currentPom;
    private Boolean currentProjectExists;
    private String alternatePomName;
    private Path rootProjectDir;
    private boolean preferPomsFromWorkspace;
    private Boolean effectiveModelBuilder;
    private Boolean wsModuleParentHierarchy;
    private SettingsDecrypter settingsDecrypter;
    private final List<String> excludeSisuBeanPackages;
    private final List<String> includeSisuBeanPackages;
    static final String BOOTSTRAP_MAVEN_REPOS = "BOOTSTRAP_MAVEN_REPOS";
    static final String BOOTSTRAP_MAVEN_REPO_PREFIX = "BOOTSTRAP_MAVEN_REPO_";
    static final String URL_SUFFIX = "_URL";
    static final String SNAPSHOT_SUFFIX = "_SNAPSHOT";
    static final String RELEASE_SUFFIX = "_RELEASE";

    public static BootstrapMavenContextConfig<?> config() {
        return new BootstrapMavenContextConfig();
    }

    public BootstrapMavenContext() throws BootstrapMavenException {
        this(new BootstrapMavenContextConfig());
    }

    public BootstrapMavenContext(BootstrapMavenContextConfig<?> config) throws BootstrapMavenException {
        this.alternatePomName = config.alternatePomName;
        this.artifactTransferLogging = config.artifactTransferLogging;
        this.localRepo = config.localRepo;
        this.localRepoTail = config.localRepoTail;
        this.localRepoTailIgnoreAvailability = config.localRepoTailIgnoreAvailability;
        this.offline = config.offline;
        this.warnOnFailingWorkspaceModules = config.warnOnFailedWorkspaceModules;
        this.repoSystem = config.repoSystem;
        this.repoSession = config.repoSession;
        this.remoteRepos = config.remoteRepos;
        this.remotePluginRepos = config.remotePluginRepos;
        this.remoteRepoManager = config.remoteRepoManager;
        this.settingsDecrypter = config.settingsDecrypter;
        this.cliOptions = config.cliOptions;
        this.excludeSisuBeanPackages = config.getExcludeSisuBeanPackages();
        this.includeSisuBeanPackages = config.getIncludeSisuBeanPackages();
        if (config.rootProjectDir == null) {
            String topLevelBaseDirStr = PropertyUtils.getProperty((String)MAVEN_TOP_LEVEL_PROJECT_BASEDIR);
            if (topLevelBaseDirStr != null) {
                Path tmp = Path.of(topLevelBaseDirStr, new String[0]);
                if (!Files.exists(tmp, new LinkOption[0])) {
                    throw new BootstrapMavenException("Top-level project base directory " + topLevelBaseDirStr + " specified with system property maven.top-level-basedir does not exist");
                }
                this.rootProjectDir = tmp;
            }
        } else {
            this.rootProjectDir = config.rootProjectDir;
        }
        this.preferPomsFromWorkspace = config.preferPomsFromWorkspace;
        this.effectiveModelBuilder = config.effectiveModelBuilder;
        this.wsModuleParentHierarchy = config.wsModuleParentHierarchy;
        this.userSettings = config.userSettings;
        if (config.currentProject != null) {
            this.currentProject = config.currentProject;
            this.currentPom = this.currentProject.getRawModel().getPomFile().toPath();
            this.workspace = config.currentProject.getWorkspace();
        } else if (config.workspaceDiscovery) {
            this.currentProject = this.resolveCurrentProject(config.modelProvider);
            LocalWorkspace localWorkspace = this.workspace = this.currentProject == null ? null : this.currentProject.getWorkspace();
            if (this.workspace != null && config.repoSession == null && this.repoSession != null && this.repoSession.getWorkspaceReader() == null) {
                List<RemoteRepository> rawProjectRepos;
                this.repoSession = new DefaultRepositorySystemSession(this.repoSession).setWorkspaceReader((WorkspaceReader)this.workspace);
                if (config.remoteRepos == null && this.remoteRepos != null && !(rawProjectRepos = this.resolveRawProjectRepos(this.remoteRepos)).isEmpty()) {
                    this.remoteRepos = this.getRemoteRepositoryManager().aggregateRepositories(this.repoSession, this.remoteRepos, rawProjectRepos, true);
                }
            }
        }
    }

    public ArtifactCoords getCurrentProjectArtifact(String extension) throws BootstrapMavenException {
        if (this.currentProject != null) {
            return this.currentProject.getAppArtifact(extension);
        }
        Model model = this.loadCurrentProjectModel();
        if (model == null) {
            return null;
        }
        return ArtifactCoords.of((String)ModelUtils.getGroupId(model), (String)model.getArtifactId(), (String)"", (String)extension, (String)ModelUtils.getVersion(model));
    }

    public LocalProject getCurrentProject() {
        return this.currentProject;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public BootstrapMavenOptions getCliOptions() {
        return this.cliOptions == null ? (this.cliOptions = BootstrapMavenOptions.newInstance()) : this.cliOptions;
    }

    public File getUserSettings() {
        if (this.userSettings == null) {
            String quarkusMavenSettings = this.getProperty(MAVEN_SETTINGS);
            if (quarkusMavenSettings != null) {
                File f = new File(quarkusMavenSettings);
                this.userSettings = f.exists() ? f : null;
                return this.userSettings;
            }
            this.userSettings = this.resolveSettingsFile(this.getCliOptions().getOptionValue("s"), () -> new File(BootstrapMavenContext.getUserMavenConfigurationHome(), SETTINGS_XML));
            return this.userSettings;
        }
        return this.userSettings;
    }

    private static File getUserMavenConfigurationHome() {
        return new File(PropertyUtils.getUserHome(), ".m2");
    }

    private String getProperty(String name) {
        String value = PropertyUtils.getProperty((String)name);
        if (value != null) {
            return value;
        }
        Properties props = this.getCliOptions().getSystemProperties();
        return props == null ? null : props.getProperty(name);
    }

    public File getGlobalSettings() {
        return this.globalSettings == null ? (this.globalSettings = this.resolveSettingsFile(this.getCliOptions().getOptionValue("gs"), () -> {
            String mavenHome = this.getProperty(MAVEN_DOT_HOME);
            if (mavenHome == null && (mavenHome = System.getenv(MAVEN_HOME)) == null) {
                mavenHome = "";
            }
            return new File(mavenHome, "conf/settings.xml");
        })) : this.globalSettings;
    }

    public boolean isOffline() throws BootstrapMavenException {
        return this.offline == null ? (this.offline = Boolean.valueOf(this.getCliOptions().hasOption("o") || this.getEffectiveSettings().isOffline())) : this.offline;
    }

    public boolean isWarnOnFailingWorkspaceModules() {
        return this.warnOnFailingWorkspaceModules == null ? (this.warnOnFailingWorkspaceModules = Boolean.valueOf(Boolean.getBoolean(WARN_ON_FAILING_WS_MODULES_PROP))) : this.warnOnFailingWorkspaceModules;
    }

    public RepositorySystem getRepositorySystem() throws BootstrapMavenException {
        if (this.repoSystem == null) {
            this.initRepoSystemAndManager();
        }
        return this.repoSystem;
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        if (this.remoteRepoManager == null) {
            this.initRepoSystemAndManager();
        }
        return this.remoteRepoManager;
    }

    public RepositorySystemSession getRepositorySystemSession() throws BootstrapMavenException {
        return this.repoSession == null ? (this.repoSession = this.newRepositorySystemSession()) : this.repoSession;
    }

    public List<RemoteRepository> getRemoteRepositories() throws BootstrapMavenException {
        return this.remoteRepos == null ? (this.remoteRepos = this.resolveRemoteRepos()) : this.remoteRepos;
    }

    public List<RemoteRepository> getRemotePluginRepositories() throws BootstrapMavenException {
        return this.remotePluginRepos == null ? (this.remotePluginRepos = this.resolveRemotePluginRepos()) : this.remotePluginRepos;
    }

    public SettingsDecrypter getSettingsDecrypter() {
        if (this.settingsDecrypter == null) {
            this.initRepoSystemAndManager();
        }
        return this.settingsDecrypter;
    }

    public Settings getEffectiveSettings() throws BootstrapMavenException {
        Settings effectiveSettings;
        if (this.settings != null) {
            return this.settings;
        }
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(this.getUserSettings()).setGlobalSettingsFile(this.getGlobalSettings());
        Properties cmdLineProps = this.getCliOptions().getSystemProperties();
        if (cmdLineProps != null) {
            settingsRequest.setUserProperties(cmdLineProps);
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)settingsRequest);
            List problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new BootstrapMavenException("Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("Settings problem encountered at " + problem.getLocation()), (Throwable)problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new BootstrapMavenException("Failed to initialize Maven repository settings", e);
        }
        this.settings = effectiveSettings;
        return this.settings;
    }

    public String getLocalRepo() throws BootstrapMavenException {
        return this.localRepo == null ? (this.localRepo = this.resolveLocalRepo(this.getEffectiveSettings())) : this.localRepo;
    }

    private String[] getLocalRepoTail() {
        String[] stringArray;
        if (this.localRepoTail == null) {
            this.localRepoTail = this.resolveLocalRepoTail();
            stringArray = this.localRepoTail;
        } else {
            stringArray = this.localRepoTail;
        }
        return stringArray;
    }

    private boolean getLocalRepoTailIgnoreAvailability() {
        return this.localRepoTailIgnoreAvailability == null ? (this.localRepoTailIgnoreAvailability = Boolean.valueOf(this.resolveLocalRepoTailIgnoreAvailability())) : this.localRepoTailIgnoreAvailability;
    }

    private LocalProject resolveCurrentProject(Function<Path, Model> modelProvider) throws BootstrapMavenException {
        try {
            return LocalProject.loadWorkspace(this, modelProvider);
        }
        catch (Exception e) {
            throw new BootstrapMavenException("Failed to load current project at " + String.valueOf(this.getCurrentProjectPomOrNull()), e);
        }
    }

    private String resolveLocalRepo(Settings settings) {
        String localRepo = System.getenv("QUARKUS_LOCAL_REPO");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = this.getProperty("maven.repo.local");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = settings.getLocalRepository();
        return localRepo == null ? new File(BootstrapMavenContext.getUserMavenConfigurationHome(), "repository").getAbsolutePath() : localRepo;
    }

    private String[] resolveLocalRepoTail() {
        String localRepoTail = this.getProperty("maven.repo.local.tail");
        if (localRepoTail == null) {
            return new String[0];
        }
        if (localRepoTail.trim().isEmpty()) {
            return new String[0];
        }
        return localRepoTail.split(",");
    }

    private boolean resolveLocalRepoTailIgnoreAvailability() {
        String ignoreAvailability = this.getProperty("maven.repo.local.tail.ignoreAvailability");
        return !"false".equalsIgnoreCase(ignoreAvailability);
    }

    private File resolveSettingsFile(String settingsArg, Supplier<File> supplier) {
        File userSettings;
        if (settingsArg != null) {
            userSettings = new File(settingsArg);
            if (userSettings.exists()) {
                return userSettings;
            }
            if (userSettings.isAbsolute()) {
                return null;
            }
            String alternatePomDir = this.getCliOptions().getOptionValue("f");
            if (alternatePomDir != null) {
                File tmp = new File(alternatePomDir);
                if (tmp.isAbsolute()) {
                    alternatePomDir = null;
                } else {
                    if (!tmp.isDirectory()) {
                        tmp = tmp.getParentFile();
                    }
                    String string = alternatePomDir = tmp == null ? null : tmp.toString();
                }
            }
            if ((userSettings = this.resolveSettingsFile(settingsArg, alternatePomDir, System.getenv("MAVEN_PROJECTBASEDIR"))) != null) {
                return userSettings;
            }
            userSettings = this.resolveSettingsFile(settingsArg, alternatePomDir, PropertyUtils.getProperty((String)BASEDIR));
            if (userSettings != null) {
                return userSettings;
            }
            userSettings = new File(PropertyUtils.getUserHome(), settingsArg);
            if (userSettings.exists()) {
                return userSettings;
            }
        }
        return (userSettings = supplier.get()).exists() ? userSettings : null;
    }

    private File resolveSettingsFile(String settingsArg, String alternatePomDir, String projectBaseDir) {
        File userSettings;
        if (projectBaseDir == null) {
            return null;
        }
        if (alternatePomDir != null && projectBaseDir.endsWith(alternatePomDir) && (userSettings = new File(projectBaseDir.substring(0, projectBaseDir.length() - alternatePomDir.length()), settingsArg)).exists()) {
            return userSettings;
        }
        userSettings = new File(projectBaseDir, settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        return null;
    }

    private DefaultRepositorySystemSession newRepositorySystemSession() throws BootstrapMavenException {
        boolean setSettingsSecurity;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        Settings settings = this.getEffectiveSettings();
        List mirrors = settings.getMirrors();
        if (mirrors != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.isBlocked(), m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector((MirrorSelector)ms);
        }
        String localRepoPath = this.getLocalRepo();
        String[] localRepoTailPaths = this.getLocalRepoTail();
        LocalRepositoryManager head = this.getRepositorySystem().newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepoPath));
        if (localRepoTailPaths.length == 0) {
            session.setLocalRepositoryManager(head);
        } else {
            ArrayList<LocalRepositoryManager> tail = new ArrayList<LocalRepositoryManager>(localRepoTailPaths.length);
            for (String tailPath : localRepoTailPaths) {
                tail.add(this.getRepositorySystem().newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(tailPath)));
            }
            session.setLocalRepositoryManager((LocalRepositoryManager)new ChainedLocalRepositoryManager(head, tail, this.getLocalRepoTailIgnoreAvailability()));
        }
        session.setOffline(this.isOffline());
        BootstrapMavenOptions mvnArgs = this.getCliOptions();
        if (!mvnArgs.isEmpty()) {
            if (mvnArgs.hasOption("nsu")) {
                session.setUpdatePolicy("never");
            } else if (mvnArgs.hasOption("U")) {
                session.setUpdatePolicy("always");
            }
            if (mvnArgs.hasOption("C")) {
                session.setChecksumPolicy("fail");
            } else if (mvnArgs.hasOption("c")) {
                session.setChecksumPolicy("warn");
            }
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(settings.getProxies());
        decrypt.setServers(settings.getServers());
        File settingsSecurityXml = null;
        boolean bl = setSettingsSecurity = !System.getProperties().contains(SETTINGS_SECURITY) && (settingsSecurityXml = new File(BootstrapMavenContext.getUserMavenConfigurationHome(), "settings-security.xml")).exists();
        if (setSettingsSecurity) {
            System.setProperty(SETTINGS_SECURITY, settingsSecurityXml.toString());
        }
        SettingsDecryptionResult decrypted = this.getSettingsDecrypter().decrypt((SettingsDecryptionRequest)decrypt);
        if (setSettingsSecurity) {
            System.clearProperty(SETTINGS_SECURITY);
        }
        if (!decrypted.getProblems().isEmpty() && log.isDebugEnabled()) {
            for (SettingsProblem p : decrypted.getProblems()) {
                log.debug((Object)p.getMessage(), (Throwable)p.getException());
            }
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy p : decrypted.getProxies()) {
            if (!p.isActive()) continue;
            proxySelector.add(BootstrapMavenContext.toAetherProxy(p), p.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>(session.getConfigProperties());
        configProps.put("aether.connector.userAgent", BootstrapMavenContext.getUserAgent());
        configProps.put("aether.interactive", settings.isInteractiveMode());
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                PlexusConfiguration connectTimeoutXml;
                PlexusConfiguration[] properties;
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
                HashMap<String, String> headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                PlexusConfiguration httpHeaders = config.getChild("httpHeaders", false);
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap<String, String>();
                    for (PlexusConfiguration property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = config.getChild("connectTimeout", false)) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (connectTimeoutXml = httpConfigurationAll.getChild("connectionTimeout", false)) != null) {
                        connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                        log.warn((Object)("Settings for server " + server.getId() + " uses legacy format"));
                    }
                }
                PlexusConfiguration requestTimeoutXml = config.getChild("requestTimeout", false);
                if (requestTimeoutXml != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (requestTimeoutXml = httpConfigurationAll.getChild("readTimeout", false)) != null) {
                        requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                        log.warn((Object)("Settings for server " + server.getId() + " uses legacy format"));
                    }
                }
                if (headers != null) {
                    configProps.put("aether.connector.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.connector.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.connector.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        String transport = configProps.getOrDefault(MAVEN_RESOLVER_TRANSPORT_KEY, MAVEN_RESOLVER_TRANSPORT_DEFAULT);
        if (!MAVEN_RESOLVER_TRANSPORT_DEFAULT.equals(transport)) {
            if (MAVEN_RESOLVER_TRANSPORT_NATIVE.equals(transport)) {
                configProps.put(NATIVE_FILE_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
                configProps.put(NATIVE_HTTP_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (MAVEN_RESOLVER_TRANSPORT_WAGON.equals(transport)) {
                configProps.put(WAGON_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (!MAVEN_RESOLVER_TRANSPORT_AUTO.equals(transport)) {
                throw new IllegalArgumentException("Unknown resolver transport '" + String.valueOf(transport) + "'. Supported transports are: wagon, native, auto");
            }
        }
        session.setConfigProperties(configProps);
        if (session.getCache() == null) {
            session.setCache((RepositoryCache)new DefaultRepositoryCache());
        }
        if (this.workspace != null) {
            session.setWorkspaceReader((WorkspaceReader)this.workspace);
        }
        if (session.getTransferListener() == null && this.artifactTransferLogging) {
            Object transferListener = mvnArgs.hasOption("ntp") ? new QuietMavenTransferListener() : (mvnArgs.hasOption("B") ? new BatchModeMavenTransferListener(System.out) : new ConsoleMavenTransferListener(System.out, true));
            session.setTransferListener((TransferListener)transferListener);
        }
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            session.setSystemProperty(e.getKey().toString(), e.getValue().toString());
        }
        return session;
    }

    private List<RemoteRepository> resolveRemoteRepos() throws BootstrapMavenException {
        ArrayList<RemoteRepository> rawRepos = new ArrayList<RemoteRepository>();
        BootstrapMavenContext.readMavenReposFromEnv(rawRepos, System.getenv());
        this.addReposFromProfiles(rawRepos);
        boolean centralConfiguredInSettings = BootstrapMavenContext.includesDefaultRepo(rawRepos);
        if (!centralConfiguredInSettings) {
            rawRepos.add(BootstrapMavenContext.newDefaultRepository());
        }
        if (this.workspace == null) {
            return this.newResolutionRepos(rawRepos);
        }
        List<RemoteRepository> rawProjectRepos = this.resolveRawProjectRepos(this.newResolutionRepos(rawRepos));
        if (!rawProjectRepos.isEmpty()) {
            if (!centralConfiguredInSettings) {
                rawRepos.remove(rawRepos.size() - 1);
            }
            rawRepos.addAll(rawProjectRepos);
            if (!centralConfiguredInSettings && !BootstrapMavenContext.includesDefaultRepo(rawProjectRepos)) {
                rawRepos.add(BootstrapMavenContext.newDefaultRepository());
            }
        }
        return this.newResolutionRepos(rawRepos);
    }

    private List<RemoteRepository> resolveRemotePluginRepos() throws BootstrapMavenException {
        ArrayList<RemoteRepository> rawRepos = new ArrayList<RemoteRepository>();
        this.addReposFromProfiles(rawRepos);
        if (!BootstrapMavenContext.includesDefaultRepo(rawRepos)) {
            rawRepos.add(BootstrapMavenContext.newDefaultRepository());
        }
        return this.newResolutionRepos(rawRepos);
    }

    private List<RemoteRepository> newResolutionRepos(List<RemoteRepository> rawRepos) throws BootstrapMavenException {
        return this.getRepositorySystem().newResolutionRepositories(this.getRepositorySystemSession(), rawRepos);
    }

    private void addReposFromProfiles(List<RemoteRepository> rawRepos) throws BootstrapMavenException {
        List<org.apache.maven.model.Profile> profiles = this.getActiveSettingsProfiles();
        for (int i = profiles.size() - 1; i >= 0; --i) {
            BootstrapMavenContext.addProfileRepos(profiles.get(i).getRepositories(), rawRepos);
        }
    }

    public static RemoteRepository newDefaultRepository() {
        return new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, MAVEN_RESOLVER_TRANSPORT_DEFAULT, DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "daily", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "daily", "warn")).build();
    }

    private Model loadCurrentProjectModel() throws BootstrapMavenException {
        Path pom = this.getCurrentProjectPomOrNull();
        if (pom == null) {
            return null;
        }
        try {
            return ModelUtils.readModel(pom);
        }
        catch (IOException e) {
            throw new BootstrapMavenException("Failed to parse " + String.valueOf(pom), e);
        }
    }

    private List<RemoteRepository> resolveRawProjectRepos(List<RemoteRepository> repos) throws BootstrapMavenException {
        DefaultArtifact projectArtifact;
        if (this.currentProject == null) {
            Model model = this.loadCurrentProjectModel();
            if (model == null) {
                return List.of();
            }
            projectArtifact = new DefaultArtifact(ModelUtils.getGroupId(model), model.getArtifactId(), "", "pom", ModelUtils.getVersion(model));
        } else {
            projectArtifact = new DefaultArtifact(this.currentProject.getGroupId(), this.currentProject.getArtifactId(), "", "pom", this.currentProject.getVersion());
        }
        RepositorySystem repoSystem = this.getRepositorySystem();
        RepositorySystemSession repoSession = this.getRepositorySystemSession();
        try {
            return repoSystem.readArtifactDescriptor(repoSession, new ArtifactDescriptorRequest().setArtifact((Artifact)projectArtifact).setRepositories(repos)).getRepositories();
        }
        catch (ArtifactDescriptorException e) {
            throw new BootstrapMavenException("Failed to read artifact descriptor for " + String.valueOf(projectArtifact), e);
        }
    }

    public List<org.apache.maven.model.Profile> getActiveSettingsProfiles() throws BootstrapMavenException {
        if (this.activeSettingsProfiles != null) {
            return this.activeSettingsProfiles;
        }
        Settings settings = this.getEffectiveSettings();
        List allSettingsProfiles = settings.getProfiles();
        if (allSettingsProfiles.isEmpty()) {
            this.activeSettingsProfiles = List.of();
            return this.activeSettingsProfiles;
        }
        BootstrapMavenOptions mvnArgs = this.getCliOptions();
        Path currentPom = this.getCurrentProjectPomOrNull();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext().setActiveProfileIds(mvnArgs.getActiveProfileIds()).setInactiveProfileIds(mvnArgs.getInactiveProfileIds()).setSystemProperties(System.getProperties()).setProjectDirectory(currentPom == null ? this.getCurrentProjectBaseDir().toFile() : currentPom.getParent().toFile());
        DefaultProfileSelector profileSelector = new DefaultProfileSelector().addProfileActivator((ProfileActivator)new PropertyProfileActivator()).addProfileActivator((ProfileActivator)new JdkVersionProfileActivator()).addProfileActivator((ProfileActivator)new OperatingSystemProfileActivator()).addProfileActivator((ProfileActivator)BootstrapMavenContext.createFileProfileActivator());
        ArrayList selectedProfiles = profileSelector.getActiveProfiles(BootstrapMavenContext.toModelProfiles(allSettingsProfiles), (ProfileActivationContext)context, new ModelProblemCollector(){

            public void add(ModelProblemCollectorRequest req) {
                log.error((Object)("Failed to activate a Maven profile: " + req.getMessage()));
            }
        });
        if (!settings.getActiveProfiles().isEmpty()) {
            HashSet activeProfiles = new HashSet(settings.getActiveProfiles());
            selectedProfiles.forEach(p -> activeProfiles.remove(p.getId()));
            if (!activeProfiles.isEmpty()) {
                ArrayList allActiveProfiles = new ArrayList(selectedProfiles.size() + activeProfiles.size());
                allActiveProfiles.addAll(selectedProfiles);
                for (Profile profile : allSettingsProfiles) {
                    if (!activeProfiles.contains(profile.getId())) continue;
                    allActiveProfiles.add(SettingsUtils.convertFromSettingsProfile((Profile)profile));
                }
                selectedProfiles = allActiveProfiles;
            }
        }
        this.activeSettingsProfiles = selectedProfiles;
        return this.activeSettingsProfiles;
    }

    private static List<org.apache.maven.model.Profile> toModelProfiles(List<Profile> profiles) {
        ArrayList<org.apache.maven.model.Profile> result = new ArrayList<org.apache.maven.model.Profile>(profiles.size());
        for (Profile p : profiles) {
            result.add(SettingsUtils.convertFromSettingsProfile((Profile)p));
        }
        return result;
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        if (repositories.isEmpty()) {
            return false;
        }
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static void addProfileRepos(List<Repository> repositories, List<RemoteRepository> all) {
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.model.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(BootstrapMavenContext.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(BootstrapMavenContext.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    private static RepositoryPolicy toAetherRepoPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        return new RepositoryPolicy(modelPolicy.isEnabled(), BootstrapMavenContext.isEmpty(modelPolicy.getUpdatePolicy()) ? "daily" : modelPolicy.getUpdatePolicy(), BootstrapMavenContext.isEmpty(modelPolicy.getChecksumPolicy()) ? "warn" : modelPolicy.getChecksumPolicy());
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private static Proxy toAetherProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Authentication auth = null;
        if (proxy.getUsername() != null) {
            auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
    }

    private void initRepoSystemAndManager() {
        MavenFactory factory = this.configureMavenFactory();
        if (this.repoSystem == null) {
            this.repoSystem = factory.getRepositorySystem();
        }
        if (this.remoteRepoManager == null) {
            this.remoteRepoManager = (RemoteRepositoryManager)factory.getContainer().requireBean(RemoteRepositoryManager.class);
        }
        if (this.settingsDecrypter == null) {
            this.settingsDecrypter = (SettingsDecrypter)factory.getContainer().requireBean(SettingsDecrypter.class);
        }
    }

    protected MavenFactory configureMavenFactory() {
        return MavenFactory.create((ClassLoader)RepositorySystem.class.getClassLoader(), builder -> {
            for (String pkg : this.includeSisuBeanPackages) {
                builder.includePackage(pkg);
            }
            for (String pkg : this.excludeSisuBeanPackages) {
                builder.excludePackage(pkg);
            }
            builder.addBean(ModelBuilder.class).setSupplier(scope -> new MavenModelBuilder(this)).setPriority(100).build();
        });
    }

    private static String getUserAgent() {
        return "Apache-Maven/" + BootstrapMavenContext.getMavenVersion() + " (Java " + PropertyUtils.getProperty((String)"java.version") + "; " + PropertyUtils.getProperty((String)"os.name") + " " + PropertyUtils.getProperty((String)"os.version") + ")";
    }

    private static String getMavenVersion() {
        String mvnVersion = PropertyUtils.getProperty((String)"maven.version");
        if (mvnVersion != null) {
            return mvnVersion;
        }
        Properties props = new Properties();
        try (InputStream is = BootstrapMavenContext.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to read Maven version", (Throwable)e);
        }
        return props.getProperty("version", "unknown-version");
    }

    public boolean isCurrentProjectExists() {
        return this.currentProjectExists == null ? (this.currentProjectExists = Boolean.valueOf(this.getCurrentProjectPomOrNull() != null)) : this.currentProjectExists;
    }

    public Path getCurrentProjectPomOrNull() {
        if (this.currentPom != null || this.currentProjectExists != null && !this.currentProjectExists.booleanValue()) {
            return this.currentPom;
        }
        Path pom = this.resolveCurrentPom();
        this.currentProjectExists = pom != null;
        this.currentPom = this.currentProjectExists != false ? pom : null;
        return this.currentPom;
    }

    private Path resolveCurrentPom() {
        String basedirProp;
        String cliPomName;
        Path alternatePom = null;
        if (this.alternatePomName != null && (alternatePom = Paths.get(this.alternatePomName, new String[0])).isAbsolute()) {
            return BootstrapMavenContext.pomXmlOrNull(alternatePom);
        }
        if (alternatePom == null && (cliPomName = this.getCliOptions().getOptionValue("f")) != null) {
            alternatePom = Path.of(cliPomName, new String[0]);
        }
        if ((basedirProp = PropertyUtils.getProperty((String)BASEDIR)) != null) {
            return BootstrapMavenContext.getPomForDirOrNull(Path.of(basedirProp, new String[0]), alternatePom);
        }
        if (alternatePom != null && alternatePom.isAbsolute()) {
            return BootstrapMavenContext.pomXmlOrNull(alternatePom);
        }
        Path basedir = Path.of("", new String[0]).normalize().toAbsolutePath();
        if (alternatePom != null) {
            return BootstrapMavenContext.pomXmlOrNull(basedir.resolve(alternatePom));
        }
        Path pom = basedir.resolve("pom.xml");
        return Files.exists(pom, new LinkOption[0]) ? pom : null;
    }

    static Path getPomForDirOrNull(Path basedir, Path alternatePom) {
        Path pom;
        if (alternatePom != null && (alternatePom.getNameCount() == 1 || basedir.endsWith(alternatePom.getParent()))) {
            if (alternatePom.isAbsolute()) {
                return alternatePom;
            }
            pom = basedir.resolve(alternatePom.getFileName());
            if (Files.exists(pom, new LinkOption[0])) {
                return pom;
            }
        }
        if (Files.exists(pom = basedir.resolve("pom.xml"), new LinkOption[0])) {
            return pom;
        }
        return null;
    }

    private static Path pomXmlOrNull(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve("pom.xml");
        }
        return Files.exists(path, new LinkOption[0]) ? path.normalize() : null;
    }

    public Path getCurrentProjectBaseDir() {
        if (this.currentProject != null) {
            return this.currentProject.getDir();
        }
        String basedirProp = PropertyUtils.getProperty((String)BASEDIR);
        return basedirProp == null ? Path.of("", new String[0]).normalize().toAbsolutePath() : Paths.get(basedirProp, new String[0]);
    }

    public Path getRootProjectBaseDir() {
        return this.rootProjectDir;
    }

    public boolean isPreferPomsFromWorkspace() {
        return this.preferPomsFromWorkspace;
    }

    public boolean isEffectiveModelBuilder() {
        if (this.effectiveModelBuilder == null) {
            String s = PropertyUtils.getProperty((String)EFFECTIVE_MODEL_BUILDER_PROP);
            this.effectiveModelBuilder = s == null ? false : Boolean.parseBoolean(s);
        }
        return this.effectiveModelBuilder;
    }

    public boolean isWorkspaceModuleParentHierarchy() {
        return this.wsModuleParentHierarchy == null ? false : this.wsModuleParentHierarchy;
    }

    static void readMavenReposFromEnv(List<RemoteRepository> repos, Map<String, String> env) {
        String envRepos = env.get(BOOTSTRAP_MAVEN_REPOS);
        if (envRepos == null || envRepos.isBlank()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < envRepos.length(); ++i) {
            char c = envRepos.charAt(i);
            if (c == ',') {
                BootstrapMavenContext.initMavenRepoFromEnv(envRepos, buf.toString(), env, repos);
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            BootstrapMavenContext.initMavenRepoFromEnv(envRepos, buf.toString(), env, repos);
        }
    }

    private static void initMavenRepoFromEnv(String envRepos, String repoId, Map<String, String> env, List<RemoteRepository> repos) {
        String envRepoId = BootstrapMavenContext.toEnvVarPart(repoId);
        String repoUrl = null;
        boolean snapshot = true;
        boolean release = true;
        for (Map.Entry<String, String> envvar : env.entrySet()) {
            String varName = envvar.getKey();
            if (!varName.startsWith(BOOTSTRAP_MAVEN_REPO_PREFIX) || !varName.regionMatches(BOOTSTRAP_MAVEN_REPO_PREFIX.length(), envRepoId, 0, envRepoId.length())) continue;
            if (BootstrapMavenContext.isMavenRepoEnvVarOption(varName, repoId, URL_SUFFIX)) {
                repoUrl = envvar.getValue();
                continue;
            }
            if (BootstrapMavenContext.isMavenRepoEnvVarOption(varName, repoId, SNAPSHOT_SUFFIX)) {
                snapshot = Boolean.parseBoolean(envvar.getValue());
                continue;
            }
            if (!BootstrapMavenContext.isMavenRepoEnvVarOption(varName, repoId, RELEASE_SUFFIX)) continue;
            release = Boolean.parseBoolean(envvar.getValue());
        }
        if (repoUrl == null || repoUrl.isBlank()) {
            log.warn((Object)("Maven repository " + repoId + " listed in BOOTSTRAP_MAVEN_REPOS=" + envRepos + " was ignored because the corresponding BOOTSTRAP_MAVEN_REPO_" + envRepoId + "_URL is missing"));
        } else {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repoId, MAVEN_RESOLVER_TRANSPORT_DEFAULT, repoUrl);
            if (!release) {
                repoBuilder.setReleasePolicy(new RepositoryPolicy(false, "daily", "warn"));
            }
            if (!snapshot) {
                repoBuilder.setSnapshotPolicy(new RepositoryPolicy(false, "daily", "warn"));
            }
            repos.add(repoBuilder.build());
        }
    }

    private static String toEnvVarPart(String s) {
        StringBuilder buf = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '.' || c == '-') {
                buf.append('_');
                continue;
            }
            buf.append(Character.toUpperCase(c));
        }
        return buf.toString();
    }

    private static boolean isMavenRepoEnvVarOption(String varName, String repoId, String option) {
        return varName.length() == BOOTSTRAP_MAVEN_REPO_PREFIX.length() + repoId.length() + option.length() && varName.endsWith(option);
    }

    private static FileProfileActivator createFileProfileActivator() throws BootstrapMavenException {
        FileProfileActivator activator = new FileProfileActivator();
        DefaultPathTranslator translator = new DefaultPathTranslator();
        try {
            ProfileActivationFilePathInterpolator pathInterpolator = new ProfileActivationFilePathInterpolator();
            pathInterpolator.setPathTranslator((PathTranslator)translator);
            activator.setProfileActivationFilePathInterpolator(pathInterpolator);
        }
        catch (NoClassDefFoundError e) {
            try {
                activator.getClass().getMethod("setPathTranslator", PathTranslator.class).invoke((Object)activator, translator);
            }
            catch (ReflectiveOperationException reflectionExc) {
                throw new BootstrapMavenException("Failed to set up DefaultPathTranslator for Maven < 3.8.5 DefaultPathTranslator", reflectionExc);
            }
        }
        return activator;
    }
}

