/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.context;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ArcContextProvider
implements ThreadContextProvider {
    protected static final ThreadContextController NOOP_CONTROLLER = new ThreadContextController(){

        public void endContext() throws IllegalStateException {
        }
    };
    private static final ThreadContextSnapshot NULL_CONTEXT_SNAPSHOT = new NullContextSnapshot();
    private static final ThreadContextSnapshot CLEAR_CONTEXT_SNAPSHOT = new ClearContextSnapshot();

    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        InjectableContext.ContextState state = null;
        ManagedContext requestContext = arc.requestContext();
        if (requestContext.isActive()) {
            state = requestContext.getState();
        }
        if (state == null) {
            return NULL_CONTEXT_SNAPSHOT;
        }
        return new ContextSnapshot(state);
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        return CLEAR_CONTEXT_SNAPSHOT;
    }

    public String getThreadContextType() {
        return "CDI";
    }

    private static class RestoreContextController
    implements ThreadContextController {
        private final ManagedContext requestContext;
        private final InjectableContext.ContextState stateToRestore;

        RestoreContextController(ManagedContext requestContext, InjectableContext.ContextState stateToRestore) {
            this.requestContext = requestContext;
            this.stateToRestore = stateToRestore;
        }

        public void endContext() throws IllegalStateException {
            this.requestContext.deactivate();
            this.requestContext.activate(this.stateToRestore);
        }
    }

    private static final class ContextSnapshot
    implements ThreadContextSnapshot {
        private final InjectableContext.ContextState state;

        public ContextSnapshot(InjectableContext.ContextState state) {
            this.state = state;
        }

        public ThreadContextController begin() {
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                return NOOP_CONTROLLER;
            }
            ManagedContext requestContext = arcContainer.requestContext();
            if (requestContext.isActive()) {
                InjectableContext.ContextState stateToRestore = requestContext.getState();
                requestContext.deactivate();
                requestContext.activate(this.state);
                return new RestoreContextController(requestContext, stateToRestore);
            }
            requestContext.activate(this.state);
            return () -> ((ManagedContext)requestContext).deactivate();
        }
    }

    private static final class NullContextSnapshot
    implements ThreadContextSnapshot {
        private NullContextSnapshot() {
        }

        public ThreadContextController begin() {
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                return NOOP_CONTROLLER;
            }
            final ManagedContext requestContext = arcContainer.requestContext();
            if (requestContext.isActive()) {
                final InjectableContext.ContextState stateToRestore = requestContext.getState();
                requestContext.deactivate();
                return new ThreadContextController(){

                    public void endContext() throws IllegalStateException {
                        requestContext.activate(stateToRestore);
                    }
                };
            }
            return NOOP_CONTROLLER;
        }
    }

    private static final class ClearContextSnapshot
    implements ThreadContextSnapshot {
        private ClearContextSnapshot() {
        }

        public ThreadContextController begin() {
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                return NOOP_CONTROLLER;
            }
            ManagedContext requestContext = arcContainer.requestContext();
            if (requestContext.isActive()) {
                InjectableContext.ContextState stateToRestore = requestContext.getState();
                requestContext.deactivate();
                requestContext.activate();
                return new RestoreContextController(requestContext, stateToRestore);
            }
            requestContext.activate();
            return () -> ((ManagedContext)requestContext).deactivate();
        }
    }
}

