/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketReconnectHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.websocket.server.ServerEndpointConfig;

public class WebSocketDeploymentInfo
implements Cloneable {
    public static final String ATTRIBUTE_NAME = "io.undertow.websockets.jsr.WebSocketDeploymentInfo";
    private boolean dispatchToWorkerThread = false;
    private final List<Class<?>> annotatedEndpoints = new ArrayList();
    private final List<ServerEndpointConfig> programaticEndpoints = new ArrayList<ServerEndpointConfig>();
    private final List<ContainerReadyListener> containerReadyListeners = new ArrayList<ContainerReadyListener>();
    private final List<WebSocketServerExtensionHandshaker> serverExtensions = new ArrayList<WebSocketServerExtensionHandshaker>();
    private String clientBindAddress = null;
    private WebSocketReconnectHandler reconnectHandler;
    private EventLoopGroup eventLoopGroup;
    private Supplier<Executor> executor;

    public WebSocketDeploymentInfo addEndpoint(Class<?> annotated) {
        this.annotatedEndpoints.add(annotated);
        return this;
    }

    public WebSocketDeploymentInfo addAnnotatedEndpoints(Collection<Class<?>> annotatedEndpoints) {
        this.annotatedEndpoints.addAll(annotatedEndpoints);
        return this;
    }

    public WebSocketDeploymentInfo addEndpoint(ServerEndpointConfig endpoint) {
        this.programaticEndpoints.add(endpoint);
        return this;
    }

    public WebSocketDeploymentInfo addProgramaticEndpoints(Collection<ServerEndpointConfig> programaticEndpoints) {
        this.programaticEndpoints.addAll(programaticEndpoints);
        return this;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public Supplier<Executor> getExecutor() {
        return this.executor;
    }

    public WebSocketDeploymentInfo setExecutor(Supplier<Executor> executor) {
        this.executor = executor;
        return this;
    }

    public WebSocketDeploymentInfo setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public List<Class<?>> getAnnotatedEndpoints() {
        return this.annotatedEndpoints;
    }

    public List<ServerEndpointConfig> getProgramaticEndpoints() {
        return this.programaticEndpoints;
    }

    void containerReady(ServerWebSocketContainer container) {
        for (ContainerReadyListener listener : this.containerReadyListeners) {
            listener.ready(container);
        }
    }

    public WebSocketDeploymentInfo addListener(ContainerReadyListener listener) {
        this.containerReadyListeners.add(listener);
        return this;
    }

    public WebSocketDeploymentInfo addListeners(Collection<ContainerReadyListener> listeners) {
        this.containerReadyListeners.addAll(listeners);
        return this;
    }

    public List<ContainerReadyListener> getListeners() {
        return this.containerReadyListeners;
    }

    public boolean isDispatchToWorkerThread() {
        return this.dispatchToWorkerThread;
    }

    public WebSocketDeploymentInfo setDispatchToWorkerThread(boolean dispatchToWorkerThread) {
        this.dispatchToWorkerThread = dispatchToWorkerThread;
        return this;
    }

    public WebSocketDeploymentInfo addServerExtension(WebSocketServerExtensionHandshaker extension) {
        if (null != extension) {
            this.serverExtensions.add(extension);
        }
        return this;
    }

    public WebSocketDeploymentInfo addServerExtensions(Collection<WebSocketServerExtensionHandshaker> extensions) {
        this.serverExtensions.addAll(extensions);
        return this;
    }

    public List<WebSocketServerExtensionHandshaker> getServerExtensions() {
        return this.serverExtensions;
    }

    public String getClientBindAddress() {
        return this.clientBindAddress;
    }

    public WebSocketDeploymentInfo setClientBindAddress(String clientBindAddress) {
        this.clientBindAddress = clientBindAddress;
        return this;
    }

    public WebSocketReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    public WebSocketDeploymentInfo setReconnectHandler(WebSocketReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
        return this;
    }

    public WebSocketDeploymentInfo clone() {
        return new WebSocketDeploymentInfo().setDispatchToWorkerThread(this.dispatchToWorkerThread).addAnnotatedEndpoints(this.annotatedEndpoints).addProgramaticEndpoints(this.programaticEndpoints).addListeners(this.containerReadyListeners).addServerExtensions(this.serverExtensions).setClientBindAddress(this.clientBindAddress).setReconnectHandler(this.reconnectHandler);
    }

    public static interface ContainerReadyListener {
        public void ready(ServerWebSocketContainer var1);
    }
}

