/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.vertx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.ConnectionSSLSessionInfo;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.HttpExchangeBase;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.IoCallback;
import io.undertow.httpcore.OutputChannel;
import io.undertow.httpcore.SSLSessionInfo;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.vertx.PushedHttpServerRequest;
import io.undertow.vertx.VertxBufferImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;

public class VertxHttpExchange
extends HttpExchangeBase
implements HttpExchange,
InputChannel,
OutputChannel,
Handler<Buffer> {
    private static final Logger log = Logger.getLogger(VertxHttpExchange.class);
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private final ConnectionBase connectionBase;
    private long maxEntitySize = -1L;
    private long uploadSize = 0L;
    private final BufferAllocator allocator;
    private final Executor worker;
    private Buffer input1;
    private Deque<Buffer> inputOverflow;
    private boolean waitingForRead = false;
    private BiConsumer<InputChannel, Object> readHandler;
    private Object readHandlerContext;
    private boolean eof = false;
    private boolean eofRead = false;
    private boolean responseDone = false;
    private boolean waitingForWrite;
    private boolean drainHandlerRegistered;
    private volatile boolean writeQueued = false;
    private IOException readError;
    private final Object context;
    private boolean first = true;
    private Handler<AsyncResult<Void>> upgradeHandler;
    private final boolean upgradeRequest;
    private long readTimeout = 60000L;
    private long requestContentLength = -1L;
    private Handler<HttpServerRequest> pushHandler;

    public VertxHttpExchange(HttpServerRequest request, BufferAllocator allocator, Executor worker, Object context) {
        this(request, allocator, worker, context, null);
    }

    public VertxHttpExchange(final HttpServerRequest request, BufferAllocator allocator, Executor worker, Object context, Buffer existingBody) {
        this.request = request;
        this.response = request.response();
        this.connectionBase = (ConnectionBase)request.connection();
        this.allocator = allocator;
        this.worker = worker;
        this.context = context;
        this.input1 = existingBody;
        if (this.isRequestEntityBodyAllowed() && !request.isEnded()) {
            request.handler((Handler)this);
            request.exceptionHandler((Handler)new Handler<Throwable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(Throwable event) {
                    HttpConnection httpConnection = request.connection();
                    synchronized (httpConnection) {
                        if (VertxHttpExchange.this.waitingForRead) {
                            request.connection().notify();
                            if (VertxHttpExchange.this.input1 != null) {
                                VertxHttpExchange.this.input1.getByteBuf().release();
                                VertxHttpExchange.this.input1 = null;
                            }
                            if (VertxHttpExchange.this.inputOverflow != null) {
                                while (!VertxHttpExchange.this.inputOverflow.isEmpty()) {
                                    ((Buffer)VertxHttpExchange.this.inputOverflow.poll()).getByteBuf().release();
                                }
                            }
                        }
                        if (event instanceof IOException) {
                            VertxHttpExchange.this.readError = (IOException)event;
                        } else {
                            VertxHttpExchange.this.readError = new IOException(event);
                        }
                    }
                }
            });
            request.endHandler((Handler)new Handler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(Void event) {
                    boolean terminate = false;
                    BiConsumer readCallback = null;
                    Object readContext = null;
                    HttpConnection httpConnection = request.connection();
                    synchronized (httpConnection) {
                        VertxHttpExchange.this.eof = true;
                        if (VertxHttpExchange.this.requestContentLength != -1L && VertxHttpExchange.this.uploadSize != VertxHttpExchange.this.requestContentLength) {
                            VertxHttpExchange.this.readError = new IOException("Failed to read full request");
                        }
                        if (VertxHttpExchange.this.waitingForRead) {
                            request.connection().notify();
                        }
                        if (VertxHttpExchange.this.readHandler != null) {
                            readCallback = VertxHttpExchange.this.readHandler;
                            VertxHttpExchange.this.readHandler = null;
                            readContext = VertxHttpExchange.this.readHandlerContext;
                            VertxHttpExchange.this.readHandlerContext = null;
                        }
                        if (VertxHttpExchange.this.input1 == null) {
                            terminate = true;
                        }
                    }
                    if (readCallback != null) {
                        readCallback.accept(VertxHttpExchange.this, readContext);
                    }
                    if (terminate) {
                        VertxHttpExchange.this.terminateRequest();
                    }
                }
            });
            request.fetch(1L);
            String cl = request.headers().get(HttpHeaders.CONTENT_LENGTH);
            if (cl != null) {
                try {
                    this.requestContentLength = Long.parseLong(cl);
                }
                catch (Exception e) {
                    this.response.setStatusCode(400);
                    this.response.end();
                    throw new RuntimeException("Failed to parse content length", e);
                }
            }
        } else if (existingBody != null) {
            this.eof = true;
        } else {
            this.terminateRequest();
        }
        request.response().exceptionHandler((Handler)new Handler<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Throwable event) {
                HttpConnection httpConnection = request.connection();
                synchronized (httpConnection) {
                    log.debugf(event, "IO Exception ", new Object[0]);
                    VertxHttpExchange.this.eof = true;
                    if (VertxHttpExchange.this.waitingForRead) {
                        request.connection().notify();
                    }
                    if (event instanceof IOException) {
                        VertxHttpExchange.this.readError = (IOException)event;
                    } else {
                        VertxHttpExchange.this.readError = new IOException(event);
                    }
                }
                VertxHttpExchange.this.terminateResponse();
                VertxHttpExchange.this.close();
            }
        });
        request.response().endHandler((Handler)new Handler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Void event) {
                HttpConnection httpConnection = request.connection();
                synchronized (httpConnection) {
                    if (VertxHttpExchange.this.waitingForWrite || VertxHttpExchange.this.waitingForRead) {
                        request.connection().notify();
                    }
                }
                VertxHttpExchange.this.terminateResponse();
            }
        });
        if (request.headers().contains("Upgrade")) {
            this.upgradeRequest = true;
            ConnectionBase connection = (ConnectionBase)request.connection();
            ChannelHandlerContext c = connection.channelHandlerContext();
            ChannelHandler websocketChannelHandler = c.pipeline().get("websocketExtensionHandler");
            if (websocketChannelHandler != null) {
                c.pipeline().remove(websocketChannelHandler);
            }
        } else {
            this.upgradeRequest = false;
        }
    }

    public Handler<HttpServerRequest> getPushHandler() {
        return this.pushHandler;
    }

    public VertxHttpExchange setPushHandler(Handler<HttpServerRequest> pushHandler) {
        this.pushHandler = pushHandler;
        return this;
    }

    public BufferAllocator getBufferAllocator() {
        return this.allocator;
    }

    public HttpExchange setStatusCode(int code) {
        this.response.setStatusCode(code);
        return this;
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    public List<String> getRequestHeaders(String name) {
        return this.request.headers().getAll(name);
    }

    public boolean containsRequestHeader(String name) {
        return this.request.headers().contains(name);
    }

    public void removeRequestHeader(String name) {
        this.request.headers().remove(name);
    }

    public void setRequestHeader(String name, String value) {
        this.request.headers().set(name, value);
    }

    public Collection<String> getRequestHeaderNames() {
        return this.request.headers().names();
    }

    public void addRequestHeader(String name, String value) {
        this.request.headers().add(name, value);
    }

    public void clearRequestHeaders() {
        this.request.headers().clear();
    }

    public List<String> getResponseHeaders(String name) {
        return this.response.headers().getAll(name);
    }

    public boolean containsResponseHeader(String name) {
        return this.response.headers().contains(name);
    }

    public Object getContext() {
        return this.context;
    }

    public void removeResponseHeader(String name) {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().remove(name);
    }

    public void setResponseHeader(String name, String value) {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().set(name, value);
    }

    public Collection<String> getResponseHeaderNames() {
        return this.response.headers().names();
    }

    public void addResponseHeader(String name, String value) {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().add(name, value);
    }

    public void clearResponseHeaders() {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().clear();
    }

    public String getResponseHeader(String name) {
        return this.response.headers().get(name);
    }

    public String getRequestMethod() {
        return this.request.method().name();
    }

    public String getRequestScheme() {
        return this.request.scheme();
    }

    public String getRequestURI() {
        return this.request.uri();
    }

    public String getProtocol() {
        switch (this.request.version()) {
            case HTTP_1_0: {
                return "HTTP/1.0";
            }
            case HTTP_1_1: {
                return "HTTP/1.1";
            }
            case HTTP_2: {
                return "HTTP/2.0";
            }
        }
        return this.request.version().toString();
    }

    public boolean isInIoThread() {
        return this.connectionBase.channel().eventLoop().inEventLoop();
    }

    public boolean isHttp2() {
        return this.request.version() == HttpVersion.HTTP_2;
    }

    public InputChannel getInputChannel() {
        return this;
    }

    public InetSocketAddress getDestinationAddress() {
        SocketAddress socketAddress = this.request.localAddress();
        if (socketAddress == null) {
            return null;
        }
        return new InetSocketAddress(socketAddress.host(), socketAddress.port());
    }

    public InetSocketAddress getSourceAddress() {
        SocketAddress socketAddress = this.request.remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        return new InetSocketAddress(socketAddress.host(), socketAddress.port());
    }

    public ByteBuf readAsync() throws IOException {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            if (this.readError != null) {
                throw new IOException(this.readError);
            }
            if (this.input1 != null) {
                ByteBuf ret = this.input1.getByteBuf();
                if (this.inputOverflow != null) {
                    this.input1 = this.inputOverflow.poll();
                    if (this.input1 == null && !this.eof) {
                        this.request.fetch(1L);
                    }
                } else {
                    this.input1 = null;
                    if (!this.eof) {
                        this.request.fetch(1L);
                    }
                }
                return ret;
            }
            if (this.eof) {
                this.eofRead = true;
                return null;
            }
            throw new IllegalStateException("readAsync called when isReadable is false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadable() {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            if (this.eofRead) {
                return false;
            }
            return this.input1 != null || this.eof || this.readError != null;
        }
    }

    public <T> void setReadHandler(BiConsumer<InputChannel, T> handler, T context) {
        this.readHandler = handler;
        this.readHandlerContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesAvailable() {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            if (this.input1 != null) {
                return this.input1.getByteBuf().readableBytes();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf readBlocking() throws IOException {
        long readStart = System.currentTimeMillis();
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            while (this.input1 == null && !this.eof && this.readError == null) {
                try {
                    this.waitingForRead = true;
                    long toWait = this.readTimeout - (System.currentTimeMillis() - readStart);
                    if (toWait <= 0L) {
                        throw new IOException("Read timeout");
                    }
                    this.request.connection().wait(toWait);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                finally {
                    this.waitingForRead = false;
                }
            }
            if (this.readError != null) {
                this.terminateRequest();
                throw new IOException(this.readError);
            }
            Buffer ret = this.input1;
            this.input1 = null;
            if (this.inputOverflow != null) {
                this.input1 = this.inputOverflow.poll();
                if (this.input1 == null && !this.request.isEnded()) {
                    this.request.fetch(1L);
                }
            } else if (!this.request.isEnded()) {
                this.request.fetch(1L);
            }
            if (ret == null) {
                this.terminateRequest();
            }
            return ret == null ? null : ret.getByteBuf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            switch (this.request.version()) {
                case HTTP_2: {
                    this.request.response().reset();
                    break;
                }
                default: {
                    this.request.connection().close();
                }
            }
        }
    }

    public EventExecutor getIoThread() {
        return this.connectionBase.channel().eventLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlocking0(ByteBuf data, boolean last) throws IOException {
        if (this.upgradeRequest && this.getStatusCode() != 101) {
            this.response.headers().add("Connection", "close");
        }
        if (this.responseDone) {
            if (last && data == null) {
                return;
            }
            data.release();
            throw new IOException("Response already complete");
        }
        if (last && data == null) {
            this.responseDone = true;
            if (this.upgradeHandler == null) {
                this.request.response().end();
            } else {
                this.request.response().end(this.upgradeHandler);
            }
            return;
        }
        try {
            HttpConnection httpConnection = this.request.connection();
            synchronized (httpConnection) {
                this.awaitWriteable();
                try {
                    if (last) {
                        this.responseDone = true;
                        if (this.upgradeHandler == null) {
                            this.request.response().end(this.createBuffer(data));
                        } else {
                            this.request.response().end(this.createBuffer(data), this.upgradeHandler);
                        }
                    } else {
                        this.request.response().write(this.createBuffer(data));
                    }
                }
                catch (Exception e) {
                    if (data != null && data.refCnt() > 0) {
                        data.release();
                    }
                    throw new IOException("Failed to write", e);
                }
            }
        }
        finally {
            if (last) {
                this.terminateResponse();
            }
        }
    }

    private void awaitWriteable() throws InterruptedIOException {
        assert (Thread.holdsLock(this.request.connection()));
        if (this.first) {
            this.first = false;
            return;
        }
        while (this.request.response().writeQueueFull()) {
            if (this.request.response().closed()) {
                return;
            }
            if (!this.drainHandlerRegistered) {
                this.drainHandlerRegistered = true;
                Handler<Void> handler = new Handler<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Void event) {
                        if (VertxHttpExchange.this.waitingForWrite) {
                            HttpConnection connection;
                            HttpConnection httpConnection = connection = VertxHttpExchange.this.request.connection();
                            synchronized (httpConnection) {
                                connection.notifyAll();
                            }
                        }
                    }
                };
                this.request.response().drainHandler((Handler)handler);
                this.request.response().closeHandler((Handler)handler);
            }
            try {
                this.waitingForWrite = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForWrite = false;
            }
        }
    }

    public <T> void writeAsync0(final ByteBuf data, final boolean last, final IoCallback<T> callback, final T context) {
        block18: {
            if (this.upgradeRequest && this.getStatusCode() != 101) {
                this.response.headers().add("Connection", "close");
            }
            if (this.responseDone) {
                if (data != null) {
                    data.release();
                }
                if (callback != null) {
                    if (last && data == null) {
                        callback.onComplete((HttpExchange)this, context);
                    } else {
                        callback.onException((HttpExchange)this, context, new IOException("Response already complete"));
                    }
                }
                return;
            }
            this.writeQueued = true;
            if (last && data == null) {
                this.responseDone = true;
                if (this.upgradeHandler == null) {
                    this.request.response().end();
                } else {
                    this.request.response().end(this.upgradeHandler);
                }
                this.queueWriteListener(callback, context, last);
                return;
            }
            if (this.request.response().writeQueueFull()) {
                this.request.response().drainHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        block7: {
                            try {
                                if (last) {
                                    VertxHttpExchange.this.responseDone = true;
                                    if (VertxHttpExchange.this.upgradeHandler == null) {
                                        VertxHttpExchange.this.request.response().end(VertxHttpExchange.this.createBuffer(data));
                                    } else {
                                        VertxHttpExchange.this.request.response().end(VertxHttpExchange.this.createBuffer(data), VertxHttpExchange.this.upgradeHandler);
                                    }
                                } else {
                                    VertxHttpExchange.this.request.response().write(VertxHttpExchange.this.createBuffer(data));
                                }
                                VertxHttpExchange.this.queueWriteListener(callback, context, last);
                                VertxHttpExchange.this.request.response().drainHandler(null);
                            }
                            catch (Exception e) {
                                if (data != null && data.refCnt() > 0) {
                                    data.release();
                                }
                                if (callback == null) break block7;
                                callback.onException((HttpExchange)VertxHttpExchange.this, context, new IOException("Write failed", e));
                            }
                        }
                    }
                });
            } else {
                try {
                    if (last) {
                        this.responseDone = true;
                        if (this.upgradeHandler == null) {
                            this.request.response().end(this.createBuffer(data));
                        } else {
                            this.request.response().end(this.createBuffer(data), this.upgradeHandler);
                        }
                    } else {
                        this.request.response().write(this.createBuffer(data));
                    }
                    this.queueWriteListener(callback, context, last);
                }
                catch (Exception e) {
                    if (data != null && data.refCnt() > 0) {
                        data.release();
                    }
                    if (callback == null) break block18;
                    callback.onException((HttpExchange)this, context, new IOException("Write failed", e));
                }
            }
        }
    }

    private <T> void queueWriteListener(final IoCallback<T> callback, final T context, final boolean last) {
        this.connectionBase.channel().eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (last) {
                    VertxHttpExchange.this.terminateResponse();
                }
                if (callback != null) {
                    callback.onComplete((HttpExchange)VertxHttpExchange.this, context);
                }
                VertxHttpExchange.this.writeQueued = false;
            }
        });
    }

    private Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Buffer event) {
        BiConsumer<InputChannel, Object> readCallback = null;
        Object context = null;
        if (event.length() == 0) {
            event.getByteBuf().release();
            return;
        }
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            this.uploadSize += (long)event.length();
            if (this.maxEntitySizeReached() && !this.responseDone) {
                this.eof = true;
                this.responseDone = true;
                this.terminateRequest();
                this.response.setStatusCode(413);
                this.response.putHeader("Connection", "close");
                this.response.end("Request body too large");
                this.close();
                return;
            }
            if (this.input1 == null) {
                this.input1 = event;
            } else {
                if (this.inputOverflow == null) {
                    this.inputOverflow = new ArrayDeque<Buffer>();
                }
                this.inputOverflow.add(event);
            }
            if (this.waitingForRead) {
                this.request.connection().notifyAll();
            }
            if (this.readHandler != null) {
                readCallback = this.readHandler;
                this.readHandler = null;
                context = this.readHandlerContext;
                this.readHandlerContext = null;
            }
        }
        if (readCallback != null) {
            final BiConsumer<InputChannel, Object> f = readCallback;
            final Object c = context;
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    f.accept(VertxHttpExchange.this, c);
                }
            });
        }
    }

    private boolean maxEntitySizeReached() {
        return this.maxEntitySize != -1L && this.uploadSize > this.maxEntitySize;
    }

    public Executor getWorker() {
        return this.worker;
    }

    public UndertowOptionMap getUndertowOptions() {
        return UndertowOptionMap.EMPTY;
    }

    public void sendContinue() {
        this.request.response().writeContinue();
    }

    public void discardRequest() {
        if (!this.eof) {
            this.request.connection().close();
        }
    }

    public boolean isUpgradeSupported() {
        return true;
    }

    public SSLSessionInfo getSslSessionInfo() {
        SSLSession session = this.request.sslSession();
        if (session != null) {
            return new ConnectionSSLSessionInfo(session);
        }
        return null;
    }

    public boolean isPushSupported() {
        return this.request.version() == HttpVersion.HTTP_2 && this.pushHandler != null;
    }

    public void pushResource(final String path, final String method, Map<String, List<String>> requestHeaders) {
        if (!this.isPushSupported()) {
            throw new IllegalStateException("Push not supported");
        }
        final VertxHttpHeaders map = new VertxHttpHeaders();
        for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
            map.add(entry.getKey().toLowerCase(Locale.ENGLISH), (Iterable)entry.getValue());
        }
        this.response.push(HttpMethod.valueOf((String)method), this.request.host(), path, (MultiMap)map, (Handler)new Handler<AsyncResult<HttpServerResponse>>(){

            public void handle(AsyncResult<HttpServerResponse> event) {
                if (event.succeeded()) {
                    PushedHttpServerRequest pushed = new PushedHttpServerRequest(VertxHttpExchange.this.request, HttpMethod.valueOf((String)method), path, (HttpServerResponse)event.result(), (MultiMap)map);
                    VertxHttpExchange.this.pushHandler.handle((Object)pushed);
                }
            }
        });
    }

    public boolean isIoOperationQueued() {
        return this.readHandler != null || this.writeQueued;
    }

    public void setMaxEntitySize(long maxEntitySize) {
        this.maxEntitySize = maxEntitySize;
    }

    public long getMaxEntitySize() {
        return this.maxEntitySize;
    }

    public void setReadTimeout(long readTimeoutMs) {
        this.readTimeout = readTimeoutMs;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setUpgradeListener(final Consumer<Object> listener) {
        Http1xServerConnection connection = (Http1xServerConnection)this.request.connection();
        final ChannelHandlerContext context = connection.channelHandlerContext();
        this.upgradeHandler = new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        VertxHttpExchange.this.terminateResponse();
                        context.pipeline().remove("httpDecoder");
                        context.pipeline().remove("httpEncoder");
                        context.pipeline().remove("handler");
                        listener.accept(context);
                    }
                };
                if (VertxHttpExchange.this.isInIoThread()) {
                    runnable.run();
                } else {
                    VertxHttpExchange.this.getIoThread().execute(runnable);
                }
            }
        };
    }
}

