/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.StaticFieldCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.FieldCreatorImpl;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.ClassFileElement;
import io.smallrye.classfile.Signature;
import io.smallrye.classfile.attribute.ConstantValueAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class StaticFieldCreatorImpl
extends FieldCreatorImpl
implements StaticFieldCreator {
    private Const initial;
    private Consumer<BlockCreator> initializer;

    protected StaticFieldCreatorImpl(TypeCreatorImpl tc, ClassDesc owner, String name) {
        super(owner, name, tc);
    }

    @Override
    public void setInitial(Const initial) {
        Assert.checkNotNullParam((String)"initial", (Object)initial);
        this.checkOneInit();
        this.setType(initial.type());
        if (initial.type().isPrimitive() || Util.equals(initial.type(), ConstantDescs.CD_String)) {
            this.initial = initial;
        } else {
            this.initializer = bc -> bc.setStaticField(this.desc(), initial);
        }
    }

    @Override
    public void setInitializer(Consumer<BlockCreator> init) {
        Assert.checkNotNullParam((String)"init", init);
        this.checkOneInit();
        this.initializer = b0 -> {
            FieldDesc desc = this.desc();
            b0.setStaticField(desc, b0.blockExpr(desc.type(), init));
        };
    }

    private void checkOneInit() {
        if (this.initial != null || this.initializer != null) {
            throw new IllegalStateException("A static field may have only one initializer");
        }
    }

    void accept(Consumer<StaticFieldCreator> builder) {
        builder.accept(this);
        if (this.initializer != null) {
            this.tc.staticInitializer(this.initializer);
        }
        this.tc.zb.withField(this.name(), this.desc().type(), fb -> {
            fb.withFlags(this.modifiers);
            if (this.genericType != null && !this.genericType.isRaw()) {
                fb.with((ClassFileElement)SignatureAttribute.of((Signature)Util.signatureOf(this.genericType())));
            }
            this.addVisible((Consumer<? super RuntimeVisibleAnnotationsAttribute>)fb);
            this.addInvisible((Consumer<? super RuntimeInvisibleAnnotationsAttribute>)fb);
            if (this.initial != null) {
                fb.with((ClassFileElement)ConstantValueAttribute.of((ConstantDesc)this.initial.desc()));
            }
        });
    }
}

