/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.ModifierConfigurator;
import io.quarkus.gizmo2.creator.AccessLevel;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.InterfaceCreator;
import io.quarkus.gizmo2.creator.ModifierFlag;
import io.quarkus.gizmo2.creator.ModifierLocation;
import io.quarkus.gizmo2.impl.ClassCreatorImpl;
import io.quarkus.gizmo2.impl.InterfaceCreatorImpl;
import io.smallrye.classfile.ClassBuilder;
import io.smallrye.classfile.ClassFile;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.function.Consumer;

public final class GizmoImpl
implements Gizmo {
    private static final int[] DEFAULTS = ModifierLocation.values.stream().mapToInt(ModifierLocation::defaultModifierBits).toArray();
    private final ClassOutput outputHandler;
    private final int[] modifiersByLocation;
    private final boolean debugInfo;
    private final boolean parameters;
    private final boolean lambdasAsAnonymousClasses;
    private final ClassFile.Option[] options;

    public GizmoImpl(ClassOutput outputHandler) {
        this(outputHandler, DEFAULTS, true, true, false);
    }

    private GizmoImpl(ClassOutput outputHandler, int[] modifiersByLocation, boolean debugInfo, boolean parameters, boolean lambdasAsAnonymousClasses) {
        this.outputHandler = outputHandler;
        this.modifiersByLocation = modifiersByLocation;
        this.debugInfo = debugInfo;
        this.parameters = parameters;
        this.lambdasAsAnonymousClasses = lambdasAsAnonymousClasses;
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(ClassFile.StackMapsOption.DROP_STACK_MAPS);
        if (!debugInfo) {
            options.add(ClassFile.DebugElementsOption.DROP_DEBUG);
            options.add(ClassFile.LineNumbersOption.DROP_LINE_NUMBERS);
        }
        this.options = (ClassFile.Option[])options.toArray(ClassFile.Option[]::new);
    }

    int getDefaultModifiers(ModifierLocation location) {
        return this.modifiersByLocation[location.ordinal()];
    }

    ClassFile createClassFile() {
        return ClassFile.of((ClassFile.Option[])this.options);
    }

    @Override
    public Gizmo withDefaultModifiers(Consumer<ModifierConfigurator> builder) {
        final int[] flags = (int[])this.modifiersByLocation.clone();
        ModifierConfigurator configurator = new ModifierConfigurator(){

            @Override
            public void remove(ModifierLocation location, ModifierFlag modifierFlag) {
                if (location.requires(modifierFlag)) {
                    throw new IllegalArgumentException("Flag %s cannot be removed for location %s".formatted(new Object[]{modifierFlag, location}));
                }
                int n = location.ordinal();
                flags[n] = flags[n] & ~modifierFlag.mask();
            }

            @Override
            public void add(ModifierLocation location, ModifierFlag modifierFlag) {
                if (!location.supports(modifierFlag)) {
                    throw new IllegalArgumentException("Flag %s cannot be set for location %s".formatted(new Object[]{modifierFlag, location}));
                }
                modifierFlag.forEachExclusive(f -> this.remove(location, (ModifierFlag)f));
                int n = location.ordinal();
                flags[n] = flags[n] | modifierFlag.mask();
            }

            @Override
            public void set(ModifierLocation location, AccessLevel accessLevel) {
                if (!accessLevel.validIn(location)) {
                    throw new IllegalArgumentException("Access level %s is not valid for location %s".formatted(new Object[]{accessLevel, location}));
                }
                int n = location.ordinal();
                flags[n] = flags[n] & AccessLevel.fullMask();
                int n2 = location.ordinal();
                flags[n2] = flags[n2] | accessLevel.mask();
            }
        };
        builder.accept(configurator);
        return new GizmoImpl(this.outputHandler, (int[])flags.clone(), this.debugInfo, this.parameters, this.lambdasAsAnonymousClasses);
    }

    boolean parameters() {
        return this.parameters;
    }

    boolean lambdasAsAnonymousClasses() {
        return this.lambdasAsAnonymousClasses;
    }

    @Override
    public Gizmo withOutput(ClassOutput outputHandler) {
        return new GizmoImpl(outputHandler, this.modifiersByLocation, this.debugInfo, this.parameters, this.lambdasAsAnonymousClasses);
    }

    @Override
    public Gizmo withDebugInfo(boolean debugInfo) {
        return new GizmoImpl(this.outputHandler, this.modifiersByLocation, debugInfo, this.parameters, this.lambdasAsAnonymousClasses);
    }

    @Override
    public Gizmo withParameters(boolean parameters) {
        return new GizmoImpl(this.outputHandler, this.modifiersByLocation, this.debugInfo, parameters, this.lambdasAsAnonymousClasses);
    }

    @Override
    public Gizmo withLambdasAsAnonymousClasses(boolean lambdasAsAnonymousClasses) {
        return new GizmoImpl(this.outputHandler, this.modifiersByLocation, this.debugInfo, this.parameters, lambdasAsAnonymousClasses);
    }

    @Override
    public ClassDesc class_(ClassDesc desc, Consumer<ClassCreator> builder) {
        if (!desc.isClassOrInterface()) {
            throw new IllegalArgumentException("Descriptor must describe a valid class");
        }
        ClassFile cf = this.createClassFile();
        byte[] bytes = cf.build(desc, zb -> {
            ClassCreatorImpl tc = new ClassCreatorImpl(this, desc, this.outputHandler, (ClassBuilder)zb);
            tc.preAccept();
            builder.accept(tc);
            tc.postAccept();
        });
        this.outputHandler.write(desc, bytes);
        return desc;
    }

    @Override
    public ClassDesc interface_(ClassDesc desc, Consumer<InterfaceCreator> builder) {
        if (!desc.isClassOrInterface()) {
            throw new IllegalArgumentException("Descriptor must describe a valid class");
        }
        ClassFile cf = this.createClassFile();
        byte[] bytes = cf.build(desc, zb -> {
            InterfaceCreatorImpl tc = new InterfaceCreatorImpl(this, desc, this.outputHandler, (ClassBuilder)zb);
            tc.accept(builder);
        });
        this.outputHandler.write(desc, bytes);
        return desc;
    }
}

