/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;

public enum TypeKind {
    BOOLEAN(io.smallrye.classfile.TypeKind.BOOLEAN),
    BYTE(io.smallrye.classfile.TypeKind.BYTE),
    CHAR(io.smallrye.classfile.TypeKind.CHAR),
    SHORT(io.smallrye.classfile.TypeKind.SHORT),
    INT(io.smallrye.classfile.TypeKind.INT),
    LONG(io.smallrye.classfile.TypeKind.LONG),
    FLOAT(io.smallrye.classfile.TypeKind.FLOAT),
    DOUBLE(io.smallrye.classfile.TypeKind.DOUBLE),
    REFERENCE(io.smallrye.classfile.TypeKind.REFERENCE),
    VOID(io.smallrye.classfile.TypeKind.VOID);

    private final io.smallrye.classfile.TypeKind actualKind;

    private TypeKind(io.smallrye.classfile.TypeKind actualKind) {
        this.actualKind = actualKind;
    }

    public ClassDesc upperBound() {
        return this.actualKind.upperBound();
    }

    public int slotSize() {
        return this.actualKind.slotSize();
    }

    public TypeKind asLoadable() {
        return TypeKind.of(this.actualKind.asLoadable());
    }

    static TypeKind of(io.smallrye.classfile.TypeKind actualKind) {
        return switch (actualKind) {
            default -> throw new IncompatibleClassChangeError();
            case io.smallrye.classfile.TypeKind.BOOLEAN -> BOOLEAN;
            case io.smallrye.classfile.TypeKind.BYTE -> BYTE;
            case io.smallrye.classfile.TypeKind.CHAR -> CHAR;
            case io.smallrye.classfile.TypeKind.SHORT -> SHORT;
            case io.smallrye.classfile.TypeKind.INT -> INT;
            case io.smallrye.classfile.TypeKind.LONG -> LONG;
            case io.smallrye.classfile.TypeKind.FLOAT -> FLOAT;
            case io.smallrye.classfile.TypeKind.DOUBLE -> DOUBLE;
            case io.smallrye.classfile.TypeKind.REFERENCE -> REFERENCE;
            case io.smallrye.classfile.TypeKind.VOID -> VOID;
        };
    }

    public static TypeKind from(String descriptor) {
        char ch = descriptor.charAt(0);
        return switch (ch) {
            case 'Z' -> BOOLEAN;
            case 'B' -> BYTE;
            case 'C' -> CHAR;
            case 'S' -> SHORT;
            case 'I' -> INT;
            case 'J' -> LONG;
            case 'F' -> FLOAT;
            case 'D' -> DOUBLE;
            case 'V' -> VOID;
            case 'L', '[' -> REFERENCE;
            default -> throw Assert.impossibleSwitchCase((char)ch);
        };
    }

    public static TypeKind from(ClassDesc descriptor) {
        return TypeKind.from(descriptor.descriptorString());
    }

    public static TypeKind from(Class<?> clazz) {
        return clazz.isPrimitive() ? TypeKind.from(clazz.descriptorString()) : REFERENCE;
    }
}

