/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.WithCaching;
import io.quarkus.arc.impl.BeanManagerProvider;
import io.quarkus.arc.impl.BeanMetadataProvider;
import io.quarkus.arc.impl.EventProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.InstanceProvider;
import io.quarkus.arc.impl.InterceptedDecoratedBeanMetadataProvider;
import io.quarkus.arc.impl.ListProvider;
import io.quarkus.arc.impl.ResourceProvider;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptionProxyGenerator;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.RuntimeTypeCreator;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.This;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public enum BuiltinBean {
    INSTANCE(BuiltinBean::generateInstanceBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInstance, DotNames.INSTANCE, DotNames.PROVIDER, DotNames.INJECTABLE_INSTANCE),
    INJECTION_POINT(BuiltinBean::generateInjectionPointBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInjectionPoint, DotNames.INJECTION_POINT),
    BEAN(BuiltinBean::generateBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && ip.hasDefaultedQualifier(), BuiltinBean::validateBean, DotNames.BEAN),
    INTERCEPTED_BEAN(BuiltinBean::generateInterceptedDecoratedBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.INTERCEPTED), BuiltinBean::validateInterceptedBean, DotNames.BEAN),
    DECORATED_BEAN(BuiltinBean::generateInterceptedDecoratedBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.DECORATED), BuiltinBean::validateDecoratedBean, DotNames.BEAN),
    BEAN_MANAGER(BuiltinBean::generateBeanManagerBytecode, DotNames.BEAN_MANAGER, DotNames.BEAN_CONTAINER),
    EVENT(BuiltinBean::generateEventBytecode, DotNames.EVENT),
    RESOURCE(BuiltinBean::generateResourceBytecode, (ip, names) -> ip.getKind() == InjectionPointInfo.InjectionPointKind.RESOURCE, DotNames.OBJECT),
    EVENT_METADATA(Generator.NOOP, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateEventMetadata, DotNames.EVENT_METADATA),
    LIST(BuiltinBean::generateListBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.LIST) && ip.getRequiredQualifier(DotNames.ALL) != null, BuiltinBean::validateList, DotNames.LIST),
    INTERCEPTION_PROXY(BuiltinBean::generateInterceptionProxyBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInterceptionProxy, DotNames.INTERCEPTION_PROXY);

    private final DotName[] rawTypeDotNames;
    private final Generator generator;
    private final BiPredicate<InjectionPointInfo, DotName[]> matcher;
    private final Validator validator;

    private BuiltinBean(Generator generator, DotName ... rawTypeDotNames) {
        this(generator, BuiltinBean::cdiAndRawTypeMatches, rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, BiPredicate<InjectionPointInfo, DotName[]> matcher, DotName ... rawTypeDotNames) {
        this(generator, matcher, Validator.NOOP, rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, BiPredicate<InjectionPointInfo, DotName[]> matcher, Validator validator, DotName ... rawTypeDotNames) {
        this.rawTypeDotNames = rawTypeDotNames;
        this.generator = generator;
        this.matcher = matcher;
        this.validator = validator;
    }

    public boolean matches(InjectionPointInfo injectionPoint) {
        return this.matcher.test(injectionPoint, this.rawTypeDotNames);
    }

    DotName[] getRawTypeDotNames() {
        return this.rawTypeDotNames;
    }

    boolean hasRawTypeDotName(DotName name) {
        for (DotName rawTypeDotName : this.rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    Generator getGenerator() {
        return this.generator;
    }

    Validator getValidator() {
        return this.validator;
    }

    public static boolean resolvesTo(InjectionPointInfo injectionPoint) {
        return BuiltinBean.resolve(injectionPoint) != null;
    }

    public static BuiltinBean resolve(InjectionPointInfo injectionPoint) {
        for (BuiltinBean bean : BuiltinBean.values()) {
            if (!bean.matches(injectionPoint)) continue;
            return bean;
        }
        return null;
    }

    private static boolean cdiAndRawTypeMatches(InjectionPointInfo injectionPoint, DotName ... rawTypeDotNames) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        for (DotName rawTypeDotName : rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)injectionPoint.getType().name())) continue;
            return true;
        }
        return false;
    }

    private static void generateInstanceBytecode(GeneratorContext ctx) {
        Const javaMember;
        Expr annotations;
        Const bean;
        Var qualifiers = BeanGenerator.collectInjectionPointQualifiers(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        LocalVar parameterizedType = RuntimeTypeCreator.of(ctx.constructor).create(ctx.injectionPoint.getType());
        Set<BeanInfo> beans = ctx.beanDeployment.beanResolver.resolveBeans(ctx.injectionPoint.getRequiredType(), ctx.injectionPoint.getRequiredQualifiers());
        boolean collectMetadata = beans.stream().anyMatch(b -> BuiltinScope.DEPENDENT.isDeclaredBy((BeanInfo)b) && b.requiresInjectionPointMetadata());
        if (collectMetadata) {
            bean = switch (ctx.injectionTarget.kind()) {
                case InjectionTargetInfo.TargetKind.OBSERVER -> ctx.constructor.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)ctx.declaringBeanSupplier);
                case InjectionTargetInfo.TargetKind.BEAN -> ctx.clazzCreator.this_();
                case InjectionTargetInfo.TargetKind.INVOKER -> BuiltinBean.loadInvokerTargetBean(ctx.injectionTarget.asInvoker(), ctx.constructor);
                default -> throw new IllegalStateException("Unsupported target info: " + String.valueOf(ctx.injectionTarget));
            };
            annotations = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
            javaMember = BeanGenerator.getJavaMember(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        } else {
            bean = Const.ofNull(InjectableBean.class);
            annotations = BuiltinBean.collectWithCaching(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint);
            javaMember = Const.ofNull(Member.class);
        }
        Expr instanceProvider = ctx.constructor.new_(ConstructorDesc.of(InstanceProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE}), new Expr[]{parameterizedType, qualifiers, bean, annotations, javaMember, Const.of((int)ctx.injectionPoint.getPosition()), Const.of((boolean)ctx.injectionPoint.isTransient())});
        Expr instanceProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, instanceProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), instanceProviderSupplier);
    }

    private static void generateEventBytecode(GeneratorContext ctx) {
        LocalVar qualifiers = ctx.constructor.localVar("qualifiers", ctx.constructor.new_(HashSet.class));
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance qualifier : ctx.injectionPoint.getRequiredQualifiers()) {
                BuiltinQualifier builtinQualifier = BuiltinQualifier.of(qualifier);
                if (builtinQualifier != null) {
                    ctx.constructor.withSet((Expr)qualifiers).add((Expr)builtinQualifier.getLiteralInstance());
                    continue;
                }
                ClassInfo qualifierClass = ctx.beanDeployment.getQualifier(qualifier.name());
                ctx.constructor.withSet((Expr)qualifiers).add(ctx.annotationLiterals.create(ctx.constructor, qualifierClass, qualifier));
            }
        }
        LocalVar parameterizedType = RuntimeTypeCreator.of(ctx.constructor).create(ctx.injectionPoint.getType());
        Var annotations = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
        Var javaMember = BeanGenerator.getJavaMember(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        This bean = switch (ctx.injectionTarget.kind()) {
            case InjectionTargetInfo.TargetKind.OBSERVER -> ctx.constructor.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)ctx.declaringBeanSupplier);
            case InjectionTargetInfo.TargetKind.BEAN -> ctx.clazzCreator.this_();
            case InjectionTargetInfo.TargetKind.INVOKER -> BuiltinBean.loadInvokerTargetBean(ctx.injectionTarget.asInvoker(), ctx.constructor);
            default -> throw new IllegalStateException("Unsupported target info: " + String.valueOf(ctx.injectionTarget));
        };
        Expr injectionPoint = ctx.constructor.new_(MethodDescs.INJECTION_POINT_IMPL_CONSTRUCTOR, new Expr[]{parameterizedType, parameterizedType, qualifiers, bean, annotations, javaMember, Const.of((int)ctx.injectionPoint.getPosition()), Const.of((boolean)ctx.injectionPoint.isTransient())});
        Expr eventProvider = ctx.constructor.new_(ConstructorDesc.of(EventProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectionPoint.class}), new Expr[]{parameterizedType, qualifiers, injectionPoint});
        Expr eventProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, eventProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), eventProviderSupplier);
    }

    private static void generateInjectionPointBytecode(GeneratorContext ctx) {
        Expr injectionPointProvider = ctx.constructor.new_(InjectionPointProvider.class);
        Expr injectionPointProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, injectionPointProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), injectionPointProviderSupplier);
    }

    private static void generateBeanBytecode(GeneratorContext ctx) {
        Expr beanProvider = ctx.constructor.new_(ConstructorDesc.of(BeanMetadataProvider.class, (Class[])new Class[]{String.class}), (Expr)Const.of((String)ctx.injectionTarget.asBean().getIdentifier()));
        Expr beanProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, beanProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), beanProviderSupplier);
    }

    private static void generateInterceptedDecoratedBeanBytecode(GeneratorContext ctx) {
        Expr beanMetadataProvider = ctx.constructor.new_(InterceptedDecoratedBeanMetadataProvider.class);
        Expr beanMetadataProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, beanMetadataProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), beanMetadataProviderSupplier);
    }

    private static void generateBeanManagerBytecode(GeneratorContext ctx) {
        Expr beanManagerProvider = ctx.constructor.new_(BeanManagerProvider.class);
        Expr beanManagerProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, beanManagerProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), beanManagerProviderSupplier);
    }

    private static void generateResourceBytecode(GeneratorContext ctx) {
        LocalVar annotations = ctx.constructor.localVar("annotations", ctx.constructor.new_(HashSet.class));
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance annotation : ctx.injectionPoint.getRequiredQualifiers()) {
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(ctx.beanDeployment.getBeanArchiveIndex(), annotation.name());
                if (annotationClass == null) continue;
                ctx.constructor.withSet((Expr)annotations).add(ctx.annotationLiterals.create(ctx.constructor, annotationClass, annotation));
            }
        }
        LocalVar parameterizedType = RuntimeTypeCreator.of(ctx.constructor).create(ctx.injectionPoint.getType());
        Expr resourceProvider = ctx.constructor.new_(ConstructorDesc.of(ResourceProvider.class, (Class[])new Class[]{Type.class, Set.class}), (Expr)parameterizedType, (Expr)annotations);
        Expr resourceProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, resourceProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), resourceProviderSupplier);
    }

    private static void generateListBytecode(GeneratorContext ctx) {
        Const javaMember;
        Const annotations;
        Const bean;
        Const usesInstance;
        LocalVar requiredType;
        InjectionPointInfo injectionPoint = ctx.injectionPoint;
        if (injectionPoint.isField()) {
            ctx.reflectionRegistration.registerField(injectionPoint.getAnnotationTarget().asField());
        } else if (injectionPoint.isParam()) {
            ctx.reflectionRegistration.registerMethod(injectionPoint.getAnnotationTarget().asMethodParameter().method());
        }
        LocalVar injectionPointType = RuntimeTypeCreator.of(ctx.constructor).create(ctx.injectionPoint.getType());
        org.jboss.jandex.Type type = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0);
        if (type.name().equals((Object)DotNames.INSTANCE_HANDLE)) {
            requiredType = RuntimeTypeCreator.of(ctx.constructor).create((org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0));
            usesInstance = Const.of((boolean)true);
        } else {
            requiredType = RuntimeTypeCreator.of(ctx.constructor).create(type);
            usesInstance = Const.of((boolean)false);
        }
        Var qualifiers = BeanGenerator.collectInjectionPointQualifiers(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        Set<BeanInfo> beans = ctx.beanDeployment.beanResolver.resolveBeans(type.name().equals((Object)DotNames.INSTANCE_HANDLE) ? (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0) : type, ctx.injectionPoint.getRequiredQualifiers().stream().filter(a -> !a.name().equals((Object)DotNames.ALL)).collect(Collectors.toSet()));
        boolean collectMetadata = beans.stream().anyMatch(b -> BuiltinScope.DEPENDENT.isDeclaredBy((BeanInfo)b) && b.requiresInjectionPointMetadata());
        if (collectMetadata) {
            bean = switch (ctx.injectionTarget.kind()) {
                case InjectionTargetInfo.TargetKind.OBSERVER -> ctx.constructor.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)ctx.declaringBeanSupplier);
                case InjectionTargetInfo.TargetKind.BEAN -> ctx.clazzCreator.this_();
                case InjectionTargetInfo.TargetKind.INVOKER -> BuiltinBean.loadInvokerTargetBean(ctx.injectionTarget.asInvoker(), ctx.constructor);
                default -> throw new IllegalStateException("Unsupported target info: " + String.valueOf(ctx.injectionTarget));
            };
            annotations = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
            javaMember = BeanGenerator.getJavaMember(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        } else {
            bean = Const.ofNull(InjectableBean.class);
            annotations = Const.ofNull(Set.class);
            javaMember = Const.ofNull(Member.class);
        }
        Expr listProvider = ctx.constructor.new_(ConstructorDesc.of(ListProvider.class, (Class[])new Class[]{Type.class, Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}), new Expr[]{requiredType, injectionPointType, qualifiers, bean, annotations, javaMember, Const.of((int)ctx.injectionPoint.getPosition()), Const.of((boolean)ctx.injectionPoint.isTransient()), usesInstance});
        Expr listProviderSupplier = ctx.constructor.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, listProvider);
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), listProviderSupplier);
    }

    private static void generateInterceptionProxyBytecode(GeneratorContext ctx) {
        BeanInfo bean = ctx.injectionTarget.asBean();
        String name = InterceptionProxyGenerator.interceptionProxyProviderName(bean);
        Expr supplier = ctx.constructor.new_(ConstructorDesc.of((ClassDesc)ClassDesc.of(name)));
        ctx.constructor.set((Assignable)ctx.clazzCreator.this_().field(ctx.providerField), supplier);
    }

    private static Expr loadInvokerTargetBean(InvokerInfo invoker, BlockCreator bc) {
        return bc.invokeInterface(MethodDescs.ARC_CONTAINER_BEAN, bc.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER), (Expr)Const.of((String)invoker.targetBean.getIdentifier()));
    }

    private static Expr collectWithCaching(BeanDeployment beanDeployment, BlockCreator bc, InjectionPointInfo injectionPoint) {
        AnnotationTarget annotationTarget = injectionPoint.isParam() ? injectionPoint.getAnnotationTarget().asMethodParameter().method() : injectionPoint.getAnnotationTarget();
        Expr annotations = !injectionPoint.isSynthetic() && Annotations.contains(beanDeployment.getAnnotations(annotationTarget), DotNames.WITH_CACHING) ? bc.setOf(new Expr[]{Expr.staticField((FieldDesc)FieldDesc.of(WithCaching.Literal.class, (String)"INSTANCE"))}) : bc.setOf(new Expr[0]);
        return annotations;
    }

    private static void validateInstance(ValidatorContext ctx) {
        if (ctx.injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("An injection point of raw type jakarta.enterprise.inject.Instance is defined: " + ctx.injectionPoint.getTargetInfo()));
        } else if (ctx.injectionPoint.getRequiredType().kind() == Type.Kind.WILDCARD_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for jakarta.enterprise.inject.Instance: " + ctx.injectionPoint.getTargetInfo()));
        } else if (ctx.injectionPoint.getRequiredType().kind() == Type.Kind.TYPE_VARIABLE) {
            ctx.errors.accept((Throwable)new DefinitionException("Type variable is not a legal type argument for jakarta.enterprise.inject.Instance: " + ctx.injectionPoint.getTargetInfo()));
        }
    }

    private static void validateList(ValidatorContext ctx) {
        if (ctx.injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("An injection point of raw type is defined: " + ctx.injectionPoint.getTargetInfo()));
        } else {
            org.jboss.jandex.Type typeParam = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0);
            if (typeParam.kind() == Type.Kind.WILDCARD_TYPE) {
                if (ctx.injectionPoint.isSynthetic()) {
                    ctx.errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for a synthetic @All List<?> injection point used in: " + ctx.injectionTarget.toString()));
                    return;
                }
                ClassInfo declaringClass = ctx.injectionPoint.isField() ? ctx.injectionPoint.getAnnotationTarget().asField().declaringClass() : ctx.injectionPoint.getAnnotationTarget().asMethodParameter().method().declaringClass();
                if (KotlinUtils.isKotlinClass(declaringClass)) {
                    ctx.errors.accept((Throwable)new DefinitionException("kotlin.collections.List cannot be used together with the @All qualifier, please use MutableList or java.util.List instead: " + ctx.injectionPoint.getTargetInfo()));
                } else {
                    ctx.errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for: " + ctx.injectionPoint.getTargetInfo()));
                }
            } else if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
                ctx.errors.accept((Throwable)new DefinitionException("Type variable is not a legal type argument for: " + ctx.injectionPoint.getTargetInfo()));
            }
        }
    }

    private static void validateInjectionPoint(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !BuiltinScope.DEPENDENT.is(ctx.injectionTarget.asBean().getScope())) {
            String msg = ctx.injectionPoint.getTargetInfo();
            if (msg.isBlank()) {
                msg = ctx.injectionTarget.toString();
            }
            ctx.errors.accept((Throwable)new DefinitionException("Only @Dependent beans can access metadata about an injection point: " + msg));
        }
    }

    private static void validateBean(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN) {
            ctx.errors.accept((Throwable)new DefinitionException("Only beans can access bean metadata"));
        }
    }

    private static void validateInterceptedBean(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !ctx.injectionTarget.asBean().isInterceptor()) {
            ctx.errors.accept((Throwable)new DefinitionException("Only interceptors can access intercepted bean metadata"));
        }
    }

    private static void validateDecoratedBean(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !ctx.injectionTarget.asBean().isDecorator()) {
            ctx.errors.accept((Throwable)new DefinitionException("Only decorators can access decorated bean metadata"));
        }
    }

    private static void validateEventMetadata(ValidatorContext ctx) {
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.OBSERVER) {
            ctx.errors.accept((Throwable)new DefinitionException("EventMetadata can be only injected into an observer method: " + ctx.injectionPoint.getTargetInfo()));
        }
    }

    private static void validateInterceptionProxy(ValidatorContext ctx) {
        ClassInfo clazz;
        org.jboss.jandex.Type interceptionProxyType;
        if (ctx.injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !ctx.injectionTarget.asBean().isProducerMethod() && !ctx.injectionTarget.asBean().isSynthetic() || ctx.injectionTarget.asBean().getInterceptionProxy() == null) {
            ctx.errors.accept((Throwable)new DefinitionException("InterceptionProxy can only be injected into a producer method or a synthetic bean"));
        }
        if (ctx.injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("InterceptionProxy must be a parameterized type"));
        }
        if ((interceptionProxyType = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0)).kind() != Type.Kind.CLASS && interceptionProxyType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            ctx.errors.accept((Throwable)new DefinitionException("Type argument of InterceptionProxy may only be a class or parameterized type"));
        }
        if (!ctx.injectionTarget.asBean().getProviderType().equals((Object)interceptionProxyType)) {
            String msg = ctx.injectionTarget.asBean().isProducerMethod() ? "Type argument of InterceptionProxy must be equal to the return type of the producer method" : "Type argument of InterceptionProxy must be equal to the bean provider type";
            ctx.errors.accept((Throwable)new DefinitionException(msg));
        }
        if ((clazz = IndexClassLookupUtils.getClassByName(ctx.beanDeployment.getBeanArchiveIndex(), interceptionProxyType.name())) != null) {
            if (clazz.isRecord()) {
                ctx.errors.accept((Throwable)new DefinitionException("Cannot build InterceptionProxy for a record"));
            }
            if (clazz.isSealed()) {
                ctx.errors.accept((Throwable)new DefinitionException("Cannot build InterceptionProxy for a sealed type"));
            }
        }
    }

    @FunctionalInterface
    static interface Generator {
        public static final Generator NOOP = ctx -> {};

        public void generate(GeneratorContext var1);
    }

    @FunctionalInterface
    static interface Validator {
        public static final Validator NOOP = ctx -> {};

        public void validate(ValidatorContext var1);
    }

    public record GeneratorContext(BeanDeployment beanDeployment, InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, BlockCreator constructor, FieldDesc providerField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate, ParamVar declaringBeanSupplier) {
    }

    public record ValidatorContext(BeanDeployment beanDeployment, InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
    }
}

