/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jooq.runtime;

import io.quarkiverse.jooq.sql.SqlLoggerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.jooq.Configuration;
import org.jooq.ExecuteListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;

public interface JooqCustomContext {
    public static final Logger LOGGER = Logger.getLogger(JooqCustomContext.class);

    default public void apply(Configuration configuration) {
        Settings settings = configuration.settings();
        settings.setRenderCatalog(Boolean.valueOf(false));
        settings.setRenderSchema(Boolean.valueOf(false));
        settings.setExecuteLogging(Boolean.valueOf(SqlLoggerListener.sqlLog.isTraceEnabled()));
        settings.setRenderFormatted(Boolean.valueOf(false));
        settings.setQueryTimeout(Integer.valueOf(60));
        if (settings.isExecuteLogging().booleanValue() && configuration instanceof DefaultConfiguration) {
            DefaultConfiguration defaultConfig = (DefaultConfiguration)configuration;
            if (configuration.executeListenerProviders() != null) {
                ArrayList<ExecuteListenerProvider> providers = new ArrayList<ExecuteListenerProvider>(Arrays.asList(configuration.executeListenerProviders()));
                providers.add(SqlLoggerListener::new);
                defaultConfig.setExecuteListenerProvider(providers.toArray(new ExecuteListenerProvider[0]));
            } else {
                defaultConfig.setExecuteListenerProvider(new ExecuteListenerProvider[]{SqlLoggerListener::new});
            }
            Stream.of(configuration.executeListenerProviders()).forEach(p -> LOGGER.debugv("executeListenerProvider: {0}", p));
        }
    }
}

