/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.OperationExecutor;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.TypeRepository;
import io.leangen.graphql.generator.exceptions.TypeMappingException;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.types.MappedGraphQLFieldDefinition;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.OperationArgumentDefaultValue;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OperationMapper {
    private List<GraphQLFieldDefinition> queries;
    private List<GraphQLFieldDefinition> mutations;

    public OperationMapper(BuildContext buildContext) {
        this.queries = this.generateQueries(buildContext);
        this.mutations = this.generateMutations(buildContext);
    }

    private List<GraphQLFieldDefinition> generateQueries(BuildContext buildContext) {
        ArrayList<Operation> rootQueries = new ArrayList<Operation>(buildContext.operationRepository.getRootQueries());
        List<GraphQLFieldDefinition> queries = rootQueries.stream().map(query -> this.toGraphQLOperation((Operation)query, buildContext)).collect(Collectors.toList());
        buildContext.typeRepository.replaceTypeReferences();
        Map<String, String> nodeQueriesByType = this.getNodeQueriesByType(rootQueries, queries, buildContext.typeRepository, buildContext.node);
        if (!nodeQueriesByType.isEmpty()) {
            queries.add(buildContext.relay.nodeField(buildContext.node, this.createNodeResolver(nodeQueriesByType, buildContext.relay)));
        }
        return queries;
    }

    private List<GraphQLFieldDefinition> generateMutations(BuildContext buildContext) {
        Collection<Operation> mutations = buildContext.operationRepository.getMutations();
        return mutations.stream().map(mutation -> buildContext.relayMappingConfig.relayCompliantMutations ? this.toRelayMutation(this.toGraphQLOperation((Operation)mutation, buildContext), buildContext.relayMappingConfig) : this.toGraphQLOperation((Operation)mutation, buildContext)).collect(Collectors.toList());
    }

    public GraphQLFieldDefinition toGraphQLOperation(Operation operation, BuildContext buildContext) {
        HashSet<Type> abstractTypes = new HashSet<Type>();
        GraphQLOutputType type = this.toGraphQLType(operation.getJavaType(), abstractTypes, buildContext);
        GraphQLFieldDefinition.Builder queryBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription()).type(type);
        List arguments = operation.getArguments().stream().filter(OperationArgument::isMappable).map(argument -> this.toGraphQLArgument((OperationArgument)argument, (Set<Type>)abstractTypes, buildContext)).collect(Collectors.toList());
        queryBuilder.argument(arguments);
        if (type.getName() != null && !type.getName().equals("Connection") && type.getName().endsWith("Connection") && buildContext.relay.getConnectionFieldArguments().stream().anyMatch(connArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(connArg.getName()) && !arg.getType().getName().equals(connArg.getType().getName())))) {
            throw new TypeMappingException("Operation \"" + operation.getName() + "\" has arguments of types incompatible with the Relay Connection spec");
        }
        Object valueMapper = buildContext.valueMapperFactory.getValueMapper(abstractTypes);
        queryBuilder.dataFetcher(this.createResolver(operation, (ValueMapper)valueMapper, buildContext.globalEnvironment));
        return new MappedGraphQLFieldDefinition(queryBuilder.build(), operation);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Type> abstractTypes, BuildContext buildContext) {
        return buildContext.typeMappers.getTypeMapper(javaType).toGraphQLType(javaType, abstractTypes, this, buildContext);
    }

    public GraphQLInputObjectField toGraphQLInputField(InputField inputField, Set<Type> abstractTypes, BuildContext buildContext) {
        GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(inputField.getName()).description(inputField.getDescription()).type(this.toGraphQLInputType(inputField.getJavaType(), abstractTypes, buildContext));
        return builder.build();
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Type> abstractTypes, BuildContext buildContext) {
        TypeMapper mapper = buildContext.typeMappers.getTypeMapper(javaType);
        return mapper.toGraphQLInputType(javaType, abstractTypes, this, buildContext);
    }

    private GraphQLArgument toGraphQLArgument(OperationArgument operationArgument, Set<Type> abstractTypes, BuildContext buildContext) {
        HashSet<Type> argumentAbstractTypes = new HashSet<Type>();
        GraphQLArgument.Builder argument = GraphQLArgument.newArgument().name(operationArgument.getName()).description(operationArgument.getDescription()).type(this.toGraphQLInputType(operationArgument.getJavaType(), argumentAbstractTypes, buildContext));
        abstractTypes.addAll(argumentAbstractTypes);
        OperationArgumentDefaultValue defaultValue = operationArgument.getDefaultValue();
        if (defaultValue.isPresent()) {
            argument.defaultValue(defaultValue.get());
        }
        return argument.build();
    }

    private GraphQLFieldDefinition toRelayMutation(GraphQLFieldDefinition mutation, RelayMappingConfig relayMappingConfig) {
        List<GraphQLFieldDefinition> outputFields;
        if (mutation.getType() instanceof GraphQLObjectType) {
            outputFields = ((GraphQLObjectType)mutation.getType()).getFieldDefinitions();
        } else {
            outputFields = new ArrayList();
            outputFields.add(GraphQLFieldDefinition.newFieldDefinition().name(relayMappingConfig.wrapperFieldName).description(relayMappingConfig.wrapperFieldDescription).type(mutation.getType()).dataFetcher(DataFetchingEnvironment::getSource).build());
        }
        List inputFields = mutation.getArguments().stream().map(arg -> GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType()).defaultValue(arg.getDefaultValue()).build()).collect(Collectors.toList());
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(mutation.getName() + "Input").field(GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(mutation.getName() + "Payload").field(GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(env -> env.getContext() instanceof ContextWrapper ? ((ContextWrapper)env.getContext()).getExtension("clientMutationId") : new PropertyDataFetcher("clientMutationId"))).fields(outputFields).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(mutation.getName()).type((GraphQLOutputType)outputType).argument(GraphQLArgument.newArgument().name("input").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)inputObjectType))).dataFetcher(env -> {
            Map input = (Map)env.getArguments().get("input");
            env.getArguments().clear();
            env.getArguments().putAll(input);
            if (env.getContext() instanceof ContextWrapper) {
                ContextWrapper context = (ContextWrapper)env.getContext();
                context.putExtension("clientMutationId", env.getArgument("clientMutationId"));
            }
            return mutation.getDataFetcher().get(env);
        }).build();
    }

    private DataFetcher createResolver(Operation operation, ValueMapper valueMapper, GlobalEnvironment globalEnvironment) {
        if (operation.isBatched()) {
            return environment -> new OperationExecutor(operation, valueMapper, globalEnvironment).execute(environment);
        }
        return new OperationExecutor(operation, valueMapper, globalEnvironment)::execute;
    }

    private DataFetcher createNodeResolver(Map<String, String> nodeQueriesByType, Relay relay) {
        return env -> {
            String typeName;
            try {
                typeName = relay.fromGlobalId((String)env.getArguments().get("id")).getType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(env.getArguments().get("id") + " is not a valid Relay node ID");
            }
            if (!nodeQueriesByType.containsKey(typeName)) {
                throw new IllegalArgumentException(typeName + " is not a Relay node type or no registered query can fetch it by ID");
            }
            return env.getGraphQLSchema().getQueryType().getFieldDefinition((String)nodeQueriesByType.get(typeName)).getDataFetcher().get(env);
        };
    }

    private Map<String, String> getNodeQueriesByType(List<Operation> queries, List<GraphQLFieldDefinition> graphQlQueries, TypeRepository typeRepository, GraphQLInterfaceType node) {
        HashMap<String, String> nodeQueriesByType = new HashMap<String, String>();
        HashMap<String, String> directNodeQueriesByType = new HashMap<String, String>();
        for (int i = 0; i < queries.size(); ++i) {
            Operation query = queries.get(i);
            GraphQLFieldDefinition graphQlQuery = graphQlQueries.get(i);
            if (graphQlQuery.getArgument("id") == null || !GraphQLUtils.isRelayId(graphQlQuery.getArgument("id")) || query.getResolver("id") == null) continue;
            GraphQLType unwrappedQueryType = GraphQLUtils.unwrapNonNull((GraphQLType)graphQlQuery.getType());
            if (unwrappedQueryType instanceof GraphQLObjectType && ((GraphQLObjectType)unwrappedQueryType).getInterfaces().contains(node)) {
                directNodeQueriesByType.put(unwrappedQueryType.getName(), query.getName());
                continue;
            }
            if (!(unwrappedQueryType instanceof GraphQLInterfaceType) && !(unwrappedQueryType instanceof GraphQLUnionType)) continue;
            typeRepository.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).forEach(nodeType -> nodeQueriesByType.put(nodeType.getName(), query.getName()));
        }
        nodeQueriesByType.putAll(directNodeQueriesByType);
        return nodeQueriesByType;
    }

    public List<GraphQLFieldDefinition> getQueries() {
        return this.queries;
    }

    public List<GraphQLFieldDefinition> getMutations() {
        return this.mutations;
    }
}

