/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.metadata.strategy.query.OperationNameGenerator;
import io.leangen.graphql.metadata.strategy.query.ResolverArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public abstract class FilteredResolverBuilder
implements ResolverBuilder {
    protected OperationNameGenerator operationNameGenerator;
    protected ResolverArgumentBuilder argumentExtractor;
    protected String basePackage;
    protected List<Predicate<Member>> filters = new ArrayList<Predicate<Member>>();

    public FilteredResolverBuilder withOperationNameGenerator(OperationNameGenerator operationNameGenerator) {
        this.operationNameGenerator = operationNameGenerator;
        return this;
    }

    public FilteredResolverBuilder withResolverArgumentBuilder(ResolverArgumentBuilder argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
        return this;
    }

    public FilteredResolverBuilder withBasePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    @SafeVarargs
    public final FilteredResolverBuilder withFilters(Predicate<Member> ... filters) {
        Collections.addAll(this.filters, filters);
        return this;
    }

    protected List<Predicate<Member>> getFilters() {
        return this.filters.isEmpty() ? Collections.singletonList(acceptAll) : this.filters;
    }
}

