/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.Resolver;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Operation {
    private final String name;
    private final String description;
    private final AnnotatedType javaType;
    private final List<Type> contextTypes;
    private final Map<String, Resolver> resolversByFingerprint;
    private final List<OperationArgument> arguments;
    private final boolean batched;

    public Operation(String name, AnnotatedType javaType, List<Type> contextTypes, List<OperationArgument> arguments, List<Resolver> resolvers, boolean batched) {
        if (!resolvers.stream().allMatch(Resolver::isBatched) && !resolvers.stream().noneMatch(Resolver::isBatched)) {
            throw new IllegalArgumentException("Operation \"" + name + "\" mixes regular and batched resolvers");
        }
        this.name = name;
        this.description = resolvers.stream().map(Resolver::getOperationDescription).filter(desc -> !desc.isEmpty()).findFirst().orElse("");
        this.javaType = javaType;
        this.contextTypes = contextTypes;
        this.resolversByFingerprint = this.collectResolversByFingerprint(resolvers);
        this.arguments = arguments;
        this.batched = batched;
    }

    public Operation unbatch() {
        return this.batched ? new UnbatchedOperation(this) : this;
    }

    private Map<String, Resolver> collectResolversByFingerprint(List<Resolver> resolvers) {
        HashMap<String, Resolver> resolversByFingerprint = new HashMap<String, Resolver>();
        resolvers.forEach(resolver -> resolver.getFingerprints().forEach(fingerprint -> resolversByFingerprint.putIfAbsent((String)fingerprint, (Resolver)resolver)));
        return resolversByFingerprint;
    }

    public Resolver getResolver(String ... argumentNames) {
        return this.resolversByFingerprint.get(this.getFingerprint(argumentNames));
    }

    public boolean isEmbeddableForType(Type type) {
        return this.contextTypes.stream().anyMatch(contextType -> GenericTypeReflector.isSuperType((Type)contextType, (Type)type));
    }

    private String getFingerprint(String ... argumentNames) {
        StringBuilder fingerPrint = new StringBuilder();
        Arrays.stream(argumentNames).sorted().forEach(fingerPrint::append);
        return fingerPrint.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AnnotatedType getJavaType() {
        return this.javaType;
    }

    public List<OperationArgument> getArguments() {
        return this.arguments;
    }

    public Collection<Resolver> getResolvers() {
        return this.resolversByFingerprint.values();
    }

    public boolean isBatched() {
        return this.batched;
    }

    public int hashCode() {
        int typeHash = Arrays.stream(this.javaType.getAnnotations()).mapToInt(annotation -> annotation.getClass().getName().hashCode()).reduce((x, y) -> x ^ y).orElse(0);
        return this.name.hashCode() ^ typeHash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Operation)) {
            return false;
        }
        Operation that = (Operation)other;
        if (that.javaType == null && this.javaType != null || that.javaType != null && this.javaType == null) {
            return false;
        }
        return that.name.equals(this.name) && (that.javaType == null || that.javaType.equals(this.javaType));
    }

    public String toString() {
        return this.name + "(" + String.join((CharSequence)",", this.arguments.stream().map(OperationArgument::getName).collect(Collectors.toList())) + ")";
    }

    private static class UnbatchedOperation
    extends Operation {
        private UnbatchedOperation(Operation operation) {
            super(operation.name, UnbatchedOperation.unbatchJavaType(operation.javaType), UnbatchedOperation.unbatchContextTypes(operation.contextTypes), operation.arguments, new ArrayList<Resolver>(operation.getResolvers()), true);
        }

        private static AnnotatedType unbatchJavaType(AnnotatedType javaType) {
            return GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, List.class.getTypeParameters()[0]);
        }

        private static List<Type> unbatchContextTypes(List<Type> contextTypes) {
            return contextTypes.stream().map(contextType -> GenericTypeReflector.getTypeParameter((Type)contextType, List.class.getTypeParameters()[0])).collect(Collectors.toList());
        }

        @Override
        public Operation unbatch() {
            return this;
        }
    }
}

