/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.relay.generic;

import io.leangen.graphql.execution.relay.CursorProvider;
import io.leangen.graphql.execution.relay.Edge;
import io.leangen.graphql.execution.relay.Page;
import io.leangen.graphql.execution.relay.PageInfo;
import io.leangen.graphql.execution.relay.generic.GenericEdge;
import io.leangen.graphql.execution.relay.generic.GenericPage;
import io.leangen.graphql.execution.relay.generic.GenericPageInfo;
import java.util.ArrayList;
import java.util.List;

public class PageFactory {
    public static <N> Page<N> createOffsetBasedPage(List<N> nodes, long count, long offset) {
        return PageFactory.createOffsetBasedPage(nodes, offset, offset + (long)nodes.size() < count, offset > 0L && count > 0L);
    }

    public static <N> Page<N> createOffsetBasedPage(List<N> nodes, long offset, boolean hasNextPage, boolean hasPreviousPage) {
        return PageFactory.createPage(nodes, (node, index) -> Long.toString(offset + (long)index + 1L), hasNextPage, hasPreviousPage);
    }

    public static <N> Page<N> createPage(List<N> nodes, CursorProvider<N> cursorProvider, boolean hasNextPage, boolean hasPreviousPage) {
        List<Edge<N>> edges = PageFactory.createEdges(nodes, cursorProvider);
        return new GenericPage<N>(edges, PageFactory.createPageInfo(edges, hasNextPage, hasPreviousPage));
    }

    public static <N> List<Edge<N>> createEdges(List<N> nodes, CursorProvider<N> cursorProvider) {
        ArrayList<Edge<N>> edges = new ArrayList<Edge<N>>(nodes.size());
        int index = 0;
        for (N node : nodes) {
            edges.add(new GenericEdge<N>(node, cursorProvider.createCursor(node, index++)));
        }
        return edges;
    }

    public static <N> PageInfo<N> createPageInfo(List<Edge<N>> edges, boolean hasNextPage, boolean hasPreviousPage) {
        String firstCursor = null;
        String lastCursor = null;
        if (!edges.isEmpty()) {
            firstCursor = edges.get(0).getCursor();
            lastCursor = edges.get(edges.size() - 1).getCursor();
        }
        return new GenericPageInfo(firstCursor, lastCursor, hasNextPage, hasPreviousPage);
    }
}

