/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.GraphQLSchemaProcessor;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.OperationRepository;
import io.leangen.graphql.generator.OperationSourceRepository;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.exceptions.TypeMappingException;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.generator.mapping.ArgumentInjector;
import io.leangen.graphql.generator.mapping.ArgumentInjectorRepository;
import io.leangen.graphql.generator.mapping.ConverterRepository;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.TypeMapperRepository;
import io.leangen.graphql.generator.mapping.common.ArrayMapper;
import io.leangen.graphql.generator.mapping.common.CollectionToListOutputConverter;
import io.leangen.graphql.generator.mapping.common.ContextInjector;
import io.leangen.graphql.generator.mapping.common.EnumMapper;
import io.leangen.graphql.generator.mapping.common.EnvironmentInjector;
import io.leangen.graphql.generator.mapping.common.IdAdapter;
import io.leangen.graphql.generator.mapping.common.InputValueDeserializer;
import io.leangen.graphql.generator.mapping.common.InterfaceMapper;
import io.leangen.graphql.generator.mapping.common.ListMapper;
import io.leangen.graphql.generator.mapping.common.MapToListTypeAdapter;
import io.leangen.graphql.generator.mapping.common.NonNullMapper;
import io.leangen.graphql.generator.mapping.common.ObjectScalarAdapter;
import io.leangen.graphql.generator.mapping.common.ObjectTypeMapper;
import io.leangen.graphql.generator.mapping.common.OptionalAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalDoubleAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalIntAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalLongAdapter;
import io.leangen.graphql.generator.mapping.common.PageMapper;
import io.leangen.graphql.generator.mapping.common.RootContextInjector;
import io.leangen.graphql.generator.mapping.common.ScalarMapper;
import io.leangen.graphql.generator.mapping.common.StreamToCollectionTypeAdapter;
import io.leangen.graphql.generator.mapping.common.UnionInlineMapper;
import io.leangen.graphql.generator.mapping.common.UnionTypeMapper;
import io.leangen.graphql.generator.mapping.common.VoidToBooleanTypeAdapter;
import io.leangen.graphql.generator.mapping.strategy.AnnotatedInterfaceStrategy;
import io.leangen.graphql.generator.mapping.strategy.DefaultScalarStrategy;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.generator.mapping.strategy.ScalarMappingStrategy;
import io.leangen.graphql.metadata.strategy.query.AnnotatedResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.BeanResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.DefaultOperationBuilder;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.InputFieldDiscoveryStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Defaults;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphQLSchemaGenerator {
    private InterfaceMappingStrategy interfaceStrategy = new AnnotatedInterfaceStrategy();
    private ScalarMappingStrategy scalarStrategy = new DefaultScalarStrategy();
    private OperationBuilder operationBuilder = new DefaultOperationBuilder();
    private ValueMapperFactory valueMapperFactory;
    private InputFieldDiscoveryStrategy inputFieldStrategy;
    private TypeInfoGenerator typeInfoGenerator = new DefaultTypeInfoGenerator();
    private String basePackage;
    private boolean defaultTypeMappers = false;
    private boolean defaultOutputConverters = false;
    private boolean defaultInputConverters = false;
    private boolean defaultArgumentInjectors = false;
    private boolean defaultResolverBuilders = false;
    private boolean defaultNestedResolverBuilders = false;
    private final List<TypeMapper> typeMappers = new ArrayList<TypeMapper>();
    private final List<InputConverter> inputConverters = new ArrayList<InputConverter>();
    private final List<OutputConverter> outputConverters = new ArrayList<OutputConverter>();
    private final List<ArgumentInjector> argumentInjectors = new ArrayList<ArgumentInjector>();
    private final OperationSourceRepository operationSourceRepository = new OperationSourceRepository();
    private final Collection<GraphQLSchemaProcessor> processors = new HashSet<GraphQLSchemaProcessor>();
    private final RelayMappingConfig relayMappingConfig = new RelayMappingConfig();
    private final Set<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
    private static final String QUERY_ROOT = "QUERY_ROOT";
    private static final String MUTATION_ROOT = "MUTATION_ROOT";

    public GraphQLSchemaGenerator() {
    }

    public GraphQLSchemaGenerator(Object ... serviceSingletons) {
        this.withOperationsFromSingletons(serviceSingletons);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton) {
        this.checkType(serviceSingleton.getClass());
        return this.withOperationsFromSingleton(serviceSingleton, serviceSingleton.getClass());
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, Type beanType) {
        return this.withOperationsFromSingleton(serviceSingleton, GenericTypeReflector.annotate((Type)beanType));
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, AnnotatedType beanType) {
        this.checkType(beanType);
        this.operationSourceRepository.registerOperationSource(serviceSingleton, beanType);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, ResolverBuilder ... builders) {
        return this.withOperationsFromSingleton(serviceSingleton, serviceSingleton.getClass(), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, Type beanType, ResolverBuilder ... builders) {
        this.checkType(beanType);
        return this.withOperationsFromSingleton(serviceSingleton, GenericTypeReflector.annotate((Type)beanType), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, AnnotatedType beanType, ResolverBuilder ... builders) {
        this.checkType(beanType);
        this.operationSourceRepository.registerOperationSource(serviceSingleton, beanType, Arrays.asList(builders));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromSingletons(Object ... serviceSingletons) {
        Arrays.stream(serviceSingletons).forEach(this::withOperationsFromSingleton);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(Type serviceType) {
        return this.withOperationsFromType(GenericTypeReflector.annotate((Type)serviceType));
    }

    public GraphQLSchemaGenerator withOperationsFromType(Type serviceType, ResolverBuilder ... builders) {
        return this.withOperationsFromType(GenericTypeReflector.annotate((Type)serviceType), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromTypes(Type ... serviceType) {
        Arrays.stream(serviceType).forEach(this::withOperationsFromType);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(AnnotatedType serviceType) {
        this.checkType(serviceType);
        this.operationSourceRepository.registerOperationSource(serviceType);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(AnnotatedType serviceType, ResolverBuilder ... builders) {
        this.checkType(serviceType);
        this.operationSourceRepository.registerOperationSource(serviceType, Arrays.asList(builders));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromTypes(AnnotatedType ... serviceType) {
        Arrays.stream(serviceType).forEach(this::withOperationsFromType);
        return this;
    }

    public GraphQLSchemaGenerator withNestedOperationsFromTypes(Type ... types) {
        Arrays.stream(types).forEach(x$0 -> this.withNestedResolverBuildersForType((Type)x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withNestedOperationsFromTypes(AnnotatedType ... types) {
        Arrays.stream(types).forEach(x$0 -> this.withNestedResolverBuildersForType((AnnotatedType)x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withNestedResolverBuildersForType(Type querySourceType, ResolverBuilder ... resolverBuilders) {
        return this.withNestedResolverBuildersForType(GenericTypeReflector.annotate((Type)querySourceType), resolverBuilders);
    }

    public GraphQLSchemaGenerator withNestedResolverBuildersForType(AnnotatedType querySourceType, ResolverBuilder ... resolverBuilders) {
        this.operationSourceRepository.registerNestedOperationSource(querySourceType, Arrays.asList(resolverBuilders));
        return this;
    }

    public GraphQLSchemaGenerator withResolverBuilders(ResolverBuilder ... resolverBuilders) {
        this.operationSourceRepository.registerGlobalResolverBuilders(resolverBuilders);
        return this;
    }

    public GraphQLSchemaGenerator withNestedResolverBuilders(ResolverBuilder ... resolverBuilders) {
        this.operationSourceRepository.registerGlobalNestedResolverBuilders(resolverBuilders);
        return this;
    }

    public GraphQLSchemaGenerator withInterfaceMappingStrategy(InterfaceMappingStrategy interfaceStrategy) {
        this.interfaceStrategy = interfaceStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withScalarMappingStrategy(ScalarMappingStrategy scalarStrategy) {
        this.scalarStrategy = scalarStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withBasePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public GraphQLSchemaGenerator withTypeMappers(TypeMapper ... typeMappers) {
        Collections.addAll(this.typeMappers, typeMappers);
        return this;
    }

    public GraphQLSchemaGenerator withInputConverters(InputConverter<?, ?> ... inputConverters) {
        Collections.addAll(this.inputConverters, inputConverters);
        return this;
    }

    public GraphQLSchemaGenerator withOutputConverters(OutputConverter<?, ?> ... outputConverters) {
        Collections.addAll(this.outputConverters, outputConverters);
        return this;
    }

    public GraphQLSchemaGenerator withTypeAdapters(AbstractTypeAdapter<?, ?> ... typeAdapters) {
        this.withInputConverters((InputConverter[])typeAdapters);
        this.withOutputConverters((OutputConverter[])typeAdapters);
        return this.withTypeMappers(typeAdapters);
    }

    public GraphQLSchemaGenerator withArgumentInjectors(ArgumentInjector ... argumentInjectors) {
        Collections.addAll(this.argumentInjectors, argumentInjectors);
        return this;
    }

    public GraphQLSchemaGenerator withMetaDataGenerator(TypeInfoGenerator typeInfoGenerator) {
        this.typeInfoGenerator = typeInfoGenerator;
        return this;
    }

    public GraphQLSchemaGenerator withValueMapperFactory(ValueMapperFactory valueMapperFactory) {
        this.valueMapperFactory = valueMapperFactory;
        return this;
    }

    public GraphQLSchemaGenerator withInputFieldDiscoveryStrategy(InputFieldDiscoveryStrategy inputFieldStrategy) {
        this.inputFieldStrategy = inputFieldStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withAdditionalTypes(Collection<GraphQLType> additionalTypes) {
        additionalTypes.stream().filter(type -> !this.isInternalType((GraphQLType)type)).forEach(this.additionalTypes::add);
        return this;
    }

    public GraphQLSchemaGenerator withRelayCompliantMutations() {
        return this.withRelayCompliantMutations("result", "Mutation result");
    }

    public GraphQLSchemaGenerator withRelayCompliantMutations(String wrapperFieldName, String wrapperFieldDescription) {
        this.relayMappingConfig.relayCompliantMutations = true;
        this.relayMappingConfig.wrapperFieldName = wrapperFieldName;
        this.relayMappingConfig.wrapperFieldDescription = wrapperFieldDescription;
        return this;
    }

    public GraphQLSchemaGenerator withSchemaProcessors(GraphQLSchemaProcessor ... processors) {
        Collections.addAll(this.processors, processors);
        return this;
    }

    public GraphQLSchemaGenerator withDefaults() {
        return this.withDefaultResolverBuilders().withDefaultNestedResolverBuilders().withDefaultMappers().withDefaultConverters().withDefaultArgumentInjectors();
    }

    public GraphQLSchemaGenerator withDefaultMappers() {
        this.defaultTypeMappers = true;
        return this;
    }

    public GraphQLSchemaGenerator withDefaultInputConverters() {
        this.defaultInputConverters = true;
        return this;
    }

    public GraphQLSchemaGenerator withDefaultOutputConverters() {
        this.defaultOutputConverters = true;
        return this;
    }

    public GraphQLSchemaGenerator withDefaultConverters() {
        return this.withDefaultInputConverters().withDefaultOutputConverters();
    }

    public GraphQLSchemaGenerator withDefaultArgumentInjectors() {
        this.defaultArgumentInjectors = true;
        return this;
    }

    public GraphQLSchemaGenerator withDefaultResolverBuilders() {
        this.defaultResolverBuilders = true;
        return this;
    }

    public GraphQLSchemaGenerator withDefaultNestedResolverBuilders() {
        this.defaultNestedResolverBuilders = true;
        return this;
    }

    private void init() {
        if (this.operationSourceRepository.isEmpty()) {
            throw new IllegalStateException("At least one top-level query source must be registered");
        }
        if (!this.operationSourceRepository.hasGlobalResolverBuilders() || this.defaultResolverBuilders) {
            this.withResolverBuilders(new AnnotatedResolverBuilder());
        }
        if (!this.operationSourceRepository.hasGlobalNestedResolverBuilders() || this.defaultNestedResolverBuilders) {
            this.withNestedResolverBuilders(new AnnotatedResolverBuilder(), new BeanResolverBuilder(this.basePackage));
        }
        if (this.typeMappers.isEmpty() || this.defaultTypeMappers) {
            ObjectTypeMapper objectTypeMapper = new ObjectTypeMapper();
            this.withTypeMappers(new NonNullMapper(), new IdAdapter(), new ScalarMapper(), new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new ObjectScalarAdapter(this.scalarStrategy), new EnumMapper(), new ArrayMapper(), new UnionTypeMapper(), new UnionInlineMapper(), new StreamToCollectionTypeAdapter(), new MapToListTypeAdapter(this.scalarStrategy), new VoidToBooleanTypeAdapter(), new ListMapper(), new PageMapper(), new OptionalAdapter(), new InterfaceMapper(this.interfaceStrategy, objectTypeMapper), objectTypeMapper);
        }
        if (this.outputConverters.isEmpty() || this.defaultOutputConverters) {
            this.withOutputConverters(new IdAdapter(), new ObjectScalarAdapter(this.scalarStrategy), new MapToListTypeAdapter(this.scalarStrategy), new VoidToBooleanTypeAdapter(), new CollectionToListOutputConverter(), new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new OptionalAdapter(), new StreamToCollectionTypeAdapter());
        }
        if (this.inputConverters.isEmpty() || this.defaultInputConverters) {
            this.withInputConverters(new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new MapToListTypeAdapter(this.scalarStrategy), new OptionalAdapter(), new StreamToCollectionTypeAdapter());
        }
        if (this.argumentInjectors.isEmpty() || this.defaultArgumentInjectors) {
            this.withArgumentInjectors(new IdAdapter(), new RootContextInjector(), new ContextInjector(), new EnvironmentInjector(), new InputValueDeserializer());
        }
        if (this.valueMapperFactory == null) {
            this.valueMapperFactory = Defaults.valueMapperFactory(this.basePackage, this.typeInfoGenerator);
        }
        if (this.inputFieldStrategy == null) {
            Object def = this.valueMapperFactory.getValueMapper();
            this.inputFieldStrategy = def instanceof InputFieldDiscoveryStrategy ? (InputFieldDiscoveryStrategy)def : (InputFieldDiscoveryStrategy)Defaults.valueMapperFactory(this.basePackage, this.typeInfoGenerator).getValueMapper();
        }
    }

    public GraphQLSchema generate() {
        this.init();
        BuildContext buildContext = new BuildContext(new OperationRepository(this.operationSourceRepository, this.operationBuilder), new TypeMapperRepository(this.typeMappers), new ConverterRepository(this.inputConverters, this.outputConverters), new ArgumentInjectorRepository(this.argumentInjectors), this.interfaceStrategy, this.basePackage, this.typeInfoGenerator, this.valueMapperFactory, this.inputFieldStrategy, this.additionalTypes, this.relayMappingConfig);
        OperationMapper operationMapper = new OperationMapper(buildContext);
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema().query(GraphQLObjectType.newObject().name(QUERY_ROOT).description("Query root type").fields(operationMapper.getQueries()).build());
        List<GraphQLFieldDefinition> mutations = operationMapper.getMutations();
        if (!mutations.isEmpty()) {
            builder.mutation(GraphQLObjectType.newObject().name(MUTATION_ROOT).description("Mutation root type").fields(mutations).build());
        }
        this.applyProcessors(builder);
        this.additionalTypes.addAll(buildContext.typeRepository.getDiscoveredTypes());
        return builder.build(this.additionalTypes);
    }

    private void applyProcessors(GraphQLSchema.Builder builder) {
        for (GraphQLSchemaProcessor processor : this.processors) {
            processor.process(builder);
        }
    }

    private boolean isInternalType(GraphQLType type) {
        return type.getName().startsWith("__") || type.getName().equals(QUERY_ROOT) || type.getName().equals(MUTATION_ROOT);
    }

    private void checkType(Type type) {
        if (type == null) {
            throw new TypeMappingException();
        }
        Class<?> clazz = ClassUtils.getRawType(type);
        if (ClassUtils.isProxy(clazz)) {
            throw new TypeMappingException("The provided object of type " + clazz.getName() + " appears to be a dynamically generated proxy, so its type can not be reliably determined." + " Provide the type explicitly when registering the bean.");
        }
    }

    private void checkType(AnnotatedType type) {
        if (type == null) {
            throw new TypeMappingException();
        }
        this.checkType(type.getType());
    }
}

