/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.repository;

import io.hypersistence.utils.spring.repository.HibernateRepository;
import io.hypersistence.utils.spring.repository.StatelessSessionUtil;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;

public class HibernateRepositoryImpl<T>
implements HibernateRepository<T> {
    private final EntityManager entityManager;

    public HibernateRepositoryImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<T> findAll() {
        throw new UnsupportedOperationException("Fetching all records from a given database table is a terrible idea!");
    }

    @Override
    public <S extends T> S save(S entity) {
        return this.unsupportedSave();
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return (List)this.unsupportedSave();
    }

    @Override
    public <S extends T> S saveAndFlush(S entity) {
        return this.unsupportedSave();
    }

    @Override
    public <S extends T> List<S> saveAllAndFlush(Iterable<S> entities) {
        return (List)this.unsupportedSave();
    }

    @Override
    public <S extends T> S persist(S entity) {
        this.entityManager.persist(entity);
        return entity;
    }

    @Override
    public <S extends T> S persistAndFlush(S entity) {
        this.persist(entity);
        this.entityManager.flush();
        return entity;
    }

    @Override
    public <S extends T> List<S> persistAll(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.persist(entity));
        }
        return result;
    }

    @Override
    public <S extends T> List<S> persistAllAndFlush(Iterable<S> entities) {
        return this.executeBatch(() -> {
            ArrayList result = new ArrayList();
            for (Object entity : entities) {
                result.add(this.persist(entity));
            }
            this.entityManager.flush();
            return result;
        });
    }

    @Override
    public <S extends T> S merge(S entity) {
        return (S)this.entityManager.merge(entity);
    }

    @Override
    public <S extends T> S mergeAndFlush(S entity) {
        S result = this.merge(entity);
        this.entityManager.flush();
        return result;
    }

    @Override
    public <S extends T> List<S> mergeAll(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.merge(entity));
        }
        return result;
    }

    @Override
    public <S extends T> List<S> mergeAllAndFlush(Iterable<S> entities) {
        return this.executeBatch(() -> {
            ArrayList result = new ArrayList();
            for (Object entity : entities) {
                result.add(this.merge(entity));
            }
            this.entityManager.flush();
            return result;
        });
    }

    @Override
    public <S extends T> S update(S entity) {
        this.statelessSession().update(entity);
        return entity;
    }

    @Override
    public <S extends T> S updateAndFlush(S entity) {
        this.update(entity);
        this.entityManager.flush();
        return entity;
    }

    @Override
    public <S extends T> List<S> updateAll(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.update(entity));
        }
        return result;
    }

    @Override
    public <S extends T> List<S> updateAllAndFlush(Iterable<S> entities) {
        return this.executeBatch(() -> {
            ArrayList result = new ArrayList();
            for (Object entity : entities) {
                result.add(this.update(entity));
            }
            this.entityManager.flush();
            return result;
        });
    }

    protected Integer getBatchSize(Session session) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)session.getSessionFactory().unwrap(SessionFactoryImplementor.class);
        JdbcServices jdbcServices = (JdbcServices)sessionFactory.getServiceRegistry().getService(JdbcServices.class);
        if (!jdbcServices.getExtractedMetaDataSupport().supportsBatchUpdates()) {
            return Integer.MIN_VALUE;
        }
        return ((AbstractSharedSessionContract)session.unwrap(AbstractSharedSessionContract.class)).getConfiguredJdbcBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeBatch(Supplier<R> callback) {
        Session session = this.session();
        Integer jdbcBatchSize = this.getBatchSize(session);
        Integer originalSessionBatchSize = session.getJdbcBatchSize();
        try {
            if (jdbcBatchSize == null) {
                session.setJdbcBatchSize(Integer.valueOf(10));
            }
            R r = callback.get();
            return r;
        }
        finally {
            session.setJdbcBatchSize(originalSessionBatchSize);
        }
    }

    protected Session session() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    protected <S extends T> S unsupportedSave() {
        throw new UnsupportedOperationException("There's no such thing as a save method in JPA, so don't use this hack!");
    }

    private StatelessSession statelessSession() {
        return StatelessSessionUtil.statelessSession(this.entityManager);
    }
}

