/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type;

import io.hypersistence.utils.common.ReflectionUtils;
import io.hypersistence.utils.common.StringUtils;
import io.hypersistence.utils.hibernate.type.basic.Iso8601MonthType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLHStoreType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLInetType;
import io.hypersistence.utils.hibernate.type.interval.OracleIntervalDayToSecondType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLPeriodType;
import io.hypersistence.utils.hibernate.type.json.JsonNodeStringType;
import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import java.util.function.Predicate;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public static final String ENABLE_TYPES_CONTRIBUTOR = "hypersistence.utils.enable_types_contributor";
    public static final String TYPES_CONTRIBUTOR_FILTER = "hypersistence.utils.types_contributor_filter";

    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        boolean enableJson;
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Boolean enableTypesContributor = (Boolean)configurationService.getSetting(ENABLE_TYPES_CONTRIBUTOR, value -> {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                if (StringUtils.TRUE.equalsIgnoreCase((String)value)) {
                    return Boolean.TRUE;
                }
                if (StringUtils.FALSE.equalsIgnoreCase((String)value)) {
                    return Boolean.FALSE;
                }
            }
            throw new HibernateException(String.format("The value [%s] of the [%s] setting is not supported!", value, ENABLE_TYPES_CONTRIBUTOR));
        });
        if (Boolean.FALSE.equals(enableTypesContributor)) {
            return;
        }
        Predicate<UserType> typeFilter = (Predicate<UserType>)configurationService.getSetting(TYPES_CONTRIBUTOR_FILTER, value -> {
            if (value instanceof Predicate) {
                return value;
            }
            if (value instanceof Class) {
                return ReflectionUtils.newInstance((Class)value);
            }
            if (value instanceof String) {
                return ReflectionUtils.newInstance(ReflectionUtils.getClass((String)value));
            }
            throw new HibernateException(String.format("The value of the [%s] setting is not supported!", TYPES_CONTRIBUTOR_FILTER));
        });
        if (typeFilter == null) {
            typeFilter = o -> true;
        }
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Dialect dialect = jdbcServices.getDialect();
        boolean bl = enableJson = ReflectionUtils.getClassOrNull("com.fasterxml.jackson.databind.ObjectMapper") != null;
        if (dialect instanceof PostgreSQLDialect) {
            this.contributeType(typeContributions, PostgreSQLPeriodType.INSTANCE, typeFilter);
            this.contributeType(typeContributions, PostgreSQLHStoreType.INSTANCE, typeFilter);
            this.contributeType(typeContributions, PostgreSQLInetType.INSTANCE, typeFilter);
            this.contributeType(typeContributions, PostgreSQLRangeType.INSTANCE, typeFilter);
            if (ReflectionUtils.getClassOrNull("com.google.common.collect.Range") != null) {
                this.contributeType(typeContributions, PostgreSQLGuavaRangeType.INSTANCE, typeFilter);
            }
        } else if (dialect instanceof MySQLDialect) {
            if (enableJson) {
                this.contributeType(typeContributions, JsonNodeStringType.INSTANCE, typeFilter);
            }
        } else if (dialect instanceof OracleDialect) {
            this.contributeType(typeContributions, OracleIntervalDayToSecondType.INSTANCE, typeFilter);
        }
        this.contributeType(typeContributions, Iso8601MonthType.INSTANCE, typeFilter);
    }

    private HibernateTypesContributor contributeType(TypeContributions typeContributions, UserType type, Predicate<UserType> typeFilter) {
        if (typeFilter.test(type)) {
            typeContributions.contributeType(type);
        }
        return this;
    }
}

