/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import fr.reseaumexico.model.writer.XmlNode;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;

public abstract class XmlWriter<M> {
    public static final int INDENT = 2;
    protected M model;

    protected abstract XmlNode getRootElement();

    protected XmlWriter(M model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            XmlNode rootElement = this.getRootElement();
            String toWrite = rootElement.toXml(2);
            writer.write(toWrite);
            ((Writer)writer).close();
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }
}

