/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.google.common.collect.Lists;
import fr.reseaumexico.model.ExperimentDesign;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.InputDesignImpl;
import fr.reseaumexico.model.MexicoXmlConstant;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.parser.ExperimentDesignParser;
import fr.reseaumexico.model.parser.MexicoXmlParser;
import fr.reseaumexico.model.parser.ScenarioXmlParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InputDesignParser
extends MexicoXmlParser<InputDesign> {
    protected ExperimentDesignParser experimentDesignParser = new ExperimentDesignParser();

    @Override
    protected InputDesign parseModel(XmlPullParser parser) throws IOException, XmlPullParserException, ParseException {
        InputDesignImpl model = new InputDesignImpl();
        this.parseInputDesignMeta(parser, model);
        ExperimentDesign experimentDesign = this.experimentDesignParser.parseModel(parser);
        model.setExperimentDesign(experimentDesign);
        this.parseScenarios(parser, model);
        return model;
    }

    protected void parseInputDesignMeta(XmlPullParser parser, InputDesign model) throws IOException, XmlPullParserException, ParseException {
        this.checkStartFile(parser, MexicoXmlConstant.INPUT_DESIGN, "Input design file must start with " + MexicoXmlConstant.INPUT_DESIGN + " tag");
        String dateAsString = parser.getAttributeValue(null, "date");
        model.setDate(this.parseDate(dateAsString));
    }

    protected void parseScenarios(XmlPullParser parser, InputDesign model) throws IOException, XmlPullParserException, ParseException {
        if (this.testNextStartTag(parser, MexicoXmlConstant.SCENARIO)) {
            ScenarioXmlParser scenarioXmlParser = new ScenarioXmlParser(this.experimentDesignParser.getFactorCache(), false);
            ArrayList scenarios = Lists.newArrayList();
            while (!this.testCurrentEndTag(parser, MexicoXmlConstant.INPUT_DESIGN)) {
                Scenario scenario = scenarioXmlParser.parseModel(parser);
                scenarios.add(scenario);
            }
            model.setScenario(scenarios);
        }
    }
}

