package fr.reseaumexico.model;

import java.util.Collection;

public abstract class OuputData extends AbstractMexicoBean {

    private static final long serialVersionUID = 7377290030436596066L;

    public static final String PROPERTY_STEP = "step";

    public static final String PROPERTY_INPUT_DESIGN = "inputDesign";

    public static final String PROPERTY_SCENARIO = "scenario";

    protected Collection<Step> step;

    protected InputDesign inputDesign;

    protected Collection<Scenario> scenario;

    public Step getStep(int index) {
        Step o = getChild(step, index);
        return o;
    }

    public boolean isStepEmpty() {
        return step == null || step.isEmpty();
    }

    public int sizeStep() {
        return step == null ? 0 : step.size();
    }

    public void addStep(Step step) {
        getStep().add(step);
        firePropertyChange(PROPERTY_STEP, null, step);
    }

    public void addAllStep(Collection<Step> step) {
        getStep().addAll(step);
        firePropertyChange(PROPERTY_STEP, null, step);
    }

    public boolean removeStep(Step step) {
        boolean removed = getStep().remove(step);
        if (removed) {
            firePropertyChange(PROPERTY_STEP, step, null);
        }
        return removed;
    }

    public boolean removeAllStep(Collection<Step> step) {
        boolean  removed = getStep().removeAll(step);
        if (removed) {
            firePropertyChange(PROPERTY_STEP, step, null);
        }
        return removed;
    }

    public boolean containsStep(Step step) {
        boolean contains = getStep().contains(step);
        return contains;
    }

    public boolean containsAllStep(Collection<Step> step) {
        boolean  contains = getStep().containsAll(step);
        return contains;
    }

    public Collection<Step> getStep() {
        return step;
    }

    public void setStep(Collection<Step> step) {
        Collection<Step> oldValue = getStep();
        this.step = step;
        firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public InputDesign getInputDesign() {
        return inputDesign;
    }

    public void setInputDesign(InputDesign inputDesign) {
        InputDesign oldValue = getInputDesign();
        this.inputDesign = inputDesign;
        firePropertyChange(PROPERTY_INPUT_DESIGN, oldValue, inputDesign);
    }

    public Scenario getScenario(int index) {
        Scenario o = getChild(scenario, index);
        return o;
    }

    public boolean isScenarioEmpty() {
        return scenario == null || scenario.isEmpty();
    }

    public int sizeScenario() {
        return scenario == null ? 0 : scenario.size();
    }

    public void addScenario(Scenario scenario) {
        getScenario().add(scenario);
        firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public void addAllScenario(Collection<Scenario> scenario) {
        getScenario().addAll(scenario);
        firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public boolean removeScenario(Scenario scenario) {
        boolean removed = getScenario().remove(scenario);
        if (removed) {
            firePropertyChange(PROPERTY_SCENARIO, scenario, null);
        }
        return removed;
    }

    public boolean removeAllScenario(Collection<Scenario> scenario) {
        boolean  removed = getScenario().removeAll(scenario);
        if (removed) {
            firePropertyChange(PROPERTY_SCENARIO, scenario, null);
        }
        return removed;
    }

    public boolean containsScenario(Scenario scenario) {
        boolean contains = getScenario().contains(scenario);
        return contains;
    }

    public boolean containsAllScenario(Collection<Scenario> scenario) {
        boolean  contains = getScenario().containsAll(scenario);
        return contains;
    }

    public Collection<Scenario> getScenario() {
        return scenario;
    }

    public void setScenario(Collection<Scenario> scenario) {
        Collection<Scenario> oldValue = getScenario();
        this.scenario = scenario;
        firePropertyChange(PROPERTY_SCENARIO, oldValue, scenario);
    }

} //OuputData
