/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level1;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.ird.t3.actions.data.level1.Level1Configuration;
import fr.ird.t3.actions.data.level1.Level1Step;
import fr.ird.t3.entities.data.N1ResultState;
import fr.ird.t3.entities.data.Sample;
import fr.ird.t3.entities.data.SampleDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.SampleQuality;
import fr.ird.t3.entities.reference.SampleType;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;

public class AbstractLevel1ConfigureAction
extends AbstractConfigureAction<Level1Configuration> {
    private static final Log log = LogFactory.getLog(AbstractLevel1ConfigureAction.class);
    private static final long serialVersionUID = 1L;
    protected final Level1Step[] requiredSteps;
    protected final Level1Step currentStep;
    @InjectDAO(entityType=Sample.class)
    protected transient SampleDAO sampleDAO;
    @InjectDecoratedBeans(beanType=SampleQuality.class, filterById=true, pathIds="sampleQualityIds")
    protected Map<String, String> sampleQualities;
    @InjectDecoratedBeans(beanType=SampleType.class, filterById=true)
    protected Map<String, String> sampleTypes;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> fleets;
    @InjectDecoratedBeans(beanType=Ocean.class)
    protected Map<String, String> oceans;
    protected Map<String, String> useRfMinus10AndRfPlus10OrNot;

    public AbstractLevel1ConfigureAction(Level1Step currentStep) {
        super(Level1Configuration.class);
        this.currentStep = currentStep;
        EnumSet<Level1Step> steps = EnumSet.allOf(Level1Step.class);
        Iterator itr = steps.iterator();
        while (itr.hasNext()) {
            Level1Step step = (Level1Step)itr.next();
            if (step.ordinal() < currentStep.ordinal()) continue;
            itr.remove();
        }
        this.requiredSteps = steps.toArray(new Level1Step[steps.size()]);
    }

    public void prepare() throws Exception {
        this.useRfMinus10AndRfPlus10OrNot = this.createUseRfMinus10AndRfPlus10OrNot();
        Level1Configuration configuration = (Level1Configuration)this.getConfiguration();
        this.injectOnly(new Class[]{InjectDecoratedBeans.class, InjectDAO.class});
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fleet countries  : " + configuration.getFleetIds()));
            log.info((Object)("Selected sample qualities : " + configuration.getSampleQualityIds()));
            log.info((Object)("Selected sample types     : " + configuration.getSampleTypeIds()));
            log.info((Object)("Selected ocean            : " + configuration.getOceanId()));
            log.info((Object)("Selected begin date       : " + configuration.getBeginDate()));
            log.info((Object)("Selected end   date       : " + configuration.getEndDate()));
            log.info((Object)("Executed steps            : " + configuration.getExecutedSteps()));
        }
    }

    public String input() throws Exception {
        return "input";
    }

    public String execute() throws Exception {
        this.prepareActionContext();
        return "success";
    }

    public void validate() {
        if (this.isRequiredStepsExecutedOnConfiguration()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Current configuration already treats all required step " + Arrays.toString(this.requiredSteps)));
            }
        } else {
            Multimap missingSteps = this.getMissingRequiredStepsExecutedOnSample();
            if (missingSteps.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("All required steps " + Arrays.toString(this.requiredSteps) + "were already executed on selected samples " + "of current configuration."));
                }
            } else {
                for (Level1Step step : missingSteps.keySet()) {
                    this.addActionError(this._("t3.error.level1.missing.step", new Object[]{this._(step.getI18nKey(), new Object[0]), missingSteps.get((Object)step).size()}));
                }
            }
        }
    }

    public Map<String, String> getSampleQualities() {
        return this.sampleQualities;
    }

    public Map<String, String> getSampleTypes() {
        return this.sampleTypes;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public int getMatchingTripCount() {
        Map tripIds = this.getTripIds().asMap();
        return MapUtils.isEmpty((Map)tripIds) ? 0 : tripIds.size();
    }

    public int getMatchingSampleCount() {
        Map tripIds = this.getTripIds().asMap();
        if (MapUtils.isEmpty((Map)tripIds)) {
            return 0;
        }
        int nbSamples = 0;
        for (Collection sampleIds : tripIds.values()) {
            nbSamples += sampleIds.size();
        }
        return nbSamples;
    }

    public int getNotMatchingSampleCount() {
        return ((Level1Configuration)this.getConfiguration()).getNotTreatedSampleReason().size();
    }

    public Multimap<String, String> getTripIds() {
        Multimap ids = ((Level1Configuration)this.getConfiguration()).getSampleIdsByTripId();
        return ids;
    }

    protected boolean isRequiredStepsExecutedOnConfiguration() {
        Set executedSteps = ((Level1Configuration)this.getConfiguration()).getExecutedSteps();
        for (Level1Step requiredStep : this.requiredSteps) {
            if (executedSteps.contains(requiredStep)) continue;
            if (log.isWarnEnabled()) {
                log.warn((Object)("A required step [" + requiredStep + "] was still not executed with this configuration "));
            }
            return false;
        }
        return true;
    }

    protected Multimap<Level1Step, Sample> getMissingRequiredStepsExecutedOnSample() {
        Collection sampleIds = this.getTripIds().values();
        try {
            HashMultimap missingStates = HashMultimap.create();
            for (String sampleId : sampleIds) {
                Sample sample = (Sample)this.sampleDAO.findByTopiaId(sampleId);
                for (Level1Step requiredStep : this.requiredSteps) {
                    boolean sampleState = requiredStep.getState((N1ResultState)sample);
                    if (sampleState) continue;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Required step " + requiredStep + " is missing for sample " + sampleId));
                    }
                    missingStates.put((Object)requiredStep, (Object)sample);
                }
            }
            return missingStates;
        }
        catch (TopiaException e) {
            throw new TopiaRuntimeException("Can not obtain samples", (Throwable)e);
        }
    }

    public Map<String, String> getUseRfMinus10AndRfPlus10OrNot() {
        return this.useRfMinus10AndRfPlus10OrNot;
    }
}

