/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level0;

import fr.ird.t3.actions.data.level0.AbstractLevel0Configuration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.entities.reference.VesselDAO;
import fr.ird.t3.entities.reference.VesselSimpleType;
import fr.ird.t3.entities.reference.VesselSimpleTypeDAO;
import fr.ird.t3.entities.type.T3Date;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public abstract class AbstractLevel0ConfigureAction<C extends AbstractLevel0Configuration>
extends AbstractConfigureAction<C> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractLevel0ConfigureAction.class);
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    @InjectDAO(entityType=Vessel.class)
    protected transient VesselDAO vesselDAO;
    @InjectDAO(entityType=Country.class)
    protected transient CountryDAO countryDAO;
    @InjectDAO(entityType=VesselSimpleType.class)
    protected transient VesselSimpleTypeDAO vesselSimpleTypeDAO;
    @InjectDecoratedBeans(beanType=VesselSimpleType.class)
    protected Map<String, String> vesselSimpleTypes;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> fleets;

    protected AbstractLevel0ConfigureAction(Class<C> configurationType) {
        super(configurationType);
    }

    public final void prepare() throws Exception {
        this.setConfirm(false);
        this.removeActionContextFromSession();
        AbstractLevel0Configuration config = (AbstractLevel0Configuration)this.getConfiguration();
        this.injectExcept(new Class[]{InjectDecoratedBeans.class});
        if (!this.isConfigurationInSession()) {
            this.loadDefaultConfiguration(config);
        }
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
    }

    public final String prepareConfiguration() throws Exception {
        if (!this.isConfigurationInSession() && !this.hasFieldErrors()) {
            this.storeActionConfiguration(this.configuration);
        }
        return "input";
    }

    public final String execute() throws Exception {
        this.prepareActionContext();
        this.setConfirm(true);
        return "success";
    }

    public Map<String, String> getVesselSimpleTypes() {
        return this.vesselSimpleTypes;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    protected void loadDefaultConfiguration(C config) throws TopiaException {
        T3Date minDate = this.tripDAO.getFirstLandingDate();
        config.setMinDate(minDate);
        config.setBeginDate(minDate);
        T3Date maxDate = this.tripDAO.getLastLandingDate();
        config.setMaxDate(maxDate);
        config.setEndDate(maxDate);
        config.setVesselSimpleTypes(this.sortToList((Collection)this.vesselSimpleTypeDAO.findAllUsedInTrip()));
        config.setFleets(this.sortToList((Collection)this.countryDAO.findAllFleetUsedInTrip()));
        if (log.isInfoEnabled()) {
            log.info((Object)("beginDate : " + config.getBeginDate()));
            log.info((Object)("endDate : " + config.getEndDate()));
        }
    }

    public final String input() throws Exception {
        throw new NoSuchMethodException("DO NOT COME HERE!!!");
    }
}

