/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Maps;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.web.actions.T3ActionSupport;
import fr.ird.t3.web.actions.admin.TripListModel;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TripListAction
extends T3ActionSupport {
    protected static final Log log = LogFactory.getLog(TripListAction.class);
    private static final long serialVersionUID = 1L;
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    @InjectFromDAO(entityType=Trip.class, method="findAllYearsUsedInTrip")
    protected Collection<Integer> allYears;
    @InjectFromDAO(entityType=Country.class, method="findAllFleetUsedInTrip")
    protected Collection<Country> allFleets;
    @InjectFromDAO(entityType=Country.class, method="findAllFlagUsedInTrip")
    protected Collection<Country> allFlags;
    @InjectFromDAO(entityType=Vessel.class, method="findAllUsedInTrip")
    protected Collection<Vessel> allVessels;
    protected Map<String, String> years;
    protected Map<String, String> oceans;
    protected Map<String, String> fleets;
    protected Map<String, String> flags;
    protected Map<String, String> vessels;
    protected TripListModel tripListModel;
    protected boolean back;

    public Map<String, String> getYears() {
        return this.years;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public Map<String, String> getVessels() {
        return this.vessels;
    }

    public TripListModel getTripListModel() {
        if (this.tripListModel == null) {
            this.tripListModel = this.getT3Session().getTripListModel();
            if (this.tripListModel == null) {
                this.tripListModel = new TripListModel();
            }
        }
        return this.tripListModel;
    }

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class, InjectFromDAO.class});
        this.tripListModel = this.getT3Session().getTripListModel() == null ? this.loadTripListModel(this.tripDAO) : this.getT3Session().getTripListModel();
        this.years = Maps.newLinkedHashMap();
        for (Integer year : this.allYears) {
            this.years.put(year + "", year + "");
        }
        this.oceans = this.sortAndDecorate((Collection)this.tripListModel.getOceans());
        this.fleets = this.sortAndDecorate(this.allFleets);
        this.flags = this.sortAndDecorate(this.allFlags);
        this.vessels = this.sortAndDecorate(this.allVessels);
        return "input";
    }

    public String loadGrid() throws Exception {
        this.tripListModel = this.getT3Session().getTripListModel();
        return "input";
    }

    public String backToTrip() throws Exception {
        this.back = true;
        return this.input();
    }
}

