/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.io.input;

import com.opensymphony.xwork2.inject.Inject;
import fr.ird.t3.actions.io.input.AnalyzeInputSourceConfiguration;
import fr.ird.t3.io.input.T3InputProvider;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.util.ZipUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigureImportDataAction
extends AbstractConfigureAction<AnalyzeInputSourceConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureImportDataAction.class);
    public static final String RELOAD_ACTION = "reload";
    private List<T3InputProvider> inputProviders;
    protected File sourceToLoad;
    protected String sourceToLoadFileName;
    protected boolean useWells;
    protected boolean samplesOnly;
    protected boolean canCreateVessel;
    protected boolean createVirtualVessel;
    private String treatmentDirectoryPath;
    private String loadedSource;
    private String inputProviderId;
    protected long maxSize;

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    public String getMaxSize() {
        return StringUtil.convertMemory((long)this.maxSize);
    }

    public ConfigureImportDataAction() {
        super(AnalyzeInputSourceConfiguration.class);
    }

    public void prepare() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class});
        this.inputProviders = !this.isConfigurationInSession() ? Arrays.asList(this.getT3InputService().getProviders()) : Arrays.asList(((AnalyzeInputSourceConfiguration)this.getConfiguration()).getInputProvider());
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
        if (this.getTreatmentDirectoryPath() == null) {
            File workingDirectory = ConfigureImportDataAction.getApplicationConfig().getTreatmentWorkingDirectory();
            long l = System.nanoTime();
            File treatmentDirectory = new File(workingDirectory, "importData-" + l);
            FileUtil.createDirectoryIfNecessary((File)treatmentDirectory);
            if (log.isInfoEnabled()) {
                log.info((Object)("Create a new treatment directory path : " + treatmentDirectory));
            }
            this.setTreatmentDirectoryPath(treatmentDirectory.getAbsolutePath());
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Use existing treatment directory " + this.getTreatmentDirectoryPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doAddSource() throws Exception {
        File upload = this.getSourceToLoad();
        if (upload == null) {
            String message = this._("t3.error.required.file.to.upload", new Object[0]);
            this.addFieldError("sourceToLoad", message);
            log.error((Object)message);
            return "error";
        }
        File targetDirectory = this.getTreatmentDirectory();
        String filename = this.getSourceToLoadFileName();
        if (ZipUtil.isZipFile((File)upload)) {
            ZipFile zipfile = new ZipFile(upload);
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            if (!entries.hasMoreElements()) {
                String message = this._("t3.error.required.one.entry.in.zip.to.upload", new Object[0]);
                this.addFieldError("sourceToLoad", message);
                log.error((Object)message);
                return "error";
            }
            ZipEntry zipEntry = entries.nextElement();
            filename = zipEntry.getName();
            File target = new File(targetDirectory, filename);
            if (log.isInfoEnabled()) {
                log.info((Object)("Will copy loaded zipped entry file " + filename + " to treatment configuration directory " + target));
            }
            InputStream in = zipfile.getInputStream(zipEntry);
            try {
                FileUtils.copyInputStreamToFile((InputStream)in, (File)target);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            File target = new File(targetDirectory, filename);
            if (log.isInfoEnabled()) {
                log.info((Object)("Will copy loaded file " + upload + " to treatment configuration directory " + target));
            }
            FileUtils.copyFile((File)upload, (File)target);
        }
        this.setLoadedSource(filename);
        return "input";
    }

    public String doDeleteSource() throws Exception {
        boolean delete;
        File f;
        String filename = this.getLoadedSource();
        File targetDirectory = this.getTreatmentDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete loaded file " + filename + " from " + targetDirectory));
        }
        if ((f = new File(targetDirectory, filename)).exists() && !(delete = f.delete())) {
            throw new IOException("Could not delete file " + f + " on server.");
        }
        this.setLoadedSource(null);
        return "input";
    }

    public String doPrepareAnalyze() throws Exception {
        T3InputProvider inputProvider = this.getT3InputService().getProvider(this.getInputProviderId());
        File path = this.getTreatmentDirectory();
        String name = this.getLoadedSource();
        File inputFile = new File(path, name);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use input provider : " + inputProvider));
            log.info((Object)("Will use input file     : " + inputFile));
        }
        this.configuration = AnalyzeInputSourceConfiguration.newConfiguration((T3InputProvider)inputProvider, (File)inputFile, (boolean)this.useWells, (boolean)this.samplesOnly, (boolean)this.canCreateVessel, (boolean)this.createVirtualVessel);
        this.prepareActionContext();
        return "success";
    }

    public File getSourceToLoad() {
        return this.sourceToLoad;
    }

    public String getSourceToLoadFileName() {
        return this.sourceToLoadFileName;
    }

    public void setSourceToLoad(File sourceToLoad) {
        this.sourceToLoad = sourceToLoad;
    }

    public void setSourceToLoadFileName(String sourceToLoadFileName) {
        this.sourceToLoadFileName = sourceToLoadFileName;
    }

    public boolean isUseWells() {
        return this.useWells;
    }

    public void setUseWells(boolean useWells) {
        this.useWells = useWells;
    }

    public boolean isSamplesOnly() {
        return this.samplesOnly;
    }

    public void setSamplesOnly(boolean samplesOnly) {
        this.samplesOnly = samplesOnly;
    }

    public boolean isCanCreateVessel() {
        return this.canCreateVessel;
    }

    public void setCanCreateVessel(boolean canCreateVessel) {
        this.canCreateVessel = canCreateVessel;
    }

    public boolean isCreateVirtualVessel() {
        return this.createVirtualVessel;
    }

    public void setCreateVirtualVessel(boolean createVirtualVessel) {
        this.createVirtualVessel = createVirtualVessel;
    }

    public String getInputProviderId() {
        return this.inputProviderId;
    }

    public void setInputProviderId(String inputProviderId) {
        this.inputProviderId = inputProviderId;
    }

    public String getLoadedSource() {
        return this.loadedSource;
    }

    public void setLoadedSource(String loadedSource) {
        this.loadedSource = loadedSource;
    }

    public String getTreatmentDirectoryPath() {
        return this.treatmentDirectoryPath;
    }

    public void setTreatmentDirectoryPath(String treatmentDirectoryPath) {
        this.treatmentDirectoryPath = treatmentDirectoryPath;
    }

    public final List<T3InputProvider> getInputProviders() {
        return this.inputProviders;
    }

    protected File getTreatmentDirectory() {
        String path = this.getTreatmentDirectoryPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }
}

