/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.json;

import com.google.common.collect.Maps;
import fr.ird.t3.entities.reference.zone.ZoneStratumAwareMeta;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.web.struts2.interceptor.TopiaTransactionInterceptor;

@TopiaTransactionInterceptor.NoCommit
public class GetZoneVersionsAction
extends T3BaseTransactionAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GetZoneVersionsAction.class);
    protected String zoneTypeId;
    protected Map<String, String> zoneVersions;

    public void setZoneTypeId(String zoneTypeId) {
        this.zoneTypeId = zoneTypeId;
    }

    public Map<String, String> getZoneVersions() {
        return this.zoneVersions;
    }

    public String execute() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("zoneTypeId = " + this.zoneTypeId));
        }
        this.zoneVersions = Maps.newLinkedHashMap();
        if (!StringUtils.isEmpty((CharSequence)this.zoneTypeId)) {
            ZoneStratumAwareMeta zoneType = this.getZoneStratumService().getZoneMetaById(this.zoneTypeId);
            List allVersions = zoneType.getAllZoneVersions(this.getTransaction());
            this.zoneVersions = this.sortAndDecorateIdAbles((Collection)allVersions);
        }
        return "success";
    }
}

