/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.json;

import com.google.common.collect.Lists;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.entities.user.UserDatabase;
import fr.ird.t3.entities.user.UserDatabaseDTO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractGetUserDatabasesAction<T extends UserDatabase>
extends T3BaseTransactionAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractGetUserDatabasesAction.class);
    protected String userId;
    protected Collection<UserDatabaseDTO> databases;

    public abstract Collection<UserDatabaseDTO> getDatabases();

    protected abstract Collection<T> getDatabases(T3User var1);

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String execute() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("userId = " + this.userId));
        }
        T3User user = this.getUserService().getUserById(this.userId);
        this.databases = Lists.newArrayList();
        Collection dbs = this.getDatabases(user);
        if (CollectionUtils.isNotEmpty((Collection)dbs)) {
            for (UserDatabase userDatabase : dbs) {
                this.databases.add(userDatabase.toDTO());
            }
        }
        return "success";
    }
}

