/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.Preparable;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.actions.admin.DeleteTripConfiguration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.data.TripImpl;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.web.struts2.interceptor.TopiaTransactionInterceptor;

public class TripAction
extends T3BaseTransactionAction
implements Preparable {
    private static final long serialVersionUID = 1L;
    public static final String BACK_TO_LIST = "backToList";
    public static final String DO_DELETE = "doDelete";
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    protected List<String> tripIds;
    protected Map<String, String> tripsToDelete;
    protected Trip trip;
    protected String tripEditAction;

    public String input() throws Exception {
        String id = this.getTrip().getTopiaId();
        if (!StringUtils.isEmpty((CharSequence)id)) {
            this.trip = (Trip)this.tripDAO.findByTopiaId(id);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getTripIds())) {
            this.tripsToDelete = Maps.newTreeMap();
            Decorator decorator = this.getDecorator(Trip.class);
            for (String tripId : this.tripIds) {
                Trip aTrip = (Trip)this.tripDAO.findByTopiaId(tripId);
                String s = decorator.toString((Object)aTrip);
                this.tripsToDelete.put(tripId, s);
            }
        }
        return "input";
    }

    @TopiaTransactionInterceptor.NoCommit
    public String doDelete() throws Exception {
        return this.startDeleteData(true);
    }

    @TopiaTransactionInterceptor.NoCommit
    public String doDeleteComputedData() throws Exception {
        return this.startDeleteData(false);
    }

    public List<String> getTripIds() {
        if (this.tripIds == null) {
            this.tripIds = Lists.newArrayList();
        }
        return this.tripIds;
    }

    public void setTripIds(List<String> tripIds) {
        this.tripIds = tripIds;
    }

    public Trip getTrip() {
        if (this.trip == null) {
            this.trip = new TripImpl();
        }
        return this.trip;
    }

    public Map<String, String> getTripsToDelete() {
        return this.tripsToDelete;
    }

    public String getTripEditAction() {
        return this.tripEditAction;
    }

    public void setTripEditAction(String tripEditAction) {
        this.tripEditAction = tripEditAction;
    }

    public void prepare() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class});
    }

    protected String startDeleteData(boolean deleteTrips) {
        List ids = this.getTripIds();
        DeleteTripConfiguration conf = new DeleteTripConfiguration();
        conf.setTripIds((Collection)ids);
        conf.setDeleteTrip(deleteTrips);
        T3ActionContext t3ActionContext = T3ActionContext.newT3ActionContext((T3ActionConfiguration)conf, (Locale)this.getLocale());
        this.getT3Session().setActionContext(t3ActionContext);
        return DO_DELETE;
    }
}

