/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.zone;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import fr.ird.t3.entities.reference.zone.Zone;
import fr.ird.t3.services.T3ServiceSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AbstractZoneImporter<Z extends Zone, D extends TopiaDAO<Z>>
extends T3ServiceSupport {
    private static final Log log = LogFactory.getLog(AbstractZoneImporter.class);
    protected final String versionId;
    protected final String versionLibelle;
    protected final String versionStartDate;
    protected final String versionEndDate;
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd ");
    protected D dao;
    protected final int nbRequiedCell;

    public AbstractZoneImporter(String versionId, String versionLibelle, Date versionStartDate, Date versionEndDate, int nbRequiedCell) {
        this.versionId = versionId;
        this.versionLibelle = versionLibelle;
        this.versionStartDate = this.formatDate(versionStartDate);
        this.versionEndDate = this.formatDate(versionEndDate);
        this.nbRequiedCell = nbRequiedCell;
    }

    protected abstract D getDAO() throws TopiaException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InputStream inputStream, File outputFile) throws Exception {
        this.dao = this.getDAO();
        List zones = this.dao.findAll();
        if (CollectionUtils.isNotEmpty((Collection)zones)) {
            for (Zone zone : zones) {
                this.dao.delete((TopiaEntity)zone);
            }
        }
        this.prepareExecute();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, false));){
            if (log.isInfoEnabled()) {
                log.info((Object)("Will create update sql file in " + outputFile));
            }
            List<Z> universe = this.loadFile(inputStream, writer);
            if (log.isInfoEnabled()) {
                log.info((Object)("Will add " + universe.size() + " entities in ZoneET table."));
            }
        }
        this.getTransaction().commitTransaction();
    }

    protected void prepareExecute() throws TopiaException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Z> loadFile(InputStream inputStream, BufferedWriter writer) throws TopiaException, IOException {
        ArrayList result = Lists.newArrayList();
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream, Charsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] cells;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incoming line : " + line));
                }
                if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                int lineNumber = reader.getLineNumber();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("At Line [" + lineNumber + "] Data line to treat : " + line));
                }
                if ((cells = line.split("\\|")).length != this.nbRequiedCell) {
                    throw new IllegalStateException("At line [" + lineNumber + "], data line must have " + this.nbRequiedCell + " cells but had here " + cells.length);
                }
                String insertLine = this.loadLine(result, lineNumber, cells);
                writer.newLine();
                writer.append(insertLine);
            }
        }
        return result;
    }

    protected abstract String loadLine(List<Z> var1, int var2, String[] var3) throws TopiaException;

    protected String formatDate(Date date) {
        String result;
        if (date == null) {
            result = "null";
        } else {
            String f = this.dateFormat.format(date);
            result = "TIMESTAMP '" + f + " 00:00:00.0'";
        }
        return result;
    }

    protected int convertToInt(String[] cells, int lineNumber, int cellNumber) {
        String cell = cells[cellNumber];
        try {
            Integer result = Integer.valueOf(cell.trim());
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("At line [" + lineNumber + "], cell [" + cellNumber + "] could not format " + cell + " to integer");
        }
    }

    protected String convertToString(String[] cells, int lineNumber, int cellNumber) {
        String cell = cells[cellNumber].trim();
        return cell;
    }
}

