/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.RF1SpeciesForFleet;
import fr.ird.t3.entities.reference.RF1SpeciesForFleetDAO;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.tools.db.reference.AbstractReferenceImporter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class RF1SpecieForFleetImporter
extends AbstractReferenceImporter<RF1SpeciesForFleet> {
    private static final Log log = LogFactory.getLog(RF1SpecieForFleetImporter.class);
    @InjectDAO(entityType=RF1SpeciesForFleet.class)
    protected RF1SpeciesForFleetDAO dao;
    @InjectFromDAO(entityType=Country.class)
    protected List<Country> countries;
    @InjectFromDAO(entityType=Species.class)
    protected List<Species> species;
    protected Map<Integer, Country> countryByCode;
    protected Map<Integer, Species> specieByCode;

    @Override
    protected void before() throws TopiaException {
        if (CollectionUtils.isEmpty(this.countries)) {
            throw new IllegalStateException("No country found in db.");
        }
        if (CollectionUtils.isEmpty(this.species)) {
            throw new IllegalStateException("No species found in db.");
        }
        long nb = this.dao.count();
        if (nb > 0L) {
            throw new IllegalStateException("Some RF1SpeciesForFleet found in db.");
        }
        this.countryByCode = T3EntityHelper.splitBycode(this.countries);
        this.specieByCode = T3EntityHelper.splitBycode(this.species);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<RF1SpeciesForFleet> loadFile(File inputFile) throws TopiaException, IOException {
        ArrayList<RF1SpeciesForFleet> result = new ArrayList<RF1SpeciesForFleet>();
        try (LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] cells;
                if (line.trim().startsWith("#")) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incoming line : " + line));
                }
                int lineNumber = reader.getLineNumber();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("At Line [" + lineNumber + "] Data line to treat : " + line));
                }
                if ((cells = line.split(":")).length != 2) {
                    throw new IllegalStateException("At line [" + lineNumber + "], data line must have 2 cells but had here " + cells.length);
                }
                this.loadLine(result, lineNumber, cells, this.countryByCode, this.specieByCode, this.dao);
            }
        }
        return result;
    }

    protected void loadLine(List<RF1SpeciesForFleet> result, int lineNumber, String[] cells, Map<Integer, Country> countryByCode, Map<Integer, Species> specieByCode, RF1SpeciesForFleetDAO dao) throws TopiaException {
        int countryCode = this.convertToInt(cells, lineNumber, 0);
        Country country = this.getCountry(countryByCode, countryCode, lineNumber);
        int specieCode = this.convertToInt(cells, lineNumber, 1);
        Species species = this.getSpecie(specieByCode, specieCode, lineNumber);
        RF1SpeciesForFleet rf1SpeciesForFleet = (RF1SpeciesForFleet)dao.create(new Object[]{"country", country, "species", species});
        result.add(rf1SpeciesForFleet);
    }
}

