/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.services.IOCService;
import fr.ird.t3.services.T3ServiceSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaTransactionAware;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AbstractReferenceImporter<E extends TopiaEntity>
extends T3ServiceSupport
implements TopiaTransactionAware {
    private static final Log log = LogFactory.getLog(AbstractReferenceImporter.class);

    public void setTransaction(TopiaContext transaction) {
    }

    public final void execute(File inputFile) throws Exception {
        ((IOCService)this.newService(IOCService.class)).injectExcept((Object)this, new Class[0]);
        this.before();
        List<E> universe = this.loadFile(inputFile);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will add " + universe.size() + " entities."));
        }
        this.getTransaction().commitTransaction();
    }

    protected abstract void before() throws TopiaException;

    protected abstract List<E> loadFile(File var1) throws TopiaException, IOException;

    protected final int convertToInt(String[] cells, int lineNumber, int cellNumber) {
        String cell = cells[cellNumber];
        try {
            Integer result = Integer.valueOf(cell.trim());
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("At line [" + lineNumber + "], cell [" + cellNumber + "] could not format " + cell + " to integer");
        }
    }

    protected final int convertToIntTenTimes(String[] cells, int lineNumber, int cellNumber) {
        String cell = cells[cellNumber];
        try {
            int result = (int)(Float.valueOf(cell.trim()).floatValue() * 10.0f);
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("At line [" + lineNumber + "], cell [" + cellNumber + "] could not format " + cell + " to integer");
        }
    }

    protected final float convertToFloat(String[] cells, int lineNumber, int cellNumber) {
        String cell = cells[cellNumber];
        try {
            float result = Float.valueOf(cell.trim()).floatValue();
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("At line [" + lineNumber + "], cell [" + cellNumber + "] could not format " + cell + " to float");
        }
    }

    protected final Species getSpecie(Map<Integer, Species> specieByCode, int specieCode, int lineNumber) {
        Species species = specieByCode.get(specieCode);
        if (species == null) {
            throw new NullPointerException("At line [" + lineNumber + "], species with code [" + specieCode + "] does not exists in db.");
        }
        return species;
    }

    protected final Ocean getOcean(Map<Integer, Ocean> oceanByCode, int oceanCode, int lineNumber) {
        Ocean ocean = oceanByCode.get(oceanCode);
        if (ocean == null) {
            throw new NullPointerException("At line [" + lineNumber + "], ocean with code [" + oceanCode + "] does not exists in db.");
        }
        return ocean;
    }

    protected final Country getCountry(Map<Integer, Country> countryBycode, int countryCode, int lineNumber) {
        Country ocean = countryBycode.get(countryCode);
        if (ocean == null) {
            throw new NullPointerException("At line [" + lineNumber + "], country with code [" + countryCode + "] does not exists in db.");
        }
        return ocean;
    }
}

