/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.Section;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.Tdr;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.longline.SensorBrand;
import fr.ird.observe.entities.referentiel.longline.SensorPosition;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.TdrUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public class TdrUIHandler
extends ContentTableUIHandler<SetLongline, Tdr> {
    private static Log log = LogFactory.getLog(TdrUIHandler.class);
    protected boolean locationIsAdjusting;
    protected final PropertyChangeListener sectionChanged = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TdrUIHandler.this.locationIsAdjusting = true;
            try {
                Section oldValue = (Section)evt.getOldValue();
                Section newValue = (Section)evt.getNewValue();
                TdrUI ui = TdrUIHandler.this.getUi();
                Tdr tableEditBean = (Tdr)evt.getSource();
                Basket basket = tableEditBean.getBasket();
                Branchline branchline = tableEditBean.getBranchline();
                if (newValue == null) {
                    ui.getBasket().setData(Collections.emptyList());
                    ui.getBranchline().setData(Collections.emptyList());
                    tableEditBean.setBasket(null);
                    tableEditBean.setBranchline(null);
                } else {
                    ui.getBranchline().setData(Collections.emptyList());
                    tableEditBean.setBasket(null);
                    tableEditBean.setBranchline(null);
                }
            }
            finally {
                TdrUIHandler.this.locationIsAdjusting = false;
            }
        }
    };
    protected final PropertyChangeListener basketChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!TdrUIHandler.this.locationIsAdjusting) {
                Basket oldValue = (Basket)evt.getNewValue();
                Basket newValue = (Basket)evt.getNewValue();
                TdrUI ui = TdrUIHandler.this.getUi();
                Tdr tableEditBean = (Tdr)evt.getSource();
                Branchline branchline = tableEditBean.getBranchline();
                if (newValue == null) {
                    ui.getBranchline().setData(Collections.emptyList());
                } else {
                    ui.getBranchline().setData(Collections.emptyList());
                }
                tableEditBean.setBranchline(null);
            }
        }
    };
    JAXXContextEntryDef<List<Section>> ALL_SECTIONS_ENTRY = UIHelper.newListContextEntryDef((String)"TdrUI-all-sections");

    public TdrUIHandler(TdrUI ui) {
        super(ui, DataContextType.SetLongline);
    }

    @Override
    public TdrUI getUi() {
        return (TdrUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, Tdr bean, boolean create) {
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        String homeId = bean.getHomeId();
        TdrUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected tdr " + homeId));
        }
        JTextField requestFocus = ui.getHomeId();
        Tdr tableEditBean = (Tdr)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("section", this.sectionChanged);
        tableEditBean.addPropertyChangeListener("section", this.sectionChanged);
        tableEditBean.removePropertyChangeListener("basket", this.basketChanged);
        tableEditBean.addPropertyChangeListener("basket", this.basketChanged);
        if (create) {
            SetLongline setLongline = (SetLongline)this.getBean();
            Date settingStartTimeStamp = setLongline.getSettingStartTimeStamp();
            tableEditBean.setDeployementStart(settingStartTimeStamp);
            tableEditBean.setDeployementEnd(settingStartTimeStamp);
            tableEditBean.setFishingStart(settingStartTimeStamp);
            tableEditBean.setFishingEnd(settingStartTimeStamp);
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.tdr.table.homeId", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.homeId.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.serialNo", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.serialNo.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorBrand", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorBrand.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorPosition", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorPosition.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorBrand.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorPosition.class));
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListLonglineCatch();
        Set speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
        this.getUi().getSpecies().putClientProperty("listPredicate", Species2.newSpeciesByIdPredicate((Set)speciesIds));
        super.initUI();
    }

    @Override
    protected SetLongline loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        SetLongline setLongline = (SetLongline)super.loadEditBean(mode, dataContext, dataService, dataSource);
        List sectionList = dataService.getSections(dataSource, setLongline.getTopiaId());
        if (!setLongline.isSectionEmpty()) {
            sectionList.addAll(setLongline.getSection());
        }
        this.ALL_SECTIONS_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)sectionList);
        return setLongline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSpecies(Tdr bean, Object[] selected) {
        boolean update;
        if (!this.getModel().isEditing()) {
            return;
        }
        boolean bl = update = selected.length != bean.sizeSpecies();
        if (!update && selected.length > 0) {
            Collection list = bean.getSpecies();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getSpecies().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                ArrayList<Species> newList = new ArrayList<Species>(selected.length);
                for (Object o : selected) {
                    newList.add((Species)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update species " + newList.size()));
                }
                bean.setSpecies(newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    protected int[] updateIndices(Collection<Species> list) {
        int i;
        if (log.isInfoEnabled()) {
            log.info((Object)(list == null ? 0 : list.size()));
        }
        List ids = list == null ? Collections.emptyList() : TopiaEntityHelper.getTopiaIdList(list);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            ListModel model = this.getUi().getSpecies().getModel();
            int max = model.getSize();
            for (i = 0; i < max; ++i) {
                Species s = (Species)model.getElementAt(i);
                if (!ids.contains(s.getTopiaId())) continue;
                indices.add(i);
            }
        }
        int[] result = new int[indices.size()];
        i = 0;
        for (Integer indice : indices) {
            result[i++] = indice;
        }
        indices.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected indices : " + Arrays.toString(result)));
        }
        return result;
    }
}

