/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import fr.ird.observe.BinderService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ObserveContentTableUI;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public abstract class ContentTableUIModel<E extends TopiaEntity, D extends TopiaEntity>
extends ContentUIModel<E> {
    public static final String PROPERTY_CAN_SAVE_ROW = "canSaveRow";
    public static final String PROPERTY_CAN_RESET_ROW = "canResetRow";
    public static final String PROPERTY_SHOW_DATA = "showData";
    public static final String PROPERTY_ROW_SAVED = "rowSaved";
    private static Log log = LogFactory.getLog(ContentTableUIModel.class);
    protected final Class<D> childType;
    protected final String[] parentProperties;
    protected final String[] childProperties;
    private final ListSelectionModel selectionModel;
    protected D tableEditBean;
    protected boolean canSaveRow;
    protected boolean canResetRow;
    protected boolean showData;
    protected boolean rowSaved;
    private ContentTableModel<E, D> tableModel;
    private TopiaEntityBinder<D> childLoador;
    private EntityListUpdator<E, D> childsUpdator;

    public ContentTableUIModel(Class<E> beanType, Class<D> childType, String[] parentProperties, String[] childProperties) {
        super(beanType);
        this.childType = childType;
        this.parentProperties = parentProperties;
        this.childProperties = childProperties;
        this.selectionModel = new ContentTableListSelectionModel();
    }

    public static <E extends TopiaEntity, D extends TopiaEntity> ContentTableUIModel<E, D> newModel(ObserveContentTableUI<E, D> ui) {
        String uiName = ui.getClass().getName();
        String modelName = uiName + "Model";
        try {
            Class<?> modelClass = Class.forName(modelName);
            ContentTableUIModel model = (ContentTableUIModel)ConstructorUtils.invokeConstructor(modelClass, (Object[])new Object[]{ui});
            return model;
        }
        catch (Exception e) {
            throw new ObserveTechnicalException("Could not create model for ui: " + ui, (Throwable)e);
        }
    }

    @Override
    protected BinderModelBuilder<E, E> createOpeningBinder(BinderService binderService, String binderName) {
        String[] properties = this.getParentProperties();
        BinderModelBuilder builder = binderService.newBinderBuilder(this.getBeanType(), properties);
        builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{properties[0]});
        return builder;
    }

    public void initModel(ObserveContentTableUI<E, D> ui, List<ContentTableMeta<D>> metas) {
        this.tableModel = new ContentTableModel<E, D>(ui, metas);
        this.childsUpdator = EntityListUpdator.newEntityListUpdator(this.getBeanType(), this.getChildType(), (String)this.getParentProperties()[0]);
        String binderName = this.getClass().getName() + "-open";
        Class<D> childBeanType = this.getChildType();
        BinderService binderService = ObserveServiceHelper.get().getBinderService();
        this.childLoador = binderService.getTopiaBinder(childBeanType, binderName);
        if (this.childLoador == null) {
            BinderModelBuilder<D, D> builder = this.prepareChildLoador(binderService, binderName);
            this.childLoador = binderService.registerTopiaBinder(childBeanType, builder, binderName);
        }
    }

    public final EntityListUpdator<E, D> getChildsUpdator() {
        return this.childsUpdator;
    }

    public final TopiaEntityBinder<D> getChildLoador() {
        return this.childLoador;
    }

    public Class<D> getChildType() {
        return this.childType;
    }

    public String[] getParentProperties() {
        return this.parentProperties;
    }

    public String[] getChildProperties() {
        return this.childProperties;
    }

    public ContentTableModel<E, D> getTableModel() {
        return this.tableModel;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public D getTableEditBean() {
        block3: {
            if (this.tableEditBean == null) {
                try {
                    this.tableEditBean = this.newTableEditBean();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)e);
                }
            }
        }
        return this.tableEditBean;
    }

    public final D newTableEditBean() {
        try {
            Class klass = ObserveDAOHelper.getImplementationClass(this.getChildType());
            return (D)((TopiaEntity)klass.newInstance());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isCanSaveRow() {
        return this.canSaveRow;
    }

    public void setCanSaveRow(boolean canSaveRow) {
        boolean oldValue = this.canSaveRow;
        this.canSaveRow = canSaveRow;
        this.firePropertyChange(PROPERTY_CAN_SAVE_ROW, oldValue, canSaveRow);
    }

    public boolean isCanResetRow() {
        return this.canResetRow;
    }

    public void setCanResetRow(boolean canResetRow) {
        boolean oldValue = this.canResetRow;
        this.canResetRow = canResetRow;
        this.firePropertyChange(PROPERTY_CAN_RESET_ROW, oldValue, canResetRow);
    }

    public boolean isRowSaved() {
        return this.rowSaved;
    }

    public void setRowSaved(boolean rowSaved) {
        boolean oldValue = this.rowSaved;
        this.rowSaved = rowSaved;
        this.firePropertyChange(PROPERTY_ROW_SAVED, oldValue, rowSaved);
    }

    public boolean isShowData() {
        return this.showData;
    }

    public void setShowData(boolean showData) {
        boolean oldValue = this.showData;
        this.showData = showData;
        this.firePropertyChange(PROPERTY_SHOW_DATA, oldValue, showData);
    }

    protected BinderModelBuilder<D, D> prepareChildLoador(BinderService binderService, String binderName) {
        String[] properties = this.getChildProperties();
        BinderModelBuilder builder = binderService.newBinderBuilder(this.childType, properties);
        return builder;
    }

    public class ContentTableListSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1L;

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(index0 + " - " + index1));
            }
            ContentTableModel model = ContentTableUIModel.this.getTableModel();
            boolean canContinue = this.canContinue(model, index0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("can continue  for row " + index0 + " : " + canContinue));
            }
            if (canContinue) {
                super.setSelectionInterval(index0, index1);
            }
        }

        protected boolean canContinue(ContentTableModel<?, ?> model, int newIndex) {
            if (model == null) {
                return false;
            }
            if (!model.isEditable()) {
                return true;
            }
            if (model.isValueAdjusting()) {
                return true;
            }
            int editingRow = model.getSelectedRow();
            if (this.isSelectionEmpty() || editingRow == -1) {
                return true;
            }
            if (editingRow == newIndex) {
                return true;
            }
            boolean canContinue = model.isCanQuitEditingRow();
            return canContinue;
        }
    }
}

