/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.list.impl.seine.ActivitySeinesUI;
import fr.ird.observe.ui.content.open.ContentOpenableUI;
import fr.ird.observe.ui.content.open.impl.seine.ActivitySeineUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import org.nuiton.i18n.I18n;

public class CloseOpenUIAction
extends AbstractUIAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_NAME = "closeOpen";

    public CloseOpenUIAction(ObserveMainUI mainUI) {
        super(mainUI, ACTION_NAME, I18n.n((String)"observe.action.close.open", (Object[])new Object[0]), I18n.n((String)"observe.action.close.open.tip", (Object[])new Object[0]), "close");
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent c = (JComponent)e.getSource();
                ContentUI ui = (ContentUI)c.getClientProperty("ui");
                if (ui == null) {
                    throw new IllegalStateException("could not find client property ui on component" + c);
                }
                if (ui instanceof ContentOpenableUI) {
                    ((ContentOpenableUI)ui).closeData();
                    return;
                }
                if (ui instanceof ActivitySeinesUI) {
                    JTree tree = CloseOpenUIAction.this.getMainUI().getNavigation();
                    ObserveTreeHelper treeHelper = CloseOpenUIAction.this.getMainUI().getTreeHelper();
                    ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
                    boolean wasCollapsed = AbstractUIAction.isOpenActivityNodeCollapsed(tree, treeHelper, CloseOpenUIAction.this.getMainUI().getDataContext());
                    treeHelper.selectOpenNode((JAXXContext)CloseOpenUIAction.this.getMainUI(), ActivitySeine.class);
                    TreePath path = tree.getSelectionPath();
                    ActivitySeineUI selectedUI = (ActivitySeineUI)ObserveContext.get().getSelectedContentUI();
                    selectedUI.closeData();
                    if (wasCollapsed) {
                        tree.collapsePath(path);
                    }
                    treeHelper.selectNode((NavNode)node);
                    return;
                }
                throw new IllegalStateException("Can not come here!");
            }
        });
    }
}

