/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.entities.longline.SectionTemplate;
import fr.ird.observe.entities.longline.SectionWithTemplate;
import fr.ird.observe.entities.longline.SectionWithTemplateImpl;
import fr.ird.observe.ui.content.impl.longline.LonglineCompositionTableModelSupport;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionsTableModel
extends LonglineCompositionTableModelSupport<SectionWithTemplate> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SectionsTableModel.class);
    public static final String TEMPLATE_PROPERTY = "template";

    public SectionsTableModel(LonglineDetailCompositionUIModel model) {
        super(model);
    }

    @Override
    public boolean isRowNotEmpty(SectionWithTemplate row) {
        return row.getSettingIdentifier() != null || row.getHaulingIdentifier() != null;
    }

    @Override
    public boolean isRowValid(SectionWithTemplate row) {
        return row.getSettingIdentifier() != null && row.getHaulingIdentifier() != null;
    }

    @Override
    protected SectionWithTemplate createNewRow() {
        return new SectionWithTemplateImpl();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result;
        switch (columnIndex) {
            case 0: {
                result = false;
                break;
            }
            case 1: {
                result = !this.isGenerateHaulingIds();
                break;
            }
            case 2: {
                result = this.isCanGenerate();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Integer result;
        SectionWithTemplate row = (SectionWithTemplate)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = row.getSettingIdentifier();
                break;
            }
            case 1: {
                result = row.getHaulingIdentifier();
                break;
            }
            case 2: {
                result = row.getSectionTemplate();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SectionWithTemplate row = (SectionWithTemplate)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setSettingIdentifier((Integer)aValue);
                this.setModified(true);
                break;
            }
            case 1: {
                row.setHaulingIdentifier((Integer)aValue);
                this.setModified(true);
                break;
            }
            case 2: {
                int basketsCount;
                boolean compiliantWithBasketCount;
                SectionTemplate sectionTemplate = (SectionTemplate)aValue;
                boolean changeTemplate = true;
                if (sectionTemplate != null && !(compiliantWithBasketCount = sectionTemplate.isCompiliantWithBasketCount(basketsCount = row.sizeBasket()))) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("sectionTemplate " + sectionTemplate + " is not compliant with basketCount: " + basketsCount));
                    }
                    changeTemplate = false;
                }
                if (!changeTemplate) break;
                SectionTemplate previousSectionTemplate = row.getSectionTemplate();
                row.setSectionTemplate(sectionTemplate);
                this.firePropertyChange(TEMPLATE_PROPERTY, previousSectionTemplate, sectionTemplate);
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
    }
}

