/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompServiceAction.java 173 2011-05-27 08:32:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.2/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompServiceAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;

/**
 * User: couteau
 * Date: 01/02/11
 */
public class RefcompServiceAction {

        /**
         * log.
         */
        private static final Log log = LogFactory.getLog(RefcompServiceAction.class);

        /**
         * Reload solr index.
         */
        public static void reIndexSolr() {

            if (log.isInfoEnabled()) {
                log.info("Starting reIndex solr");
            }

            long startingTime = System.nanoTime();

            WikittyService service = ServiceFactory.getWikittyService();

            RefcompConfiguration config = RefcompConfiguration.getInstance();

            StorageService storageService = new StorageServiceImpl(new WikittyProxy(service),config);
            storageService.adminCreationIfDoNotExist();

            String token = service.login(
                    RefcompConfigurationHelper.getAdminLogin(config),
                    RefcompConfigurationHelper.getAdminPassword(config));

            service.syncSearchEngine(token);

            if (log.isInfoEnabled()) {
                log.info("ReIndex solr is finished in " +
                        StringUtil.convertTime(startingTime, System.nanoTime()));
            }
            System.exit(0);
        }
}
