/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: RefComp.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/RefComp.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.admin.cati.AdminCati;
import fr.inra.refcomp.client.admin.departments.AdminDepartments;
import fr.inra.refcomp.client.admin.frequencies.AdminFrequencies;
import fr.inra.refcomp.client.admin.skills.AdminSkills;
import fr.inra.refcomp.client.admin.units.AdminUnits;
import fr.inra.refcomp.client.admin.users.AdminUsers;
import fr.inra.refcomp.client.agent.SkillsTableScreen;
import fr.inra.refcomp.client.constants.Footer;
import fr.inra.refcomp.client.constants.Header;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class RefComp implements EntryPoint {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    protected static boolean loggedIn = false;

    public void onModuleLoad() {

        //Silent admin creation if it does not exist.
        service.adminCreationIfDoNotExist(new AsyncCallback<Void>() {
            @Override
            public void onFailure(Throwable caught) {
                //do nothing
            }
            @Override
            public void onSuccess(Void result) {
                //do nothing
            }
        });

        RootPanel.get("header").add(new Header());
        RootPanel.get("menu").add(new Menu());
        RootPanel.get("content").add(new Home());
        RootPanel.get("footer").add(new Footer());

        /** History management **/
        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = event.getValue();

                //reload Home page
                if (historyToken.equals("home")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new Home());
                }

                //reload Login page
                if (historyToken.equals("login")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new Login());
                }

                //Reload mySkills page
                if (historyToken.equals("mySkills")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new SkillsTableScreen(true));
                }

                if (historyToken.equals("adminSkills")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new AdminSkills());
                }

                if (historyToken.equals("adminFrequencies")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new AdminFrequencies());
                }

                if (historyToken.equals("adminCati")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new AdminCati());
                }

                if (historyToken.equals("adminDepartments")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new AdminDepartments());
                }

                if (historyToken.equals("adminUnits")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new AdminUnits());
                }

                if (historyToken.equals("adminUsers")) {
                    RootPanel.get("content").clear();
                    RootPanel.get("content").add(new AdminUsers());
                }

                //TODO JC 08/12/2010 add other pages
            }
        });

    }

    public static boolean isLoggedIn(){
        return loggedIn;
    }

    public static void logIn(){
        loggedIn = true;
    }

    public static void logOut(){
        service.logout(new RefcompCallBack<Void>() {
            @Override
            public void onSuccess(Void result) {
            }
        });

        loggedIn = false;
    }
}
