/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AdvancedParamsHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(AdvancedParamsHandler.class);
    protected AdvancedParamsUI tabUI;
    protected StorageChangeListener simulatorStorageListener;

    protected AdvancedParamsHandler(AdvancedParamsUI tabUI) {
        super(tabUI);
        this.tabUI = tabUI;
    }

    protected void initSimulAdvParamsSimulatorModel(StorageChangeEvent evt) {
        this.tabUI.fieldSimulAdvParamsSimulatorModel.setElementList(SimulatorStorage.getSimulatorNames());
        SimulationParameter params = this.getParameters();
        this.tabUI.fieldSimulAdvParamsSimulatorSelect.setSelectedItem(params.getSimulatorName());
    }

    protected void afterInit() {
        this.simulatorStorageListener = this::initSimulAdvParamsSimulatorModel;
        SimulatorStorage.addStorageListener(this.simulatorStorageListener);
        this.tabUI.tableTagValues.getSelectionModel().addListSelectionListener(e -> this.tabUI.setRemove(this.tabUI.tableTagValues.getSelectedRow() != -1));
        this.refresh();
    }

    public void refresh() {
        this.initSimulAdvParamsSimulatorModel(null);
        SimulationParameter params = this.getParameters();
        this.tabUI.fieldSimulationStatistique.setSelected(params.getUseStatistic());
        this.tabUI.fieldSimulationCache.setSelected(params.getUseCache());
        this.tabUI.fieldSimulAdvParamsSimulLoggerError.setSelected(params.isSimulErrorLevel());
        this.tabUI.fieldSimulAdvParamsSimulLoggerWarn.setSelected(params.isSimulWarnLevel());
        this.tabUI.fieldSimulAdvParamsSimulLoggerInfo.setSelected(params.isSimulInfoLevel());
        this.tabUI.fieldSimulAdvParamsSimulLoggerDebug.setSelected(params.isSimulDebugLevel());
        this.tabUI.fieldSimulAdvParamsScriptLoggerError.setSelected(params.isScriptErrorLevel());
        this.tabUI.fieldSimulAdvParamsScriptLoggerWarn.setSelected(params.isScriptWarnLevel());
        this.tabUI.fieldSimulAdvParamsScriptLoggerInfo.setSelected(params.isScriptInfoLevel());
        this.tabUI.fieldSimulAdvParamsScriptLoggerDebug.setSelected(params.isScriptDebugLevel());
        this.tabUI.fieldSimulAdvParamsLibLoggerError.setSelected(params.isLibErrorLevel());
        this.tabUI.fieldSimulAdvParamsLibLoggerWarn.setSelected(params.isLibWarnLevel());
        this.tabUI.fieldSimulAdvParamsLibLoggerInfo.setSelected(params.isLibInfoLevel());
        this.tabUI.fieldSimulAdvParamsLibLoggerDebug.setSelected(params.isLibDebugLevel());
        this.tabUI.fieldSimulAdvParamsSimulatorSelect.setSelectedItem(params.getSimulatorName());
        this.setTableTagValues();
    }

    protected void addTagValue() {
        this.addTagValue(this.tabUI.fieldTag.getText(), this.tabUI.fieldValue.getText());
        this.setTableTagValues();
        this.valueChanged(true);
    }

    protected void removeTagValue() {
        this.removeTagValue(this.tabUI.tableTagValues.getValueAt(this.tabUI.tableTagValues.getSelectedRow(), 0).toString());
        this.setTableTagValues();
        this.valueChanged(true);
    }

    protected void saveTagValues() {
        if (this.tabUI.fieldSimulAdvParamsSimulatorSelect.getSelectedIndex() != -1) {
            this.saveTagValue((String)this.tabUI.fieldSimulAdvParamsSimulatorSelect.getSelectedItem());
        }
        this.valueChanged(false);
    }

    protected void setSimulatorName() {
        if (this.tabUI.fieldSimulAdvParamsSimulatorSelect.getSelectedIndex() != -1) {
            this.getParameters().setSimulatorName((String)this.tabUI.fieldSimulAdvParamsSimulatorSelect.getSelectedItem());
            this.valueChanged(true);
        }
    }

    protected void setTableTagValues() {
        Map<String, String> tagValues = this.getParameters().getTagValue();
        Object[] columnName = new String[]{I18n.t((String)"isisfish.common.tag", (Object[])new Object[0]), I18n.t((String)"isisfish.common.value", (Object[])new Object[0])};
        if (tagValues != null) {
            DefaultTableModel model = new DefaultTableModel(columnName, tagValues.size()){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            int row = 0;
            for (String name : tagValues.keySet()) {
                model.setValueAt(name, row, 0);
                model.setValueAt(tagValues.get(name), row, 1);
                ++row;
            }
            this.tabUI.tableTagValues.setModel(model);
        }
    }

    protected void valueChanged(boolean b) {
        this.tabUI.setChanged(b);
    }

    public void addTagValue(String tag, String value) {
        this.getParameters().getTagValue().put(tag, value);
    }

    public void removeTagValue(String tag) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTagValue: " + tag));
        }
        this.getParameters().getTagValue().remove(tag);
    }

    public void saveTagValue(String simulatorName) {
        Map<String, String> tagValues = this.getParameters().getTagValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("call saveTagValue: " + String.valueOf(tagValues)));
        }
        IsisFish.config.setDefaultTagValues(tagValues);
        IsisFish.config.setSimulatorClassfile(simulatorName);
    }
}

