/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.strategy;

import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.StrategyEquationType;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.strategy.StrategyTabUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import java.awt.CardLayout;
import java.util.Objects;
import java.util.stream.IntStream;
import org.nuiton.i18n.I18n;

public class StrategyTabHandler
extends InputContentHandler<StrategyTabUI> {
    protected static final String INACTIVITY_AS_STRING = I18n.t((String)"isisfish.strategy.equation.inactivity", (Object[])new Object[0]);
    protected static final String EFFORT_AS_STRING = I18n.t((String)"isisfish.strategy.equation.effort", (Object[])new Object[0]);
    protected static final String NONE_AS_STRING = I18n.t((String)"isisfish.strategy.equation.none", (Object[])new Object[0]);
    protected boolean init;

    protected StrategyTabHandler(StrategyTabUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((StrategyTabUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((StrategyTabUI)this.inputContentUI).fieldStrategyName.setText("");
                ((StrategyTabUI)this.inputContentUI).fieldStrategyProportionSetOfVessels.setText("");
                ((StrategyTabUI)this.inputContentUI).fieldStrategyComment.setText("");
                this.refreshHidablePanel();
            }
            if (evt.getNewValue() != null) {
                this.init = true;
                this.setSetOfVesselsModel();
                ((StrategyTabUI)this.inputContentUI).fieldEquationType.setSelectedItem(this.getStringFromStrategyEquationType());
                this.refreshHidablePanel();
                this.init = false;
            }
        });
    }

    protected void setSetOfVesselsModel() {
        GenericComboModel<SetOfVessels> modelVessel = new GenericComboModel<SetOfVessels>(((StrategyTabUI)this.inputContentUI).getFisheryRegion().getSetOfVessels());
        ((StrategyTabUI)this.inputContentUI).fieldStrategySetOfVessels.setModel(modelVessel);
        ((StrategyTabUI)this.inputContentUI).fieldStrategySetOfVessels.setSelectedItem(((StrategyTabUI)this.inputContentUI).getBean().getSetOfVessels());
    }

    protected void setOfVesselsChanged() {
        if (!this.init) {
            ((StrategyTabUI)this.inputContentUI).getBean().setSetOfVessels((SetOfVessels)((StrategyTabUI)this.inputContentUI).fieldStrategySetOfVessels.getSelectedItem());
        }
    }

    protected void equationTypeUsedChanged() {
        if (!this.init) {
            StrategyEquationType strategyEquationType = this.getStrategyEquationTypeFromString();
            ((StrategyTabUI)this.inputContentUI).getBean().setEquationTypeUsed(strategyEquationType);
            if (strategyEquationType == StrategyEquationType.EFFORT) {
                IntStream.range(0, 12).forEach(i -> ((StrategyTabUI)this.inputContentUI).getBean().getStrategyMonthInfo().get(i).setNumberOfTrips(1.0));
            }
            this.refreshHidablePanel();
        }
    }

    protected void refreshHidablePanel() {
        if (((StrategyTabUI)this.inputContentUI).getBean() != null) {
            if (((StrategyTabUI)this.inputContentUI).getBean().isInactivityEquationUsed()) {
                ((CardLayout)((StrategyTabUI)this.inputContentUI).hidablePanel.getLayout()).show(((StrategyTabUI)this.inputContentUI).hidablePanel, "fieldUseInactivity");
            } else if (((StrategyTabUI)this.inputContentUI).getBean().isEffortEquationUsed()) {
                ((CardLayout)((StrategyTabUI)this.inputContentUI).hidablePanel.getLayout()).show(((StrategyTabUI)this.inputContentUI).hidablePanel, "fieldUseEffort");
            } else {
                ((CardLayout)((StrategyTabUI)this.inputContentUI).hidablePanel.getLayout()).show(((StrategyTabUI)this.inputContentUI).hidablePanel, "fieldUseNone");
            }
        }
    }

    protected String[] getStrategyEquationChoices() {
        return new String[]{NONE_AS_STRING, INACTIVITY_AS_STRING, EFFORT_AS_STRING};
    }

    private StrategyEquationType getStrategyEquationType() {
        StrategyEquationType equationTypeUsed = ((StrategyTabUI)this.inputContentUI).getBean() != null && ((StrategyTabUI)this.inputContentUI).getBean().getEquationTypeUsed() != null ? ((StrategyTabUI)this.inputContentUI).getBean().getEquationTypeUsed() : StrategyEquationType.NONE;
        return equationTypeUsed;
    }

    private StrategyEquationType getStrategyEquationTypeFromString() {
        String strategyEquationTypeAsString = (String)Objects.requireNonNull(((StrategyTabUI)this.inputContentUI).fieldEquationType.getSelectedItem());
        StrategyEquationType strategyEquationType = strategyEquationTypeAsString.equals(INACTIVITY_AS_STRING) ? StrategyEquationType.INACTIVITY : (strategyEquationTypeAsString.equals(EFFORT_AS_STRING) ? StrategyEquationType.EFFORT : StrategyEquationType.NONE);
        return strategyEquationType;
    }

    private String getStringFromStrategyEquationType() {
        switch (this.getStrategyEquationType()) {
            case INACTIVITY: {
                return INACTIVITY_AS_STRING;
            }
            case EFFORT: {
                return EFFORT_AS_STRING;
            }
            case NONE: {
                return NONE_AS_STRING;
            }
        }
        throw new IllegalArgumentException();
    }
}

